rule win_harnig_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.harnig."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.harnig"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebba be0cfb1473 56 6a03 e8???????? ff7508 }
            // n = 6, score = 100
            //   ebba                 | jmp                 0xffffffbc
            //   be0cfb1473           | mov                 esi, 0x7314fb0c
            //   56                   | push                esi
            //   6a03                 | push                3
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_1 = { be0cfb1473 56 6a03 e8???????? ff7508 ffd0 56 }
            // n = 7, score = 100
            //   be0cfb1473           | mov                 esi, 0x7314fb0c
            //   56                   | push                esi
            //   6a03                 | push                3
            //   e8????????           |                     
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ffd0                 | call                eax
            //   56                   | push                esi

        $sequence_2 = { e8???????? 6a04 8d4df8 51 6a06 ff750c ffd0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a04                 | push                4
            //   8d4df8               | lea                 ecx, [ebp - 8]
            //   51                   | push                ecx
            //   6a06                 | push                6
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ffd0                 | call                eax

        $sequence_3 = { 6a06 56 68???????? e8???????? 56 8d85b8fdffff }
            // n = 6, score = 100
            //   6a06                 | push                6
            //   56                   | push                esi
            //   68????????           |                     
            //   e8????????           |                     
            //   56                   | push                esi
            //   8d85b8fdffff         | lea                 eax, [ebp - 0x248]

        $sequence_4 = { ffd0 bb30ef0298 53 6a01 e8???????? 57 }
            // n = 6, score = 100
            //   ffd0                 | call                eax
            //   bb30ef0298           | mov                 ebx, 0x9802ef30
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   e8????????           |                     
            //   57                   | push                edi

        $sequence_5 = { 33ff 8945d0 68d34ee485 8d85b8fdffff 6a04 c745c03c000000 897dc8 }
            // n = 7, score = 100
            //   33ff                 | xor                 edi, edi
            //   8945d0               | mov                 dword ptr [ebp - 0x30], eax
            //   68d34ee485           | push                0x85e44ed3
            //   8d85b8fdffff         | lea                 eax, [ebp - 0x248]
            //   6a04                 | push                4
            //   c745c03c000000       | mov                 dword ptr [ebp - 0x40], 0x3c
            //   897dc8               | mov                 dword ptr [ebp - 0x38], edi

        $sequence_6 = { ffd7 6a06 56 68???????? e8???????? }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   6a06                 | push                6
            //   56                   | push                esi
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_7 = { e8???????? 56 8d85e0fdffff 50 ffd3 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   56                   | push                esi
            //   8d85e0fdffff         | lea                 eax, [ebp - 0x220]
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   e8????????           |                     

        $sequence_8 = { f3ab e8???????? 8d4df0 51 8d4dac 51 }
            // n = 6, score = 100
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   e8????????           |                     
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   51                   | push                ecx
            //   8d4dac               | lea                 ecx, [ebp - 0x54]
            //   51                   | push                ecx

        $sequence_9 = { 68d34ee485 8d85b8fdffff 6a04 c745c03c000000 897dc8 c745cc6c104000 }
            // n = 6, score = 100
            //   68d34ee485           | push                0x85e44ed3
            //   8d85b8fdffff         | lea                 eax, [ebp - 0x248]
            //   6a04                 | push                4
            //   c745c03c000000       | mov                 dword ptr [ebp - 0x40], 0x3c
            //   897dc8               | mov                 dword ptr [ebp - 0x38], edi
            //   c745cc6c104000       | mov                 dword ptr [ebp - 0x34], 0x40106c

    condition:
        7 of them and filesize < 49152
}