rule win_havex_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.havex_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.havex_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 56 50 51 ff15???????? 68???????? 8d4dd8 8bf0 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   68????????           |                     
            //   8d4dd8               | lea                 ecx, [ebp - 0x28]
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 83c8ff 2b4560 3bd8 7601 49 42 ebe4 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   2b4560               | sub                 eax, dword ptr [ebp + 0x60]
            //   3bd8                 | cmp                 ebx, eax
            //   7601                 | jbe                 3
            //   49                   | dec                 ecx
            //   42                   | inc                 edx
            //   ebe4                 | jmp                 0xffffffe6

        $sequence_2 = { 8d5c242c 89642428 8938 897808 89780c 897810 }
            // n = 6, score = 100
            //   8d5c242c             | lea                 ebx, [esp + 0x2c]
            //   89642428             | mov                 dword ptr [esp + 0x28], esp
            //   8938                 | mov                 dword ptr [eax], edi
            //   897808               | mov                 dword ptr [eax + 8], edi
            //   89780c               | mov                 dword ptr [eax + 0xc], edi
            //   897810               | mov                 dword ptr [eax + 0x10], edi

        $sequence_3 = { 8b4508 c9 c3 3b442404 741c 56 8d7004 }
            // n = 7, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   c9                   | leave               
            //   c3                   | ret                 
            //   3b442404             | cmp                 eax, dword ptr [esp + 4]
            //   741c                 | je                  0x1e
            //   56                   | push                esi
            //   8d7004               | lea                 esi, [eax + 4]

        $sequence_4 = { 8d8e94c90000 8955d8 0fb69002010000 0fb638 c1e210 0bd7 8951fc }
            // n = 7, score = 100
            //   8d8e94c90000         | lea                 ecx, [esi + 0xc994]
            //   8955d8               | mov                 dword ptr [ebp - 0x28], edx
            //   0fb69002010000       | movzx               edx, byte ptr [eax + 0x102]
            //   0fb638               | movzx               edi, byte ptr [eax]
            //   c1e210               | shl                 edx, 0x10
            //   0bd7                 | or                  edx, edi
            //   8951fc               | mov                 dword ptr [ecx - 4], edx

        $sequence_5 = { 8d4d88 0f9445c3 c645fc05 e8???????? 385dc3 7507 }
            // n = 6, score = 100
            //   8d4d88               | lea                 ecx, [ebp - 0x78]
            //   0f9445c3             | sete                byte ptr [ebp - 0x3d]
            //   c645fc05             | mov                 byte ptr [ebp - 4], 5
            //   e8????????           |                     
            //   385dc3               | cmp                 byte ptr [ebp - 0x3d], bl
            //   7507                 | jne                 9

        $sequence_6 = { e8???????? ff75ec 8d450c ff75e8 8bce 50 8b4508 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8d450c               | lea                 eax, [ebp + 0xc]
            //   ff75e8               | push                dword ptr [ebp - 0x18]
            //   8bce                 | mov                 ecx, esi
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_7 = { 6a01 50 ff7514 8d44243c ff7510 50 57 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   50                   | push                eax
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   8d44243c             | lea                 eax, [esp + 0x3c]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   50                   | push                eax
            //   57                   | push                edi

        $sequence_8 = { 83c104 ff4df8 837df800 7fe3 8b75e0 }
            // n = 5, score = 100
            //   83c104               | add                 ecx, 4
            //   ff4df8               | dec                 dword ptr [ebp - 8]
            //   837df800             | cmp                 dword ptr [ebp - 8], 0
            //   7fe3                 | jg                  0xffffffe5
            //   8b75e0               | mov                 esi, dword ptr [ebp - 0x20]

        $sequence_9 = { ff7004 ff15???????? 8bd8 83fb02 7504 32c0 eb2f }
            // n = 7, score = 100
            //   ff7004               | push                dword ptr [eax + 4]
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   83fb02               | cmp                 ebx, 2
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al
            //   eb2f                 | jmp                 0x31

    condition:
        7 of them and filesize < 892928
}