rule win_hawkball_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hawkball."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hawkball"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 50 53 6a00 68e9fd0000 }
            // n = 5, score = 200
            //   ff15????????         |                     
            //   50                   | push                eax
            //   53                   | push                ebx
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9

        $sequence_1 = { c3 6a59 ff15???????? 85c0 0f84b4000000 be???????? 8bc6 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   6a59                 | push                0x59
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84b4000000         | je                  0xba
            //   be????????           |                     
            //   8bc6                 | mov                 eax, esi

        $sequence_2 = { 56 8b7508 833e00 7f0a be04000000 e9???????? }
            // n = 6, score = 200
            //   56                   | push                esi
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   833e00               | cmp                 dword ptr [esi], 0
            //   7f0a                 | jg                  0xc
            //   be04000000           | mov                 esi, 4
            //   e9????????           |                     

        $sequence_3 = { ff75f8 c745fc00000000 ffd6 8b45fc 8b1d???????? 40 50 }
            // n = 7, score = 200
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ffd6                 | call                esi
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b1d????????         |                     
            //   40                   | inc                 eax
            //   50                   | push                eax

        $sequence_4 = { 56 f30f7f4588 57 660f6f05???????? 8b3d???????? f30f7f4598 }
            // n = 6, score = 200
            //   56                   | push                esi
            //   f30f7f4588           | movdqu              xmmword ptr [ebp - 0x78], xmm0
            //   57                   | push                edi
            //   660f6f05????????     |                     
            //   8b3d????????         |                     
            //   f30f7f4598           | movdqu              xmmword ptr [ebp - 0x68], xmm0

        $sequence_5 = { 50 668945dc 0f57c0 668985acf7ffff 8d85aef7ffff 50 c745d801000000 }
            // n = 7, score = 200
            //   50                   | push                eax
            //   668945dc             | mov                 word ptr [ebp - 0x24], ax
            //   0f57c0               | xorps               xmm0, xmm0
            //   668985acf7ffff       | mov                 word ptr [ebp - 0x854], ax
            //   8d85aef7ffff         | lea                 eax, [ebp - 0x852]
            //   50                   | push                eax
            //   c745d801000000       | mov                 dword ptr [ebp - 0x28], 1

        $sequence_6 = { ff15???????? 8b4309 83f801 751c 8b5508 8d85f8fdffff 50 }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   8b4309               | mov                 eax, dword ptr [ebx + 9]
            //   83f801               | cmp                 eax, 1
            //   751c                 | jne                 0x1e
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   50                   | push                eax

        $sequence_7 = { 85c0 741e 8d85fcfeffff 68???????? 50 e8???????? }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   741e                 | je                  0x20
            //   8d85fcfeffff         | lea                 eax, [ebp - 0x104]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_8 = { ffd6 50 ffd3 ff0d???????? 33c0 5f }
            // n = 6, score = 200
            //   ffd6                 | call                esi
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   ff0d????????         |                     
            //   33c0                 | xor                 eax, eax
            //   5f                   | pop                 edi

        $sequence_9 = { 6a08 ffd3 50 ff15???????? 8bf0 8d8578ffffff 50 }
            // n = 7, score = 200
            //   6a08                 | push                8
            //   ffd3                 | call                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   8d8578ffffff         | lea                 eax, [ebp - 0x88]
            //   50                   | push                eax

    condition:
        7 of them and filesize < 229376
}