rule win_hawkeye_keylogger_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-05-30"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.4.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hawkeye_keylogger"
        malpedia_rule_date = "20200529"
        malpedia_hash = "92c362319514e5a6da26204961446caa3a8b32a8"
        malpedia_version = "20200529"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 8d442408 c7442408???????? e8???????? 5f }
            // n = 5, score = 500
            //   e8????????           |                     
            //   8d442408             | lea                 eax, [esp + 8]
            //   c7442408????????     |                     
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_1 = { 53 8d4f34 51 68???????? 8bce }
            // n = 5, score = 500
            //   53                   | push                ebx
            //   8d4f34               | lea                 ecx, [edi + 0x34]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi

        $sequence_2 = { 68???????? 8bce ff5008 8b06 33db 43 }
            // n = 6, score = 500
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   ff5008               | call                dword ptr [eax + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   33db                 | xor                 ebx, ebx
            //   43                   | inc                 ebx

        $sequence_3 = { 40 c21c00 56 8bf0 83660c00 e8???????? 68???????? }
            // n = 7, score = 500
            //   40                   | inc                 eax
            //   c21c00               | ret                 0x1c
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   83660c00             | and                 dword ptr [esi + 0xc], 0
            //   e8????????           |                     
            //   68????????           |                     

        $sequence_4 = { 8d4f20 51 68???????? 8bce ff5004 8b06 53 }
            // n = 7, score = 500
            //   8d4f20               | lea                 ecx, [edi + 0x20]
            //   51                   | push                ecx
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   ff5004               | call                dword ptr [eax + 4]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   53                   | push                ebx

        $sequence_5 = { 1bc0 40 c20400 33c0 c20800 55 }
            // n = 6, score = 400
            //   1bc0                 | sbb                 eax, eax
            //   40                   | inc                 eax
            //   c20400               | ret                 4
            //   33c0                 | xor                 eax, eax
            //   c20800               | ret                 8
            //   55                   | push                ebp

        $sequence_6 = { 6aff 68???????? 8d75fc e8???????? }
            // n = 4, score = 400
            //   6aff                 | push                -1
            //   68????????           |                     
            //   8d75fc               | lea                 esi, [ebp - 4]
            //   e8????????           |                     

        $sequence_7 = { c20800 55 8bec 8b4508 83e84e 7427 }
            // n = 6, score = 400
            //   c20800               | ret                 8
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83e84e               | sub                 eax, 0x4e
            //   7427                 | je                  0x29

        $sequence_8 = { ff15???????? 83f8ff 7520 68???????? 8dbdc0fcffff e8???????? 59 }
            // n = 7, score = 400
            //   ff15????????         |                     
            //   83f8ff               | cmp                 eax, -1
            //   7520                 | jne                 0x22
            //   68????????           |                     
            //   8dbdc0fcffff         | lea                 edi, [ebp - 0x340]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_9 = { 33c0 66898514f6ffff 66898574fdffff 668985ecfaffff 68???????? 8d8510f6ffff e8???????? }
            // n = 7, score = 400
            //   33c0                 | xor                 eax, eax
            //   66898514f6ffff       | mov                 word ptr [ebp - 0x9ec], ax
            //   66898574fdffff       | mov                 word ptr [ebp - 0x28c], ax
            //   668985ecfaffff       | mov                 word ptr [ebp - 0x514], ax
            //   68????????           |                     
            //   8d8510f6ffff         | lea                 eax, [ebp - 0x9f0]
            //   e8????????           |                     

        $sequence_10 = { ff7508 ff15???????? 8b4df4 8b45ec 8b75f8 2bc1 }
            // n = 6, score = 200
            //   ff7508               | push                dword ptr [ebp + 8]
            //   ff15????????         |                     
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   2bc1                 | sub                 eax, ecx

        $sequence_11 = { 41 3dc0000000 7c4c 0fb68020414400 0fb611 53 eb0b }
            // n = 7, score = 200
            //   41                   | inc                 ecx
            //   3dc0000000           | cmp                 eax, 0xc0
            //   7c4c                 | jl                  0x4e
            //   0fb68020414400       | movzx               eax, byte ptr [eax + 0x444120]
            //   0fb611               | movzx               edx, byte ptr [ecx]
            //   53                   | push                ebx
            //   eb0b                 | jmp                 0xd

        $sequence_12 = { 0021 0022 0023 00fa 02fb 02fc 02fd }
            // n = 7, score = 200
            //   0021                 | add                 byte ptr [ecx], ah
            //   0022                 | add                 byte ptr [edx], ah
            //   0023                 | add                 byte ptr [ebx], ah
            //   00fa                 | add                 dl, bh
            //   02fb                 | add                 bh, bl
            //   02fc                 | add                 bh, ah
            //   02fd                 | add                 bh, ch

        $sequence_13 = { 8d45e8 6a02 50 8d9de8f7ffff c745f4b03c4400 }
            // n = 5, score = 200
            //   8d45e8               | lea                 eax, [ebp - 0x18]
            //   6a02                 | push                2
            //   50                   | push                eax
            //   8d9de8f7ffff         | lea                 ebx, [ebp - 0x818]
            //   c745f4b03c4400       | mov                 dword ptr [ebp - 0xc], 0x443cb0

        $sequence_14 = { 91 0592059305 94 0595059605 97 }
            // n = 5, score = 200
            //   91                   | xchg                eax, ecx
            //   0592059305           | add                 eax, 0x5930592
            //   94                   | xchg                eax, esp
            //   0595059605           | add                 eax, 0x5960595
            //   97                   | xchg                eax, edi

        $sequence_15 = { 50 0333 005103 52 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   0333                 | add                 esi, dword ptr [ebx]
            //   005103               | add                 byte ptr [ecx + 3], dl
            //   52                   | push                edx

        $sequence_16 = { 56 57 8d85f8efffff 894dfc e8???????? 8b7508 8d8600140000 }
            // n = 7, score = 200
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d85f8efffff         | lea                 eax, [ebp - 0x1008]
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d8600140000         | lea                 eax, [esi + 0x1400]

        $sequence_17 = { 0002 0003 00d2 02d3 02d4 }
            // n = 5, score = 200
            //   0002                 | add                 byte ptr [edx], al
            //   0003                 | add                 byte ptr [ebx], al
            //   00d2                 | add                 dl, dl
            //   02d3                 | add                 dl, bl
            //   02d4                 | add                 dl, ah

        $sequence_18 = { 0452 0453 0454 0455 0456 04e8 00e9 }
            // n = 7, score = 200
            //   0452                 | add                 al, 0x52
            //   0453                 | add                 al, 0x53
            //   0454                 | add                 al, 0x54
            //   0455                 | add                 al, 0x55
            //   0456                 | add                 al, 0x56
            //   04e8                 | add                 al, 0xe8
            //   00e9                 | add                 cl, ch

        $sequence_19 = { 0501050205 0305???????? 06 0507050805 0905???????? 0c05 0d050e050f }
            // n = 7, score = 200
            //   0501050205           | add                 eax, 0x5020501
            //   0305????????         |                     
            //   06                   | push                es
            //   0507050805           | add                 eax, 0x5080507
            //   0905????????         |                     
            //   0c05                 | or                  al, 5
            //   0d050e050f           | or                  eax, 0xf050e05

        $sequence_20 = { 6681fb429c 7510 50 50 6a10 ffb608020000 }
            // n = 6, score = 200
            //   6681fb429c           | cmp                 bx, 0x9c42
            //   7510                 | jne                 0x12
            //   50                   | push                eax
            //   50                   | push                eax
            //   6a10                 | push                0x10
            //   ffb608020000         | push                dword ptr [esi + 0x208]

        $sequence_21 = { 2505260527 0528052905 2a05???????? 2d052e052f 0530053105 }
            // n = 5, score = 200
            //   2505260527           | and                 eax, 0x27052605
            //   0528052905           | add                 eax, 0x5290528
            //   2a05????????         |                     
            //   2d052e052f           | sub                 eax, 0x2f052e05
            //   0530053105           | add                 eax, 0x5310530

        $sequence_22 = { 03a803a903aa 03ab034a00ac 03ad03ae03af 03b003b103b2 03b303b403b5 03b603b703b8 }
            // n = 6, score = 200
            //   03a803a903aa         | add                 ebp, dword ptr [eax - 0x55fc56fd]
            //   03ab034a00ac         | add                 ebp, dword ptr [ebx - 0x53ffb5fd]
            //   03ad03ae03af         | add                 ebp, dword ptr [ebp - 0x50fc51fd]
            //   03b003b103b2         | add                 esi, dword ptr [eax - 0x4dfc4efd]
            //   03b303b403b5         | add                 esi, dword ptr [ebx - 0x4afc4bfd]
            //   03b603b703b8         | add                 esi, dword ptr [esi - 0x47fc48fd]

        $sequence_23 = { c745d8048e4400 8975f0 e8???????? 8d45d8 }
            // n = 4, score = 200
            //   c745d8048e4400       | mov                 dword ptr [ebp - 0x28], 0x448e04
            //   8975f0               | mov                 dword ptr [ebp - 0x10], esi
            //   e8????????           |                     
            //   8d45d8               | lea                 eax, [ebp - 0x28]

    condition:
        7 of them and filesize < 1679360
}