rule win_hawking_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hawking."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hawking"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2c02 16 2a 06 }
            // n = 4, score = 100
            //   2c02                 | add                 byte ptr [eax], al
            //   16                   | add                 al, 0x28
            //   2a                   | sldt                word ptr [eax]
            //   06                   | or                  ch, byte ptr [0x120edede]

        $sequence_1 = { 06 6f2c00000a 26 06 6f2d00000a 6f2e00000a 750d000001 }
            // n = 7, score = 100
            //   06                   | jo                  0x43c
            //   6f2c00000a           | add                 dl, byte ptr [esi]
            //   26                   | sub                 al, byte ptr [esi]
            //   06                   | outsd               dx, dword ptr [esi]
            //   6f2d00000a           | sbb                 eax, dword ptr [eax]
            //   6f2e00000a           | add                 byte ptr [edx], cl
            //   750d000001           | sub                 byte ptr [eax + eax], bl

        $sequence_2 = { 08 16 08 8e 69 6f2100000a }
            // n = 6, score = 100
            //   08                   | outsd               dx, dword ptr [esi]
            //   16                   | add                 byte ptr es:[eax], al
            //   08                   | or                  ch, byte ptr [edi + 0x26]
            //   8e                   | add                 byte ptr [eax], al
            //   69                   | or                  dh, byte ptr [edx + 0x58]
            //   6f2100000a           | add                 al, byte ptr [eax]

        $sequence_3 = { 2d04 26 14 2b05 }
            // n = 4, score = 100
            //   2d04                 | or                  dword ptr [edi], edx
            //   26                   | sub                 byte ptr [ebx], dl
            //   14                   | add                 byte ptr [eax], al
            //   2b05                 | or                  ch, byte ptr [edi + 0x1d]

        $sequence_4 = { 281c00000a 02 07 6f1900000a 72ba010070 6f1a00000a 2807000006 }
            // n = 7, score = 100
            //   281c00000a           | sub                 al, 2
            //   02                   | push                ss
            //   07                   | sub                 al, byte ptr [esi]
            //   6f1900000a           | jb                  0x3ae
            //   72ba010070           | add                 al, byte ptr [eax]
            //   6f1a00000a           | jo                  0x34a
            //   2807000006           | and                 eax, 0x1426042d

        $sequence_5 = { 0b 14 0c 732f00000a 0d 16 }
            // n = 6, score = 100
            //   0b                   | or                  cl, byte ptr [ecx]
            //   14                   | sub                 al, 6
            //   0c                   | outsd               dx, dword ptr [esi]
            //   732f00000a           | xor                 al, byte ptr [eax]
            //   0d                   | add                 byte ptr [edx], cl
            //   16                   | push                es

        $sequence_6 = { 6f0e00000a 1200 280f00000a 2dde de0e 1200 fe160200001b }
            // n = 7, score = 100
            //   6f0e00000a           | mov                 gs, word ptr [ecx + 0x6a]
            //   1200                 | outsd               dx, dword ptr [esi]
            //   280f00000a           | pop                 ds
            //   2dde                 | add                 byte ptr [eax], al
            //   de0e                 | or                  ch, byte ptr [edi + 0x20]
            //   1200                 | add                 byte ptr [eax], al
            //   fe160200001b         | or                  ah, byte ptr [0x306f698e]

        $sequence_7 = { 2df6 06 6f06000006 de0c 6f3400000a 2801000006 }
            // n = 6, score = 100
            //   2df6                 | add                 byte ptr [esi], al
            //   06                   | or                  ebp, dword ptr [ebx]
            //   6f06000006           | pop                 es
            //   de0c                 | push                es
            //   6f3400000a           | outsd               dx, dword ptr [esi]
            //   2801000006           | add                 eax, 0x6060000

        $sequence_8 = { 0c 07 6f1900000a 72ba010070 }
            // n = 4, score = 100
            //   0c                   | or                  byte ptr [ecx], cl
            //   07                   | lcall               0x8e08:0x16080413
            //   6f1900000a           | or                  byte ptr [0x826042d], ah
            //   72ba010070           | mov                 gs, word ptr [ecx + 0x32]

        $sequence_9 = { 03 282400000a 2801000006 732500000a 0a 06 }
            // n = 6, score = 100
            //   03                   | or                  eax, 0x6f0a0000
            //   282400000a           | adc                 al, 0
            //   2801000006           | add                 byte ptr [edx], cl
            //   732500000a           | or                  dh, byte ptr [edx + 0x28]
            //   0a                   | add                 dword ptr [eax], eax
            //   06                   | jo                  0xdc

    condition:
        7 of them and filesize < 50176
}