rule win_hazy_load_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hazy_load."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hazy_load"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d542420 442bc7 4803d0 4533c9 }
            // n = 4, score = 200
            //   488d542420           | dec                 eax
            //   442bc7               | mov                 eax, ebx
            //   4803d0               | dec                 ecx
            //   4533c9               | xchg                dword ptr [edi + esi*8 + 0x213b0], eax

        $sequence_1 = { 33d2 488bc8 4c8bf8 e8???????? 4c8bc6 41893f 498d4f08 }
            // n = 7, score = 200
            //   33d2                 | dec                 ecx
            //   488bc8               | xor                 edi, edx
            //   4c8bf8               | dec                 ebx
            //   e8????????           |                     
            //   4c8bc6               | xchg                dword ptr [edi + esi*8 + 0x21450], edi
            //   41893f               | xor                 eax, eax
            //   498d4f08             | dec                 eax

        $sequence_2 = { 488d35c3aa0100 eb16 488b3b 4885ff }
            // n = 4, score = 200
            //   488d35c3aa0100       | cmp                 ecx, eax
            //   eb16                 | je                  0x301
            //   488b3b               | dec                 eax
            //   4885ff               | mov                 ecx, dword ptr [eax + 0x90]

        $sequence_3 = { 418be9 48c1f806 488d0db8200100 4183e23f }
            // n = 4, score = 200
            //   418be9               | arpl                cx, cx
            //   48c1f806             | dec                 eax
            //   488d0db8200100       | lea                 edx, [0xf8cc]
            //   4183e23f             | jae                 0x40

        $sequence_4 = { 4883ec20 8bd9 4c8d0d09c60000 b904000000 4c8d05f5c50000 488d15aeb20000 }
            // n = 6, score = 200
            //   4883ec20             | lea                 edx, [0x1520d]
            //   8bd9                 | inc                 ebp
            //   4c8d0d09c60000       | xor                 eax, eax
            //   b904000000           | dec                 eax
            //   4c8d05f5c50000       | lea                 ecx, [ebx + ebx*4]
            //   488d15aeb20000       | dec                 eax

        $sequence_5 = { 0f848d010000 83cfff 488d2ddf120100 83635000 83632c00 e9???????? }
            // n = 6, score = 200
            //   0f848d010000         | mov                 eax, 6
            //   83cfff               | dec                 eax
            //   488d2ddf120100       | lea                 edx, [0x11629]
            //   83635000             | dec                 eax
            //   83632c00             | cmp                 dword ptr [eax - 0x10], edx
            //   e9????????           |                     

        $sequence_6 = { 0fb64201 84c0 744d 0fbec8 83e968 }
            // n = 5, score = 200
            //   0fb64201             | cmp                 dword ptr [ecx + 0x470], 2
            //   84c0                 | je                  0x883
            //   744d                 | or                  edi, 0xffffffff
            //   0fbec8               | dec                 esp
            //   83e968               | lea                 edi, [0x10ece]

        $sequence_7 = { 83fb08 7cd5 83fb08 0f8522010000 }
            // n = 4, score = 200
            //   83fb08               | sar                 eax, 6
            //   7cd5                 | dec                 eax
            //   83fb08               | lea                 ebx, [0x1ab06]
            //   0f8522010000         | dec                 eax

        $sequence_8 = { 4883ec20 488d3d93690100 48393d???????? 742b }
            // n = 4, score = 200
            //   4883ec20             | xor                 eax, eax
            //   488d3d93690100       | xor                 edx, edx
            //   48393d????????       |                     
            //   742b                 | inc                 ebp

        $sequence_9 = { ff15???????? 48832300 4883c308 488d0551d50100 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   48832300             | dec                 eax
            //   4883c308             | add                 eax, 0x24
            //   488d0551d50100       | jne                 0x2db

    condition:
        7 of them and filesize < 315392
}