rule win_hdmr_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hdmr."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hdmr"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b06 8b9094000000 8bce ffd2 8b10 8bc8 }
            // n = 6, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b9094000000         | mov                 edx, dword ptr [eax + 0x94]
            //   8bce                 | mov                 ecx, esi
            //   ffd2                 | call                edx
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   8bc8                 | mov                 ecx, eax

        $sequence_1 = { 337008 8955fc 33de 8b75f8 33fe 81e7ff00ff00 33780c }
            // n = 7, score = 100
            //   337008               | xor                 esi, dword ptr [eax + 8]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   33de                 | xor                 ebx, esi
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   33fe                 | xor                 edi, esi
            //   81e7ff00ff00         | and                 edi, 0xff00ff
            //   33780c               | xor                 edi, dword ptr [eax + 0xc]

        $sequence_2 = { 2bf7 8bff 0fb719 0fb73c0e }
            // n = 4, score = 100
            //   2bf7                 | sub                 esi, edi
            //   8bff                 | mov                 edi, edi
            //   0fb719               | movzx               ebx, word ptr [ecx]
            //   0fb73c0e             | movzx               edi, word ptr [esi + ecx]

        $sequence_3 = { 51 e8???????? 8bf0 89470c 8b450c 83c404 8bd6 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   89470c               | mov                 dword ptr [edi + 0xc], eax
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   83c404               | add                 esp, 4
            //   8bd6                 | mov                 edx, esi

        $sequence_4 = { ffd7 83c614 ff4c240c 0f8562ffffff 33d2 68fe070000 52 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   83c614               | add                 esi, 0x14
            //   ff4c240c             | dec                 dword ptr [esp + 0xc]
            //   0f8562ffffff         | jne                 0xffffff68
            //   33d2                 | xor                 edx, edx
            //   68fe070000           | push                0x7fe
            //   52                   | push                edx

        $sequence_5 = { 0f84e1030000 6a00 6a00 6a00 }
            // n = 4, score = 100
            //   0f84e1030000         | je                  0x3e7
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_6 = { 7424 8b06 8b9094000000 8bce }
            // n = 4, score = 100
            //   7424                 | je                  0x26
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8b9094000000         | mov                 edx, dword ptr [eax + 0x94]
            //   8bce                 | mov                 ecx, esi

        $sequence_7 = { 8d45cc 50 c745cce86b4100 e8???????? 8b7508 bf63736de0 393e }
            // n = 7, score = 100
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   c745cce86b4100       | mov                 dword ptr [ebp - 0x34], 0x416be8
            //   e8????????           |                     
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   bf63736de0           | mov                 edi, 0xe06d7363
            //   393e                 | cmp                 dword ptr [esi], edi

        $sequence_8 = { 56 8d3c8540d04100 e8???????? 83e01f 59 }
            // n = 5, score = 100
            //   56                   | push                esi
            //   8d3c8540d04100       | lea                 edi, [eax*4 + 0x41d040]
            //   e8????????           |                     
            //   83e01f               | and                 eax, 0x1f
            //   59                   | pop                 ecx

        $sequence_9 = { 8bce ffd2 8b10 4f 57 8bc8 }
            // n = 6, score = 100
            //   8bce                 | mov                 ecx, esi
            //   ffd2                 | call                edx
            //   8b10                 | mov                 edx, dword ptr [eax]
            //   4f                   | dec                 edi
            //   57                   | push                edi
            //   8bc8                 | mov                 ecx, eax

    condition:
        7 of them and filesize < 284672
}