rule win_helauto_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.helauto."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.helauto"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c0 8d7dc0 895dbc f3ab 8b4510 69c0f4010000 }
            // n = 6, score = 100
            //   33c0                 | xor                 eax, eax
            //   8d7dc0               | lea                 edi, [ebp - 0x40]
            //   895dbc               | mov                 dword ptr [ebp - 0x44], ebx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   69c0f4010000         | imul                eax, eax, 0x1f4

        $sequence_1 = { 753b 6a08 be???????? 59 8d7d98 f3a5 }
            // n = 6, score = 100
            //   753b                 | jne                 0x3d
            //   6a08                 | push                8
            //   be????????           |                     
            //   59                   | pop                 ecx
            //   8d7d98               | lea                 edi, [ebp - 0x68]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]

        $sequence_2 = { ff75f0 ff15???????? 8b45f4 8b7dec 2b4510 }
            // n = 5, score = 100
            //   ff75f0               | push                dword ptr [ebp - 0x10]
            //   ff15????????         |                     
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b7dec               | mov                 edi, dword ptr [ebp - 0x14]
            //   2b4510               | sub                 eax, dword ptr [ebp + 0x10]

        $sequence_3 = { 68???????? 8d85a8f9ffff 50 e8???????? 8d85a8f9ffff }
            // n = 5, score = 100
            //   68????????           |                     
            //   8d85a8f9ffff         | lea                 eax, [ebp - 0x658]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d85a8f9ffff         | lea                 eax, [ebp - 0x658]

        $sequence_4 = { 53 8d85a8f8ffff 68???????? 50 e8???????? }
            // n = 5, score = 100
            //   53                   | push                ebx
            //   8d85a8f8ffff         | lea                 eax, [ebp - 0x758]
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_5 = { 50 6a1f ff75fc ffd6 8d45c8 57 50 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   6a1f                 | push                0x1f
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   ffd6                 | call                esi
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   57                   | push                edi
            //   50                   | push                eax

        $sequence_6 = { 53 53 6a01 53 8d8528feffff 53 }
            // n = 6, score = 100
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6a01                 | push                1
            //   53                   | push                ebx
            //   8d8528feffff         | lea                 eax, [ebp - 0x1d8]
            //   53                   | push                ebx

        $sequence_7 = { 59 0f85b3000000 53 6a08 }
            // n = 4, score = 100
            //   59                   | pop                 ecx
            //   0f85b3000000         | jne                 0xb9
            //   53                   | push                ebx
            //   6a08                 | push                8

        $sequence_8 = { 6a01 58 c20c00 b8???????? e8???????? 81ec00010000 }
            // n = 6, score = 100
            //   6a01                 | push                1
            //   58                   | pop                 eax
            //   c20c00               | ret                 0xc
            //   b8????????           |                     
            //   e8????????           |                     
            //   81ec00010000         | sub                 esp, 0x100

        $sequence_9 = { 6a1f ff75fc 897dc4 ff15???????? 8b35???????? 804ddd01 }
            // n = 6, score = 100
            //   6a1f                 | push                0x1f
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   897dc4               | mov                 dword ptr [ebp - 0x3c], edi
            //   ff15????????         |                     
            //   8b35????????         |                     
            //   804ddd01             | or                  byte ptr [ebp - 0x23], 1

    condition:
        7 of them and filesize < 57344
}