rule win_hellokitty_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hellokitty."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hellokitty"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 89542414 3d00010000 0f8f27010000 8bcb e8???????? 8bf0 }
            // n = 6, score = 100
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   3d00010000           | cmp                 eax, 0x100
            //   0f8f27010000         | jg                  0x12d
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_1 = { 6a08 58 75a4 5b 5f 5e c9 }
            // n = 7, score = 100
            //   6a08                 | push                8
            //   58                   | pop                 eax
            //   75a4                 | jne                 0xffffffa6
            //   5b                   | pop                 ebx
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_2 = { 50 ffd6 8bd8 8945fc 83c8ff 3bd8 0f846b020000 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8bd8                 | mov                 ebx, eax
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   83c8ff               | or                  eax, 0xffffffff
            //   3bd8                 | cmp                 ebx, eax
            //   0f846b020000         | je                  0x271

        $sequence_3 = { 8b45fc 8b4048 f00fc118 4b 7515 8b45fc 817848c0044200 }
            // n = 7, score = 100
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8b4048               | mov                 eax, dword ptr [eax + 0x48]
            //   f00fc118             | lock xadd           dword ptr [eax], ebx
            //   4b                   | dec                 ebx
            //   7515                 | jne                 0x17
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   817848c0044200       | cmp                 dword ptr [eax + 0x48], 0x4204c0

        $sequence_4 = { 03c8 8b45f0 03ce 8b75fc 894df8 c1c105 8b4034 }
            // n = 7, score = 100
            //   03c8                 | add                 ecx, eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   03ce                 | add                 ecx, esi
            //   8b75fc               | mov                 esi, dword ptr [ebp - 4]
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   c1c105               | rol                 ecx, 5
            //   8b4034               | mov                 eax, dword ptr [eax + 0x34]

        $sequence_5 = { 8d4c242c e8???????? 837c243c08 8d442428 0f43442428 33ff 57 }
            // n = 7, score = 100
            //   8d4c242c             | lea                 ecx, [esp + 0x2c]
            //   e8????????           |                     
            //   837c243c08           | cmp                 dword ptr [esp + 0x3c], 8
            //   8d442428             | lea                 eax, [esp + 0x28]
            //   0f43442428           | cmovae              eax, dword ptr [esp + 0x28]
            //   33ff                 | xor                 edi, edi
            //   57                   | push                edi

        $sequence_6 = { 8b7508 2bdf ba10000000 660f1f440000 8a0c06 8d4001 3248ff }
            // n = 7, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   2bdf                 | sub                 ebx, edi
            //   ba10000000           | mov                 edx, 0x10
            //   660f1f440000         | nop                 word ptr [eax + eax]
            //   8a0c06               | mov                 cl, byte ptr [esi + eax]
            //   8d4001               | lea                 eax, [eax + 1]
            //   3248ff               | xor                 cl, byte ptr [eax - 1]

        $sequence_7 = { 0fb689303b4200 33f9 333d???????? 33fa 8bd7 89b880000000 33d6 }
            // n = 7, score = 100
            //   0fb689303b4200       | movzx               ecx, byte ptr [ecx + 0x423b30]
            //   33f9                 | xor                 edi, ecx
            //   333d????????         |                     
            //   33fa                 | xor                 edi, edx
            //   8bd7                 | mov                 edx, edi
            //   89b880000000         | mov                 dword ptr [eax + 0x80], edi
            //   33d6                 | xor                 edx, esi

        $sequence_8 = { c1c806 33c8 8b45dc 3345e8 034dac 23f0 3375dc }
            // n = 7, score = 100
            //   c1c806               | ror                 eax, 6
            //   33c8                 | xor                 ecx, eax
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   3345e8               | xor                 eax, dword ptr [ebp - 0x18]
            //   034dac               | add                 ecx, dword ptr [ebp - 0x54]
            //   23f0                 | and                 esi, eax
            //   3375dc               | xor                 esi, dword ptr [ebp - 0x24]

        $sequence_9 = { c1c10e 33c8 8bc2 8b55cc 8bf2 c1e803 33c8 }
            // n = 7, score = 100
            //   c1c10e               | rol                 ecx, 0xe
            //   33c8                 | xor                 ecx, eax
            //   8bc2                 | mov                 eax, edx
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   8bf2                 | mov                 esi, edx
            //   c1e803               | shr                 eax, 3
            //   33c8                 | xor                 ecx, eax

    condition:
        7 of them and filesize < 319488
}