rule win_helminth_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.helminth."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.helminth"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { a1???????? 68e8030000 8907 e8???????? }
            // n = 4, score = 300
            //   a1????????           |                     
            //   68e8030000           | push                0x3e8
            //   8907                 | mov                 dword ptr [edi], eax
            //   e8????????           |                     

        $sequence_1 = { 2bc6 3bd8 a1???????? 7f5e 8d3c81 }
            // n = 5, score = 200
            //   2bc6                 | sub                 eax, esi
            //   3bd8                 | cmp                 ebx, eax
            //   a1????????           |                     
            //   7f5e                 | jg                  0x60
            //   8d3c81               | lea                 edi, [ecx + eax*4]

        $sequence_2 = { 8bd8 85db 0f84bc000000 8bcb 8d5102 668b01 83c102 }
            // n = 7, score = 200
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f84bc000000         | je                  0xc2
            //   8bcb                 | mov                 ecx, ebx
            //   8d5102               | lea                 edx, [ecx + 2]
            //   668b01               | mov                 ax, word ptr [ecx]
            //   83c102               | add                 ecx, 2

        $sequence_3 = { 83e11f c1e106 8b048570750110 80640804fe ff36 e8???????? }
            // n = 6, score = 200
            //   83e11f               | and                 ecx, 0x1f
            //   c1e106               | shl                 ecx, 6
            //   8b048570750110       | mov                 eax, dword ptr [eax*4 + 0x10017570]
            //   80640804fe           | and                 byte ptr [eax + ecx + 4], 0xfe
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     

        $sequence_4 = { 8a441918 8881a8670110 41 ebe8 8975e4 }
            // n = 5, score = 200
            //   8a441918             | mov                 al, byte ptr [ecx + ebx + 0x18]
            //   8881a8670110         | mov                 byte ptr [ecx + 0x100167a8], al
            //   41                   | inc                 ecx
            //   ebe8                 | jmp                 0xffffffea
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi

        $sequence_5 = { 56 ff15???????? 56 e8???????? 8b35???????? 83c404 8b0d???????? }
            // n = 7, score = 200
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   8b35????????         |                     
            //   83c404               | add                 esp, 4
            //   8b0d????????         |                     

        $sequence_6 = { 8bca 894c2408 8d9b00000000 668b02 83c202 6685c0 75f5 }
            // n = 7, score = 200
            //   8bca                 | mov                 ecx, edx
            //   894c2408             | mov                 dword ptr [esp + 8], ecx
            //   8d9b00000000         | lea                 ebx, [ebx]
            //   668b02               | mov                 ax, word ptr [edx]
            //   83c202               | add                 edx, 2
            //   6685c0               | test                ax, ax
            //   75f5                 | jne                 0xfffffff7

        $sequence_7 = { 66893441 8b1a ff15???????? 8bc3 8d5002 668b08 }
            // n = 6, score = 200
            //   66893441             | mov                 word ptr [ecx + eax*2], si
            //   8b1a                 | mov                 ebx, dword ptr [edx]
            //   ff15????????         |                     
            //   8bc3                 | mov                 eax, ebx
            //   8d5002               | lea                 edx, [eax + 2]
            //   668b08               | mov                 cx, word ptr [eax]

        $sequence_8 = { 83f8ff 0f84ac000000 8d442418 50 56 }
            // n = 5, score = 100
            //   83f8ff               | cmp                 eax, -1
            //   0f84ac000000         | je                  0xb2
            //   8d442418             | lea                 eax, [esp + 0x18]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_9 = { 8945dc 8d45cc 50 6a02 }
            // n = 4, score = 100
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8d45cc               | lea                 eax, [ebp - 0x34]
            //   50                   | push                eax
            //   6a02                 | push                2

        $sequence_10 = { 51 e8???????? 8b55e8 03f6 59 }
            // n = 5, score = 100
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b55e8               | mov                 edx, dword ptr [ebp - 0x18]
            //   03f6                 | add                 esi, esi
            //   59                   | pop                 ecx

        $sequence_11 = { 8bd0 b9???????? 8995c8fbffff 2bd1 }
            // n = 4, score = 100
            //   8bd0                 | mov                 edx, eax
            //   b9????????           |                     
            //   8995c8fbffff         | mov                 dword ptr [ebp - 0x438], edx
            //   2bd1                 | sub                 edx, ecx

        $sequence_12 = { f3a5 8bca 83e103 f3a4 8b7c2414 83ef02 }
            // n = 6, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bca                 | mov                 ecx, edx
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8b7c2414             | mov                 edi, dword ptr [esp + 0x14]
            //   83ef02               | sub                 edi, 2

        $sequence_13 = { eb1c 56 ff15???????? 57 ff15???????? }
            // n = 5, score = 100
            //   eb1c                 | jmp                 0x1e
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_14 = { e8???????? 8b75f0 43 59 eb31 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8b75f0               | mov                 esi, dword ptr [ebp - 0x10]
            //   43                   | inc                 ebx
            //   59                   | pop                 ecx
            //   eb31                 | jmp                 0x33

    condition:
        7 of them and filesize < 479232
}