rule win_hemigate_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hemigate."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hemigate"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85f6 0f8597000000 8bd3 8d4ddc e8???????? 8bf0 85f6 }
            // n = 7, score = 200
            //   85f6                 | test                esi, esi
            //   0f8597000000         | jne                 0x9d
            //   8bd3                 | mov                 edx, ebx
            //   8d4ddc               | lea                 ecx, [ebp - 0x24]
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi

        $sequence_1 = { c1e208 0bd1 0fb64f06 3155a8 0fb65707 c1e208 0bd1 }
            // n = 7, score = 200
            //   c1e208               | shl                 edx, 8
            //   0bd1                 | or                  edx, ecx
            //   0fb64f06             | movzx               ecx, byte ptr [edi + 6]
            //   3155a8               | xor                 dword ptr [ebp - 0x58], edx
            //   0fb65707             | movzx               edx, byte ptr [edi + 7]
            //   c1e208               | shl                 edx, 8
            //   0bd1                 | or                  edx, ecx

        $sequence_2 = { c3 ff75f4 ff36 ff15???????? 8bf0 83c408 85f6 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   ff75f4               | push                dword ptr [ebp - 0xc]
            //   ff36                 | push                dword ptr [esi]
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax
            //   83c408               | add                 esp, 8
            //   85f6                 | test                esi, esi

        $sequence_3 = { 8b550c 8d45d4 50 8d8fa8000000 e8???????? 8b55cc 8d8fb8110100 }
            // n = 7, score = 200
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   50                   | push                eax
            //   8d8fa8000000         | lea                 ecx, [edi + 0xa8]
            //   e8????????           |                     
            //   8b55cc               | mov                 edx, dword ptr [ebp - 0x34]
            //   8d8fb8110100         | lea                 ecx, [edi + 0x111b8]

        $sequence_4 = { 83f801 0f85b8000000 ffb55cf7ffff ffd3 0fb7c0 8d9554f7ffff 6a02 }
            // n = 7, score = 200
            //   83f801               | cmp                 eax, 1
            //   0f85b8000000         | jne                 0xbe
            //   ffb55cf7ffff         | push                dword ptr [ebp - 0x8a4]
            //   ffd3                 | call                ebx
            //   0fb7c0               | movzx               eax, ax
            //   8d9554f7ffff         | lea                 edx, [ebp - 0x8ac]
            //   6a02                 | push                2

        $sequence_5 = { c1c919 33c8 8b75ec 8bc7 8b7de8 c1c806 33c8 }
            // n = 7, score = 200
            //   c1c919               | ror                 ecx, 0x19
            //   33c8                 | xor                 ecx, eax
            //   8b75ec               | mov                 esi, dword ptr [ebp - 0x14]
            //   8bc7                 | mov                 eax, edi
            //   8b7de8               | mov                 edi, dword ptr [ebp - 0x18]
            //   c1c806               | ror                 eax, 6
            //   33c8                 | xor                 ecx, eax

        $sequence_6 = { c1e903 f7e1 56 c1ea03 33f6 8d0492 03c0 }
            // n = 7, score = 200
            //   c1e903               | shr                 ecx, 3
            //   f7e1                 | mul                 ecx
            //   56                   | push                esi
            //   c1ea03               | shr                 edx, 3
            //   33f6                 | xor                 esi, esi
            //   8d0492               | lea                 eax, [edx + edx*4]
            //   03c0                 | add                 eax, eax

        $sequence_7 = { eb48 b840000000 8bfb 2bc1 3bd8 0f43f8 8d462c }
            // n = 7, score = 200
            //   eb48                 | jmp                 0x4a
            //   b840000000           | mov                 eax, 0x40
            //   8bfb                 | mov                 edi, ebx
            //   2bc1                 | sub                 eax, ecx
            //   3bd8                 | cmp                 ebx, eax
            //   0f43f8               | cmovae              edi, eax
            //   8d462c               | lea                 eax, [esi + 0x2c]

        $sequence_8 = { 0f84a4f4ffff 8b45c8 0345c4 53 50 51 e8???????? }
            // n = 7, score = 200
            //   0f84a4f4ffff         | je                  0xfffff4aa
            //   8b45c8               | mov                 eax, dword ptr [ebp - 0x38]
            //   0345c4               | add                 eax, dword ptr [ebp - 0x3c]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_9 = { 8d742418 8bf8 f3a5 8143080c020000 e9???????? 8d4c2418 51 }
            // n = 7, score = 200
            //   8d742418             | lea                 esi, [esp + 0x18]
            //   8bf8                 | mov                 edi, eax
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8143080c020000       | add                 dword ptr [ebx + 8], 0x20c
            //   e9????????           |                     
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   51                   | push                ecx

    condition:
        7 of them and filesize < 991232
}