rule win_hermeticwizard_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hermeticwizard."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hermeticwizard"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800080000 50 e8???????? 83c410 85c0 }
            // n = 5, score = 100
            //   6800080000           | push                0x800
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   85c0                 | test                eax, eax

        $sequence_1 = { 1bdb 83cb01 85db 0f94c0 }
            // n = 4, score = 100
            //   1bdb                 | sbb                 ebx, ebx
            //   83cb01               | or                  ebx, 1
            //   85db                 | test                ebx, ebx
            //   0f94c0               | sete                al

        $sequence_2 = { 6685db 7415 668b5902 663b5f02 750f 83c104 83c704 }
            // n = 7, score = 100
            //   6685db               | test                bx, bx
            //   7415                 | je                  0x17
            //   668b5902             | mov                 bx, word ptr [ecx + 2]
            //   663b5f02             | cmp                 bx, word ptr [edi + 2]
            //   750f                 | jne                 0x11
            //   83c104               | add                 ecx, 4
            //   83c704               | add                 edi, 4

        $sequence_3 = { 6689853effffff 66898540ffffff 33c0 66898542ffffff 8b45f8 66898d16ffffff }
            // n = 6, score = 100
            //   6689853effffff       | mov                 word ptr [ebp - 0xc2], ax
            //   66898540ffffff       | mov                 word ptr [ebp - 0xc0], ax
            //   33c0                 | xor                 eax, eax
            //   66898542ffffff       | mov                 word ptr [ebp - 0xbe], ax
            //   8b45f8               | mov                 eax, dword ptr [ebp - 8]
            //   66898d16ffffff       | mov                 word ptr [ebp - 0xea], cx

        $sequence_4 = { 3bc7 7442 8b35???????? 83c008 50 }
            // n = 5, score = 100
            //   3bc7                 | cmp                 eax, edi
            //   7442                 | je                  0x44
            //   8b35????????         |                     
            //   83c008               | add                 eax, 8
            //   50                   | push                eax

        $sequence_5 = { 57 8bf1 8bfa 68???????? 56 ff15???????? 85c0 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   8bfa                 | mov                 edi, edx
            //   68????????           |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_6 = { 894310 8b45f0 c745ec989d0110 8d1486 }
            // n = 4, score = 100
            //   894310               | mov                 dword ptr [ebx + 0x10], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   c745ec989d0110       | mov                 dword ptr [ebp - 0x14], 0x10019d98
            //   8d1486               | lea                 edx, [esi + eax*4]

        $sequence_7 = { 7410 68???????? 8bce e8???????? 59 894308 }
            // n = 6, score = 100
            //   7410                 | je                  0x12
            //   68????????           |                     
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   894308               | mov                 dword ptr [ebx + 8], eax

        $sequence_8 = { 668b4104 663b4204 750b 8b4108 3b4208 7503 }
            // n = 6, score = 100
            //   668b4104             | mov                 ax, word ptr [ecx + 4]
            //   663b4204             | cmp                 ax, word ptr [edx + 4]
            //   750b                 | jne                 0xd
            //   8b4108               | mov                 eax, dword ptr [ecx + 8]
            //   3b4208               | cmp                 eax, dword ptr [edx + 8]
            //   7503                 | jne                 5

        $sequence_9 = { 50 e8???????? 3b30 7533 8b45fc }
            // n = 5, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   3b30                 | cmp                 esi, dword ptr [eax]
            //   7533                 | jne                 0x35
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]

    condition:
        7 of them and filesize < 263168
}