rule win_herpes_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.herpes."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.herpes"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3945cc 8b45b8 7303 8d45b8 56 51 50 }
            // n = 7, score = 100
            //   3945cc               | cmp                 dword ptr [ebp - 0x34], eax
            //   8b45b8               | mov                 eax, dword ptr [ebp - 0x48]
            //   7303                 | jae                 5
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   56                   | push                esi
            //   51                   | push                ecx
            //   50                   | push                eax

        $sequence_1 = { 68???????? e8???????? 83c404 5e 5d c20400 83ff75 }
            // n = 7, score = 100
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   83ff75               | cmp                 edi, 0x75

        $sequence_2 = { 8945e4 3d01010000 7d0d 8a4c181c 8888c0c24100 40 }
            // n = 6, score = 100
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   3d01010000           | cmp                 eax, 0x101
            //   7d0d                 | jge                 0xf
            //   8a4c181c             | mov                 cl, byte ptr [eax + ebx + 0x1c]
            //   8888c0c24100         | mov                 byte ptr [eax + 0x41c2c0], cl
            //   40                   | inc                 eax

        $sequence_3 = { 8d45d4 3bc7 7450 3975e8 720c 8b4dd4 51 }
            // n = 7, score = 100
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   3bc7                 | cmp                 eax, edi
            //   7450                 | je                  0x52
            //   3975e8               | cmp                 dword ptr [ebp - 0x18], esi
            //   720c                 | jb                  0xe
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx

        $sequence_4 = { ffd7 68???????? 898664010000 ffd5 68???????? 50 898600020000 }
            // n = 7, score = 100
            //   ffd7                 | call                edi
            //   68????????           |                     
            //   898664010000         | mov                 dword ptr [esi + 0x164], eax
            //   ffd5                 | call                ebp
            //   68????????           |                     
            //   50                   | push                eax
            //   898600020000         | mov                 dword ptr [esi + 0x200], eax

        $sequence_5 = { e8???????? 8bc7 5f c20400 83661000 }
            // n = 5, score = 100
            //   e8????????           |                     
            //   8bc7                 | mov                 eax, edi
            //   5f                   | pop                 edi
            //   c20400               | ret                 4
            //   83661000             | and                 dword ptr [esi + 0x10], 0

        $sequence_6 = { ffd6 0145f0 8b75dc 8b45f0 56 ff75e0 03c7 }
            // n = 7, score = 100
            //   ffd6                 | call                esi
            //   0145f0               | add                 dword ptr [ebp - 0x10], eax
            //   8b75dc               | mov                 esi, dword ptr [ebp - 0x24]
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   56                   | push                esi
            //   ff75e0               | push                dword ptr [ebp - 0x20]
            //   03c7                 | add                 eax, edi

        $sequence_7 = { ffd7 68???????? ffb6f8010000 894664 }
            // n = 4, score = 100
            //   ffd7                 | call                edi
            //   68????????           |                     
            //   ffb6f8010000         | push                dword ptr [esi + 0x1f8]
            //   894664               | mov                 dword ptr [esi + 0x64], eax

        $sequence_8 = { 8b4dfc 898134050000 6a00 6880000000 6a03 6a00 6a01 }
            // n = 7, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   898134050000         | mov                 dword ptr [ecx + 0x534], eax
            //   6a00                 | push                0
            //   6880000000           | push                0x80
            //   6a03                 | push                3
            //   6a00                 | push                0
            //   6a01                 | push                1

        $sequence_9 = { 33db 58 89863c020000 899e38020000 }
            // n = 4, score = 100
            //   33db                 | xor                 ebx, ebx
            //   58                   | pop                 eax
            //   89863c020000         | mov                 dword ptr [esi + 0x23c], eax
            //   899e38020000         | mov                 dword ptr [esi + 0x238], ebx

    condition:
        7 of them and filesize < 319488
}