rule win_hesperbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hesperbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hesperbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33f0 8b442440 0b442438 33cf 23442448 8b7c2444 8b5c2440 }
            // n = 7, score = 500
            //   33f0                 | xor                 esi, eax
            //   8b442440             | mov                 eax, dword ptr [esp + 0x40]
            //   0b442438             | or                  eax, dword ptr [esp + 0x38]
            //   33cf                 | xor                 ecx, edi
            //   23442448             | and                 eax, dword ptr [esp + 0x48]
            //   8b7c2444             | mov                 edi, dword ptr [esp + 0x44]
            //   8b5c2440             | mov                 ebx, dword ptr [esp + 0x40]

        $sequence_1 = { 33c0 f644240401 7405 b800000200 f644240402 7405 }
            // n = 6, score = 500
            //   33c0                 | xor                 eax, eax
            //   f644240401           | test                byte ptr [esp + 4], 1
            //   7405                 | je                  7
            //   b800000200           | mov                 eax, 0x20000
            //   f644240402           | test                byte ptr [esp + 4], 2
            //   7405                 | je                  7

        $sequence_2 = { 33ed 0be9 33f5 8b6c244c 0fa4dd19 c1e807 c1e319 }
            // n = 7, score = 500
            //   33ed                 | xor                 ebp, ebp
            //   0be9                 | or                  ebp, ecx
            //   33f5                 | xor                 esi, ebp
            //   8b6c244c             | mov                 ebp, dword ptr [esp + 0x4c]
            //   0fa4dd19             | shld                ebp, ebx, 0x19
            //   c1e807               | shr                 eax, 7
            //   c1e319               | shl                 ebx, 0x19

        $sequence_3 = { 5e c3 56 8d7010 e8???????? 5e c3 }
            // n = 7, score = 500
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   56                   | push                esi
            //   8d7010               | lea                 esi, [eax + 0x10]
            //   e8????????           |                     
            //   5e                   | pop                 esi
            //   c3                   | ret                 

        $sequence_4 = { 0bcd 33f1 8b4c2434 0b4c242c c1e807 c1e319 0bc3 }
            // n = 7, score = 500
            //   0bcd                 | or                  ecx, ebp
            //   33f1                 | xor                 esi, ecx
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   0b4c242c             | or                  ecx, dword ptr [esp + 0x2c]
            //   c1e807               | shr                 eax, 7
            //   c1e319               | shl                 ebx, 0x19
            //   0bc3                 | or                  eax, ebx

        $sequence_5 = { 3bc6 741c 3930 7418 }
            // n = 4, score = 500
            //   3bc6                 | cmp                 eax, esi
            //   741c                 | je                  0x1e
            //   3930                 | cmp                 dword ptr [eax], esi
            //   7418                 | je                  0x1a

        $sequence_6 = { 134c241c 01442438 89442458 8b442420 114c243c 8bf8 0facdf1c }
            // n = 7, score = 500
            //   134c241c             | adc                 ecx, dword ptr [esp + 0x1c]
            //   01442438             | add                 dword ptr [esp + 0x38], eax
            //   89442458             | mov                 dword ptr [esp + 0x58], eax
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   114c243c             | adc                 dword ptr [esp + 0x3c], ecx
            //   8bf8                 | mov                 edi, eax
            //   0facdf1c             | shrd                edi, ebx, 0x1c

        $sequence_7 = { 8b4708 89460c 8b4704 894610 8b4714 894614 8b442408 }
            // n = 7, score = 500
            //   8b4708               | mov                 eax, dword ptr [edi + 8]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   8b4704               | mov                 eax, dword ptr [edi + 4]
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   8b4714               | mov                 eax, dword ptr [edi + 0x14]
            //   894614               | mov                 dword ptr [esi + 0x14], eax
            //   8b442408             | mov                 eax, dword ptr [esp + 8]

        $sequence_8 = { 5f 5b 5d c3 55 8bec 81ecd8000000 }
            // n = 7, score = 500
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   81ecd8000000         | sub                 esp, 0xd8

        $sequence_9 = { 59 85db 742f 56 ff742414 }
            // n = 5, score = 500
            //   59                   | pop                 ecx
            //   85db                 | test                ebx, ebx
            //   742f                 | je                  0x31
            //   56                   | push                esi
            //   ff742414             | push                dword ptr [esp + 0x14]

    condition:
        7 of them and filesize < 188416
}