rule win_heyoka_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.heyoka."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.heyoka"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? ff15???????? b801000000 5d c3 55 8bec }
            // n = 7, score = 100
            //   e8????????           |                     
            //   ff15????????         |                     
            //   b801000000           | mov                 eax, 1
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_1 = { 8b5118 895018 a1???????? 8b4dfc 894818 8b55fc 8915???????? }
            // n = 7, score = 100
            //   8b5118               | mov                 edx, dword ptr [ecx + 0x18]
            //   895018               | mov                 dword ptr [eax + 0x18], edx
            //   a1????????           |                     
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   894818               | mov                 dword ptr [eax + 0x18], ecx
            //   8b55fc               | mov                 edx, dword ptr [ebp - 4]
            //   8915????????         |                     

        $sequence_2 = { 0345f8 8a4df1 8848ff 8b55f8 3b550c 7c02 eb02 }
            // n = 7, score = 100
            //   0345f8               | add                 eax, dword ptr [ebp - 8]
            //   8a4df1               | mov                 cl, byte ptr [ebp - 0xf]
            //   8848ff               | mov                 byte ptr [eax - 1], cl
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   3b550c               | cmp                 edx, dword ptr [ebp + 0xc]
            //   7c02                 | jl                  4
            //   eb02                 | jmp                 4

        $sequence_3 = { 8bec 8b4508 33c9 8a480c 51 8b5508 83c20d }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   33c9                 | xor                 ecx, ecx
            //   8a480c               | mov                 cl, byte ptr [eax + 0xc]
            //   51                   | push                ecx
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   83c20d               | add                 edx, 0xd

        $sequence_4 = { 8b45ec 8945f4 8b4df7 81e1ff000000 51 8b55f6 81e2ff000000 }
            // n = 7, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8945f4               | mov                 dword ptr [ebp - 0xc], eax
            //   8b4df7               | mov                 ecx, dword ptr [ebp - 9]
            //   81e1ff000000         | and                 ecx, 0xff
            //   51                   | push                ecx
            //   8b55f6               | mov                 edx, dword ptr [ebp - 0xa]
            //   81e2ff000000         | and                 edx, 0xff

        $sequence_5 = { 8b0d???????? 894df8 683f420f00 6a00 8b15???????? 52 e8???????? }
            // n = 7, score = 100
            //   8b0d????????         |                     
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   683f420f00           | push                0xf423f
            //   6a00                 | push                0
            //   8b15????????         |                     
            //   52                   | push                edx
            //   e8????????           |                     

        $sequence_6 = { 8bec 81ec18040000 57 c685f0fbffff00 b9ff000000 33c0 8dbdf1fbffff }
            // n = 7, score = 100
            //   8bec                 | mov                 ebp, esp
            //   81ec18040000         | sub                 esp, 0x418
            //   57                   | push                edi
            //   c685f0fbffff00       | mov                 byte ptr [ebp - 0x410], 0
            //   b9ff000000           | mov                 ecx, 0xff
            //   33c0                 | xor                 eax, eax
            //   8dbdf1fbffff         | lea                 edi, [ebp - 0x40f]

        $sequence_7 = { 8bc3 885d0b c1e808 88450a 0fb6c0 f68061d7011004 }
            // n = 6, score = 100
            //   8bc3                 | mov                 eax, ebx
            //   885d0b               | mov                 byte ptr [ebp + 0xb], bl
            //   c1e808               | shr                 eax, 8
            //   88450a               | mov                 byte ptr [ebp + 0xa], al
            //   0fb6c0               | movzx               eax, al
            //   f68061d7011004       | test                byte ptr [eax + 0x1001d761], 4

        $sequence_8 = { 8b7508 8b06 8945c0 3bc3 7545 8d45c0 50 }
            // n = 7, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   3bc3                 | cmp                 eax, ebx
            //   7545                 | jne                 0x47
            //   8d45c0               | lea                 eax, [ebp - 0x40]
            //   50                   | push                eax

        $sequence_9 = { 8b5590 83c201 895590 8b4590 3b4510 0f87ab000000 8b4d0c }
            // n = 7, score = 100
            //   8b5590               | mov                 edx, dword ptr [ebp - 0x70]
            //   83c201               | add                 edx, 1
            //   895590               | mov                 dword ptr [ebp - 0x70], edx
            //   8b4590               | mov                 eax, dword ptr [ebp - 0x70]
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   0f87ab000000         | ja                  0xb1
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 270336
}