rule win_hi_zor_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hi_zor_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hi_zor_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 235014 0bda 8b501c 03df 8d9413aff7448b 8bde }
            // n = 6, score = 200
            //   235014               | and                 edx, dword ptr [eax + 0x14]
            //   0bda                 | or                  ebx, edx
            //   8b501c               | mov                 edx, dword ptr [eax + 0x1c]
            //   03df                 | add                 ebx, edi
            //   8d9413aff7448b       | lea                 edx, [ebx + edx - 0x74bb0851]
            //   8bde                 | mov                 ebx, esi

        $sequence_1 = { 83c002 6685c9 75f5 8dbdc8f6ffff 2bc2 83c7fe 668b4f02 }
            // n = 7, score = 200
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   8dbdc8f6ffff         | lea                 edi, [ebp - 0x938]
            //   2bc2                 | sub                 eax, edx
            //   83c7fe               | add                 edi, -2
            //   668b4f02             | mov                 cx, word ptr [edi + 2]

        $sequence_2 = { c1e611 0bd6 03501c 8bfa f7d7 237810 23da }
            // n = 7, score = 200
            //   c1e611               | shl                 esi, 0x11
            //   0bd6                 | or                  edx, esi
            //   03501c               | add                 edx, dword ptr [eax + 0x1c]
            //   8bfa                 | mov                 edi, edx
            //   f7d7                 | not                 edi
            //   237810               | and                 edi, dword ptr [eax + 0x10]
            //   23da                 | and                 ebx, edx

        $sequence_3 = { 33db 68fe0f0000 8d94248e080000 33c9 53 52 }
            // n = 6, score = 200
            //   33db                 | xor                 ebx, ebx
            //   68fe0f0000           | push                0xffe
            //   8d94248e080000       | lea                 edx, [esp + 0x88e]
            //   33c9                 | xor                 ecx, ecx
            //   53                   | push                ebx
            //   52                   | push                edx

        $sequence_4 = { 8bf8 52 57 ff15???????? 8b4d0c 8b5508 6a00 }
            // n = 7, score = 200
            //   8bf8                 | mov                 edi, eax
            //   52                   | push                edx
            //   57                   | push                edi
            //   ff15????????         |                     
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   6a00                 | push                0

        $sequence_5 = { 6a00 8bf0 8d45f0 50 56 6a00 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   8bf0                 | mov                 esi, eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   50                   | push                eax
            //   56                   | push                esi
            //   6a00                 | push                0

        $sequence_6 = { 25ffffff1f 03c0 6a40 03c0 c1ea1d }
            // n = 5, score = 200
            //   25ffffff1f           | and                 eax, 0x1fffffff
            //   03c0                 | add                 eax, eax
            //   6a40                 | push                0x40
            //   03c0                 | add                 eax, eax
            //   c1ea1d               | shr                 edx, 0x1d

        $sequence_7 = { 50 89bb40010000 89bd58ffffff ff15???????? }
            // n = 4, score = 200
            //   50                   | push                eax
            //   89bb40010000         | mov                 dword ptr [ebx + 0x140], edi
            //   89bd58ffffff         | mov                 dword ptr [ebp - 0xa8], edi
            //   ff15????????         |                     

        $sequence_8 = { 035858 8975fc 8b701c 8d9c335314c4ff 8b75f8 23f7 }
            // n = 6, score = 200
            //   035858               | add                 ebx, dword ptr [eax + 0x58]
            //   8975fc               | mov                 dword ptr [ebp - 4], esi
            //   8b701c               | mov                 esi, dword ptr [eax + 0x1c]
            //   8d9c335314c4ff       | lea                 ebx, [ebx + esi - 0x3bebad]
            //   8b75f8               | mov                 esi, dword ptr [ebp - 8]
            //   23f7                 | and                 esi, edi

        $sequence_9 = { 0fb6b6b4490010 ff24b594490010 52 53 8bf9 e8???????? 5f }
            // n = 7, score = 200
            //   0fb6b6b4490010       | movzx               esi, byte ptr [esi + 0x100049b4]
            //   ff24b594490010       | jmp                 dword ptr [esi*4 + 0x10004994]
            //   52                   | push                edx
            //   53                   | push                ebx
            //   8bf9                 | mov                 edi, ecx
            //   e8????????           |                     
            //   5f                   | pop                 edi

    condition:
        7 of them and filesize < 73728
}