rule win_hive_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hive."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hive"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 31c0 b91d000000 31d2 31db }
            // n = 4, score = 300
            //   31c0                 | inc                 eax
            //   b91d000000           | movzx               edx, dh
            //   31d2                 | add                 eax, ecx
            //   31db                 | shl                 eax, 6

        $sequence_1 = { 31c9 eb12 0fb6540c12 0fb63408 }
            // n = 4, score = 200
            //   31c9                 | nop                 
            //   eb12                 | mov                 ecx, edx
            //   0fb6540c12           | mov                 ecx, 1
            //   0fb63408             | mov                 ecx, edx

        $sequence_2 = { 89c2 e8???????? b801000000 e8???????? }
            // n = 4, score = 200
            //   89c2                 | inc                 eax
            //   e8????????           |                     
            //   b801000000           | movzx               edx, dh
            //   e8????????           |                     

        $sequence_3 = { 31c9 31d2 31db 31f6 31ff eb09 }
            // n = 6, score = 200
            //   31c9                 | mov                 esi, 0x41
            //   31d2                 | xor                 eax, eax
            //   31db                 | xor                 ecx, ecx
            //   31f6                 | xor                 edx, edx
            //   31ff                 | mov                 ebx, 6
            //   eb09                 | mov                 esi, 0x41

        $sequence_4 = { 31c0 31c9 31d2 bb01000000 beae000000 }
            // n = 5, score = 200
            //   31c0                 | xor                 ebx, ebx
            //   31c9                 | xor                 ecx, ecx
            //   31d2                 | jmp                 0x16
            //   bb01000000           | movzx               edx, byte ptr [esp + ecx + 0x12]
            //   beae000000           | movzx               esi, byte ptr [eax + ecx]

        $sequence_5 = { 89d1 e8???????? b802000000 e8???????? }
            // n = 4, score = 200
            //   89d1                 | add                 edx, ecx
            //   e8????????           |                     
            //   b802000000           | add                 edx, ecx
            //   e8????????           |                     

        $sequence_6 = { 81c4b0000000 c3 e8???????? 90 }
            // n = 4, score = 200
            //   81c4b0000000         | inc                 eax
            //   c3                   | movzx               ecx, bh
            //   e8????????           |                     
            //   90                   | add                 ecx, eax

        $sequence_7 = { 0fb6b40495000000 89d7 31f2 01c2 }
            // n = 4, score = 200
            //   0fb6b40495000000     | mov                 dword ptr [esp + 0xc4], esi
            //   89d7                 | sub                 esi, ecx
            //   31f2                 | inc                 esi
            //   01c2                 | mov                 dword ptr [esp + 0xc0], esi

        $sequence_8 = { 89d1 e8???????? b901000000 e8???????? }
            // n = 4, score = 200
            //   89d1                 | add                 eax, edx
            //   e8????????           |                     
            //   b901000000           | dec                 ebp
            //   e8????????           |                     

        $sequence_9 = { 0fb7442404 8b0c24 894c246a 668944246e 8b4c246a }
            // n = 5, score = 200
            //   0fb7442404           | xchg                eax, edi
            //   8b0c24               | mov                 byte ptr [esp + 0x43], al
            //   894c246a             | xchg                eax, edi
            //   668944246e           | mov                 dword ptr [esp], ebp
            //   8b4c246a             | mov                 dword ptr [esp + 0x80], edi

        $sequence_10 = { 0fb7744c12 89d7 31f2 01ca }
            // n = 4, score = 200
            //   0fb7744c12           | shl                 edi, 2
            //   89d7                 | xchg                esi, ebx
            //   31f2                 | mov                 dword ptr [esp + 0x80], edi
            //   01ca                 | mov                 edi, dword ptr [ecx + 0x18]

        $sequence_11 = { 31c9 31d2 bb04000000 beb8000000 }
            // n = 4, score = 200
            //   31c9                 | xor                 edx, edx
            //   31d2                 | mov                 ebx, 8
            //   bb04000000           | mov                 esi, 0x20
            //   beb8000000           | xor                 edi, edi

        $sequence_12 = { 01c1 83c101 83f90c 0f820fffffff }
            // n = 4, score = 100
            //   01c1                 | je                  0x274
            //   83c101               | add                 eax, eax
            //   83f90c               | inc                 eax
            //   0f820fffffff         | add                 al, bh

        $sequence_13 = { 89bc2478020000 81c438020000 c3 97 88442443 97 892c24 }
            // n = 7, score = 100
            //   89bc2478020000       | movzx               eax, bl
            //   81c438020000         | add                 eax, edx
            //   c3                   | dec                 ebp
            //   97                   | test                edi, edi
            //   88442443             | je                  0xfffffd70
            //   97                   | add                 edx, ecx
            //   892c24               | shl                 edx, 6

        $sequence_14 = { 01c8 89c1 c1e91f ffc9 }
            // n = 4, score = 100
            //   01c8                 | movzx               eax, bl
            //   89c1                 | add                 eax, edx
            //   c1e91f               | add                 edx, eax
            //   ffc9                 | mov                 eax, 0x3ffffff

        $sequence_15 = { 89bc2480000000 89b424c4000000 29ce 46 }
            // n = 4, score = 100
            //   89bc2480000000       | movzx               eax, bl
            //   89b424c4000000       | add                 eax, edx
            //   29ce                 | dec                 ebp
            //   46                   | test                edi, edi

        $sequence_16 = { 01c1 c1e106 0fb6c2 01c8 }
            // n = 4, score = 100
            //   01c1                 | jb                  0xfffffe99
            //   c1e106               | mov                 edx, 5
            //   0fb6c2               | add                 ecx, eax
            //   01c8                 | add                 ecx, 1

        $sequence_17 = { 01c2 b8ffffff03 21c5 21c3 }
            // n = 4, score = 100
            //   01c2                 | inc                 eax
            //   b8ffffff03           | movzx               edx, dh
            //   21c5                 | add                 edx, ecx
            //   21c3                 | add                 ecx, eax

        $sequence_18 = { 01c8 c1e006 400fb6cf 01c1 }
            // n = 4, score = 100
            //   01c8                 | and                 ecx, eax
            //   c1e006               | inc                 ecx
            //   400fb6cf             | mov                 dword ptr [edi + 0x14], ecx
            //   01c1                 | add                 eax, ecx

        $sequence_19 = { 01c1 c1e106 400fb6d6 01ca }
            // n = 4, score = 100
            //   01c1                 | add                 ecx, eax
            //   c1e106               | shl                 ecx, 6
            //   400fb6d6             | movzx               eax, dl
            //   01ca                 | add                 eax, ecx

        $sequence_20 = { 01ca c1e206 0fb6c3 01d0 }
            // n = 4, score = 100
            //   01ca                 | mov                 ecx, eax
            //   c1e206               | shr                 ecx, 0x1f
            //   0fb6c3               | dec                 ecx
            //   01d0                 | inc                 ecx

        $sequence_21 = { 01c0 4000f8 0fb6c0 48898424b0000000 }
            // n = 4, score = 100
            //   01c0                 | add                 eax, eax
            //   4000f8               | inc                 eax
            //   0fb6c0               | add                 al, bh
            //   48898424b0000000     | movzx               eax, al

    condition:
        7 of them and filesize < 7946240
}