rule win_holerun_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.holerun."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.holerun"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488d45c0 4989c9 4989d0 ba00040000 4889c1 e8???????? 488b85f0030000 }
            // n = 7, score = 100
            //   488d45c0             | dec                 eax
            //   4989c9               | add                 eax, edx
            //   4989d0               | dec                 eax
            //   ba00040000           | shl                 eax, 3
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   488b85f0030000       | add                 eax, ecx

        $sequence_1 = { 488b85e0020000 488b4008 ba20000000 4889c1 e8???????? 488985c0020000 4883bdc002000000 }
            // n = 7, score = 100
            //   488b85e0020000       | mov                 dword ptr [ebp - 0x44], 0
            //   488b4008             | dec                 eax
            //   ba20000000           | mov                 ecx, eax
            //   4889c1               | dec                 eax
            //   e8????????           |                     
            //   488985c0020000       | mov                 dword ptr [ebp - 0x18], eax
            //   4883bdc002000000     | dec                 eax

        $sequence_2 = { 750a b8ffffffff e9???????? 488b4510 488b00 8b00 3d910000c0 }
            // n = 7, score = 100
            //   750a                 | jmp                 0x33e
            //   b8ffffffff           | nop                 
            //   e9????????           |                     
            //   488b4510             | dec                 eax
            //   488b00               | mov                 eax, dword ptr [ebp + 0x18]
            //   8b00                 | dec                 ecx
            //   3d910000c0           | mov                 eax, edx

        $sequence_3 = { 48837df000 751b 488b4510 488b00 488d1502380000 }
            // n = 5, score = 100
            //   48837df000           | mov                 eax, dword ptr [ebp - 8]
            //   751b                 | dec                 eax
            //   488b4510             | mov                 ecx, 0xffffffff
            //   488b00               | dec                 eax
            //   488d1502380000       | mov                 edx, eax

        $sequence_4 = { ba20000000 4889c1 e8???????? 488945f0 48837df000 0f84dd000000 488345f001 }
            // n = 7, score = 100
            //   ba20000000           | mov                 ecx, 0
            //   4889c1               | dec                 ecx
            //   e8????????           |                     
            //   488945f0             | mov                 eax, ecx
            //   48837df000           | dec                 eax
            //   0f84dd000000         | mov                 dword ptr [ebp - 0x58], 0
            //   488345f001           | dec                 eax

        $sequence_5 = { eb31 488b05???????? ffd0 89c1 488b85e0020000 }
            // n = 5, score = 100
            //   eb31                 | cmp                 eax, 1
            //   488b05????????       |                     
            //   ffd0                 | jb                  0x68b
            //   89c1                 | cmp                 eax, 2
            //   488b85e0020000       | je                  0x6fd

        $sequence_6 = { 488345f808 488d050f8a0000 483945f8 75d1 b801000000 4883c430 5d }
            // n = 7, score = 100
            //   488345f808           | je                  0x504
            //   488d050f8a0000       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   483945f8             | jmp                 0x532
            //   75d1                 | test                eax, eax
            //   b801000000           | jne                 0x513
            //   4883c430             | mov                 eax, 0
            //   5d                   | jmp                 0x535

        $sequence_7 = { 48c1e002 4889c2 488d0549650000 890c02 }
            // n = 4, score = 100
            //   48c1e002             | dec                 eax
            //   4889c2               | mov                 eax, dword ptr [ebp - 8]
            //   488d0549650000       | inc                 ecx
            //   890c02               | mov                 eax, 0

        $sequence_8 = { 488985a0000000 c785cc02000000000000 e9???????? 8b85cc020000 4898 488b84c590000000 }
            // n = 6, score = 100
            //   488985a0000000       | dec                 eax
            //   c785cc02000000000000     | sub    edx, eax
            //   e9????????           |                     
            //   8b85cc020000         | dec                 eax
            //   4898                 | mov                 eax, edx
            //   488b84c590000000     | dec                 eax

        $sequence_9 = { 750c b91f000000 e8???????? eb39 488b05???????? 8b00 85c0 }
            // n = 7, score = 100
            //   750c                 | dec                 eax
            //   b91f000000           | mov                 dword ptr [ebp - 0x30], eax
            //   e8????????           |                     
            //   eb39                 | dec                 eax
            //   488b05????????       |                     
            //   8b00                 | mov                 edx, dword ptr [ebp - 0x30]
            //   85c0                 | dec                 eax

    condition:
        7 of them and filesize < 156672
}