rule win_homefry_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.homefry."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.homefry"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4157 4883ec20 4c8b7908 0fb701 4d8bf0 410fb61f 4c8bda }
            // n = 7, score = 100
            //   4157                 | add                 eax, 0xffffff78
            //   4883ec20             | jae                 0x354
            //   4c8b7908             | jmp                 0x354
            //   0fb701               | dec                 eax
            //   4d8bf0               | cmovae              ebx, ecx
            //   410fb61f             | dec                 eax
            //   4c8bda               | lea                 ecx, [0x14bb]

        $sequence_1 = { c744246038020000 ff15???????? 85c0 751d }
            // n = 4, score = 100
            //   c744246038020000     | dec                 ecx
            //   ff15????????         |                     
            //   85c0                 | add                 eax, ebx
            //   751d                 | dec                 ecx

        $sequence_2 = { 410fb61f 4c8bda 83f801 7623 }
            // n = 4, score = 100
            //   410fb61f             | xor                 esi, esi
            //   4c8bda               | dec                 eax
            //   83f801               | lea                 ecx, [0x2b75]
            //   7623                 | mov                 edx, esi

        $sequence_3 = { 488905???????? ff15???????? 488b0d???????? 448b4c2470 4c8b05???????? 488b15???????? }
            // n = 6, score = 100
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488b0d????????       |                     
            //   448b4c2470           | add                 esp, 0x20
            //   4c8b05????????       |                     
            //   488b15????????       |                     

        $sequence_4 = { ffd5 85c0 0f8860010000 488b0d???????? 458d4e20 4c8d05480f0000 488b09 }
            // n = 7, score = 100
            //   ffd5                 | inc                 edi
            //   85c0                 | dec                 eax
            //   0f8860010000         | mov                 dword ptr [ecx], eax
            //   488b0d????????       |                     
            //   458d4e20             | mov                 ecx, dword ptr [ebx + ebp]
            //   4c8d05480f0000       | mov                 eax, ebx
            //   488b09               | cmp                 dword ptr [esi], ecx

        $sequence_5 = { e9???????? 480578ffffff 833d????????06 488905???????? }
            // n = 4, score = 100
            //   e9????????           |                     
            //   480578ffffff         | lea                 eax, [ecx - 1]
            //   833d????????06       |                     
            //   488905????????       |                     

        $sequence_6 = { 751c 488d0d8f060000 488b742440 488b7c2448 4883c420 415e }
            // n = 6, score = 100
            //   751c                 | mov                 ebp, eax
            //   488d0d8f060000       | dec                 eax
            //   488b742440           | mov                 ebx, dword ptr [esp + 0x30]
            //   488b7c2448           | test                al, al
            //   4883c420             | je                  0x1184
            //   415e                 | mov                 ecx, edi

        $sequence_7 = { 7343 0f1f8000000000 4983c9ff 488bd7 488bcb }
            // n = 5, score = 100
            //   7343                 | mov                 ecx, dword ptr [ecx]
            //   0f1f8000000000       | dec                 eax
            //   4983c9ff             | lea                 edx, [0xf33]
            //   488bd7               | inc                 esp
            //   488bcb               | mov                 dword ptr [esp + 0x20], esi

        $sequence_8 = { 488917 48630a 4883c104 4803ca 48890f }
            // n = 5, score = 100
            //   488917               | mov                 ecx, ebx
            //   48630a               | dec                 eax
            //   4883c104             | add                 edx, ecx
            //   4803ca               | mov                 edx, dword ptr [esp + 0x38]
            //   48890f               | dec                 eax

        $sequence_9 = { 742e 48ffc3 483bdd 72d0 488bcf ff15???????? 33c0 }
            // n = 7, score = 100
            //   742e                 | mov                 dword ptr [esp + 0x30], esi
            //   48ffc3               | inc                 ecx
            //   483bdd               | mov                 eax, 0x38
            //   72d0                 | dec                 eax
            //   488bcf               | mov                 edx, ebx
            //   ff15????????         |                     
            //   33c0                 | test                al, al

    condition:
        7 of them and filesize < 65536
}