rule win_hoplight_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hoplight."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hoplight"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b442450 c70000000000 c705????????00000100 b800000100 eb53 488b442440 4889442428 }
            // n = 7, score = 100
            //   488b442450           | mov                 eax, dword ptr [esp + 0x14]
            //   c70000000000         | imul                eax, dword ptr [esp + 0x24]
            //   c705????????00000100     |     
            //   b800000100           | mov                 dword ptr [esp + 0xc], eax
            //   eb53                 | mov                 eax, dword ptr [esp + 0x14]
            //   488b442440           | imul                eax, dword ptr [esp + 8]
            //   4889442428           | dec                 eax

        $sequence_1 = { 0fb6542434 488b4c2450 e8???????? 488b442450 8b80ccaf0600 488b4c2450 488d8401b8af0100 }
            // n = 7, score = 100
            //   0fb6542434           | movzx               eax, word ptr [ecx + eax*4 + 0x20]
            //   488b4c2450           | mov                 ecx, dword ptr [esp + 8]
            //   e8????????           |                     
            //   488b442450           | add                 ecx, eax
            //   8b80ccaf0600         | mov                 eax, ecx
            //   488b4c2450           | mov                 dword ptr [esp + 8], eax
            //   488d8401b8af0100     | mov                 eax, dword ptr [esp]

        $sequence_2 = { 488bcb 488905???????? ff15???????? 488d158c620400 488bcb 488905???????? ff15???????? }
            // n = 7, score = 100
            //   488bcb               | dec                 eax
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d158c620400       | mov                 ecx, ebx
            //   488bcb               | dec                 eax
            //   488905????????       |                     
            //   ff15????????         |                     

        $sequence_3 = { 488b442428 488b8018020000 4889442428 41b820020000 33d2 488b4c2430 e8???????? }
            // n = 7, score = 100
            //   488b442428           | mov                 dword ptr [esp + 0x18], eax
            //   488b8018020000       | dec                 eax
            //   4889442428           | mov                 dword ptr [esp + 0x10], edx
            //   41b820020000         | dec                 eax
            //   33d2                 | mov                 dword ptr [esp + 8], ecx
            //   488b4c2430           | dec                 eax
            //   e8????????           |                     

        $sequence_4 = { 4883c004 4889842418020000 8b442414 0faf442424 8944240c 8b442414 0faf442408 }
            // n = 7, score = 100
            //   4883c004             | lea                 edx, [0x4628c]
            //   4889842418020000     | dec                 eax
            //   8b442414             | mov                 ecx, ebx
            //   0faf442424           | dec                 eax
            //   8944240c             | add                 eax, 4
            //   8b442414             | dec                 eax
            //   0faf442408           | mov                 dword ptr [esp + 0x218], eax

        $sequence_5 = { 488b4878 e8???????? b801000000 eb76 41b800420000 33d2 488b442440 }
            // n = 7, score = 100
            //   488b4878             | sub                 esp, 0x48
            //   e8????????           |                     
            //   b801000000           | dec                 eax
            //   eb76                 | mov                 ecx, dword ptr [esp + 0x50]
            //   41b800420000         | mov                 dword ptr [esp + 0x20], eax
            //   33d2                 | dec                 eax
            //   488b442440           | mov                 ecx, dword ptr [esp + 0x20]

        $sequence_6 = { 4489442418 4889542410 48894c2408 4883ec48 488b4c2450 e8???????? 89442420 }
            // n = 7, score = 100
            //   4489442418           | dec                 eax
            //   4889542410           | mov                 dword ptr [esp + 0x28], eax
            //   48894c2408           | dec                 eax
            //   4883ec48             | sub                 ecx, eax
            //   488b4c2450           | dec                 eax
            //   e8????????           |                     
            //   89442420             | mov                 eax, ecx

        $sequence_7 = { 482bc8 488bc1 4883f801 7d0a b814ffffff e9???????? 488b8424d0000000 }
            // n = 7, score = 100
            //   482bc8               | mov                 eax, dword ptr [esp + 0x50]
            //   488bc1               | mov                 dword ptr [eax], 0
            //   4883f801             | mov                 eax, 0x10000
            //   7d0a                 | jmp                 0x5a
            //   b814ffffff           | dec                 eax
            //   e9????????           |                     
            //   488b8424d0000000     | mov                 eax, dword ptr [esp + 0x40]

    condition:
        7 of them and filesize < 765952
}