rule win_hopscotch_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hopscotch."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hopscotch"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d0480 8d0480 c1e002 50 ffd7 }
            // n = 5, score = 100
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   8d0480               | lea                 eax, [eax + eax*4]
            //   c1e002               | shl                 eax, 2
            //   50                   | push                eax
            //   ffd7                 | call                edi

        $sequence_1 = { 55 ffd3 8bf0 85f6 0f8569ffffff 68???????? e8???????? }
            // n = 7, score = 100
            //   55                   | push                ebp
            //   ffd3                 | call                ebx
            //   8bf0                 | mov                 esi, eax
            //   85f6                 | test                esi, esi
            //   0f8569ffffff         | jne                 0xffffff6f
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_2 = { a1???????? 83c420 85c0 5f 5e 5b }
            // n = 6, score = 100
            //   a1????????           |                     
            //   83c420               | add                 esp, 0x20
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_3 = { 6800800000 8b0d???????? 8b5150 52 ffd6 53 }
            // n = 6, score = 100
            //   6800800000           | push                0x8000
            //   8b0d????????         |                     
            //   8b5150               | mov                 edx, dword ptr [ecx + 0x50]
            //   52                   | push                edx
            //   ffd6                 | call                esi
            //   53                   | push                ebx

        $sequence_4 = { 85c0 5f 5e 5b 7414 }
            // n = 5, score = 100
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   7414                 | je                  0x16

        $sequence_5 = { 83c724 3bf0 72d8 eb2a 8b942430020000 8b4c2410 }
            // n = 6, score = 100
            //   83c724               | add                 edi, 0x24
            //   3bf0                 | cmp                 esi, eax
            //   72d8                 | jb                  0xffffffda
            //   eb2a                 | jmp                 0x2c
            //   8b942430020000       | mov                 edx, dword ptr [esp + 0x230]
            //   8b4c2410             | mov                 ecx, dword ptr [esp + 0x10]

        $sequence_6 = { c3 81ec08020000 8d442400 56 8d4c2408 }
            // n = 5, score = 100
            //   c3                   | ret                 
            //   81ec08020000         | sub                 esp, 0x208
            //   8d442400             | lea                 eax, [esp]
            //   56                   | push                esi
            //   8d4c2408             | lea                 ecx, [esp + 8]

        $sequence_7 = { 6a21 50 e8???????? 83c408 c78424a400000002000000 8db42428010000 }
            // n = 6, score = 100
            //   6a21                 | push                0x21
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   c78424a400000002000000     | mov    dword ptr [esp + 0xa4], 2
            //   8db42428010000       | lea                 esi, [esp + 0x128]

        $sequence_8 = { 833d????????01 750d 8b442404 50 e8???????? 83c404 }
            // n = 6, score = 100
            //   833d????????01       |                     
            //   750d                 | jne                 0xf
            //   8b442404             | mov                 eax, dword ptr [esp + 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_9 = { 8b3d???????? 83c408 8d442408 50 ffd7 }
            // n = 5, score = 100
            //   8b3d????????         |                     
            //   83c408               | add                 esp, 8
            //   8d442408             | lea                 eax, [esp + 8]
            //   50                   | push                eax
            //   ffd7                 | call                edi

    condition:
        7 of them and filesize < 1143808
}