rule win_horus_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.horus."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.horus"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b456f 3bc7 0f8458ffffff 488b757f 897d6f 8b456f 3bc7 }
            // n = 7, score = 100
            //   8b456f               | cmp                 eax, 0x1ee1e
            //   3bc7                 | jne                 0xcb5
            //   0f8458ffffff         | mov                 dword ptr [ebp + 0x110], 0x55da
            //   488b757f             | mov                 eax, dword ptr [ebp + 0x110]
            //   897d6f               | cmp                 eax, eax
            //   8b456f               | jne                 0x226
            //   3bc7                 | dec                 eax

        $sequence_1 = { 57 4883ec20 488b19 488bf9 4885db 0f84de000000 488b7378 }
            // n = 7, score = 100
            //   57                   | mov                 dword ptr [ebp + 0x268], edx
            //   4883ec20             | call                edi
            //   488b19               | mov                 dword ptr [esp + 0x50], 0x1c043
            //   488bf9               | inc                 ebp
            //   4885db               | xor                 edx, edx
            //   0f84de000000         | mov                 dword ptr [ebp + 0x11c], eax
            //   488b7378             | jmp                 0x1db

        $sequence_2 = { 4c8945e8 488d4550 488945e0 65488b042560000000 488b4818 488b4110 488b08 }
            // n = 7, score = 100
            //   4c8945e8             | mov                 dword ptr [ebp + 0x370], 0x3e6c
            //   488d4550             | mov                 eax, dword ptr [ebp + 0x370]
            //   488945e0             | cmp                 eax, eax
            //   65488b042560000000     | jne    0x4e8
            //   488b4818             | dec                 eax
            //   488b4110             | mov                 eax, dword ptr [0x60]
            //   488b08               | jmp                 0x456

        $sequence_3 = { 480f499df0000000 4885db 742f 488d4307 b908000000 8000d9 48ffc8 }
            // n = 7, score = 100
            //   480f499df0000000     | je                  0x196
            //   4885db               | dec                 eax
            //   742f                 | test                ebx, ebx
            //   488d4307             | cmp                 byte ptr [eax], 0x74
            //   b908000000           | sete                dl
            //   8000d9               | inc                 ecx
            //   48ffc8               | call                eax

        $sequence_4 = { 488b5df8 eb02 33db 4885db 7429 488d4307 b908000000 }
            // n = 7, score = 100
            //   488b5df8             | mov                 eax, dword ptr [esp + 0x20]
            //   eb02                 | cmp                 eax, 0x5eaf
            //   33db                 | je                  0xfc
            //   4885db               | dec                 eax
            //   7429                 | mov                 ecx, dword ptr [ebp + 0xd0]
            //   488d4307             | dec                 eax
            //   b908000000           | test                ecx, ecx

        $sequence_5 = { 4c8bc6 488bc8 33d2 ff15???????? 49833c2400 0f8494000000 bd01000000 }
            // n = 7, score = 100
            //   4c8bc6               | mov                 word ptr [esp + 0x50], ax
            //   488bc8               | inc                 ebp
            //   33d2                 | xor                 edi, edi
            //   ff15????????         |                     
            //   49833c2400           | movsd               qword ptr [ebp - 0x60], xmm0
            //   0f8494000000         | mov                 byte ptr [esp + 0x7c], al
            //   bd01000000           | movups              xmmword ptr [ebp + 0x150], xmm0

        $sequence_6 = { 83632c00 83633000 c7456f04fa0100 e9???????? 83637c00 488d4b04 488bd6 }
            // n = 7, score = 100
            //   83632c00             | je                  0x45c
            //   83633000             | dec                 eax
            //   c7456f04fa0100       | mov                 ecx, esi
            //   e9????????           |                     
            //   83637c00             | xor                 edx, edx
            //   488d4b04             | xor                 eax, eax
            //   488bd6               | jmp                 0x46e

        $sequence_7 = { 7457 3d21c40100 0f84d8000000 3d84c80100 0f85cf000000 488b4580 4885c0 }
            // n = 7, score = 100
            //   7457                 | xor                 edi, edi
            //   3d21c40100           | mov                 eax, dword ptr [esp + 0x20]
            //   0f84d8000000         | cmp                 eax, eax
            //   3d84c80100           | jne                 0x502
            //   0f85cf000000         | xor                 ebx, ebx
            //   488b4580             | je                  0x287
            //   4885c0               | mov                 dword ptr [esp + 0x40], 0x3e04

        $sequence_8 = { b803000000 c3 83792800 7427 488b5118 48837a0800 741c }
            // n = 7, score = 100
            //   b803000000           | je                  0x667
            //   c3                   | cmp                 eax, 0x1b8cb
            //   83792800             | jne                 0x819
            //   7427                 | mov                 dword ptr [ebp + 0x6f], 0x38a
            //   488b5118             | xor                 ebx, ebx
            //   48837a0800           | mov                 eax, dword ptr [ebp + 0x6f]
            //   741c                 | cmp                 eax, 0x1ea79

        $sequence_9 = { 0f849e000000 3d45940100 7465 3d56a60100 7441 3dffdc0100 7424 }
            // n = 7, score = 100
            //   0f849e000000         | dec                 eax
            //   3d45940100           | lea                 eax, [ebp + 0x68]
            //   7465                 | dec                 esp
            //   3d56a60100           | lea                 ecx, [ebp + 0x70]
            //   7441                 | dec                 esp
            //   3dffdc0100           | lea                 eax, [ebp + 0x7f8]
            //   7424                 | dec                 eax

    condition:
        7 of them and filesize < 887808
}