rule win_hotwax_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hotwax."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hotwax"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 807d580a 4c8d05737dffff 740f eb07 4c8d05687dffff 448823 48ffc3 }
            // n = 7, score = 100
            //   807d580a             | dec                 ecx
            //   4c8d05737dffff       | jmp                 0x9f
            //   740f                 | mov                 eax, dword ptr [edi + 0x18]
            //   eb07                 | test                eax, eax
            //   4c8d05687dffff       | je                  0xec
            //   448823               | mov                 ebx, dword ptr [edi + 0x20]
            //   48ffc3               | inc                 ecx

        $sequence_1 = { 488d542448 488d8c2400020000 e8???????? 488b5c2448 85c0 740b ff15???????? }
            // n = 7, score = 100
            //   488d542448           | mov                 eax, esp
            //   488d8c2400020000     | dec                 eax
            //   e8????????           |                     
            //   488b5c2448           | mov                 ecx, eax
            //   85c0                 | dec                 eax
            //   740b                 | mov                 edi, eax
            //   ff15????????         |                     

        $sequence_2 = { 4889842410030000 488bf9 488d8c2401020000 33d2 41b803010000 c684240002000000 }
            // n = 6, score = 100
            //   4889842410030000     | dec                 esp
            //   488bf9               | lea                 esi, [0xc2d8]
            //   488d8c2401020000     | and                 ebx, 0x1f
            //   33d2                 | dec                 eax
            //   41b803010000         | imul                ebx, ebx, 0x58
            //   c684240002000000     | dec                 ebx

        $sequence_3 = { 488d15edd30000 488bcb 488905???????? ff15???????? 488d15bed30000 }
            // n = 5, score = 100
            //   488d15edd30000       | dec                 eax
            //   488bcb               | add                 edi, ebp
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488d15bed30000       | je                  0xce3

        $sequence_4 = { 4533db 488d9424f0000000 41b803010000 44895c2440 4c895c2448 ff15???????? 833d????????00 }
            // n = 7, score = 100
            //   4533db               | dec                 esp
            //   488d9424f0000000     | mov                 dword ptr [ebp - 0x78], esp
            //   41b803010000         | dec                 esp
            //   44895c2440           | mov                 dword ptr [ebp - 0x70], ebp
            //   4c895c2448           | dec                 eax
            //   ff15????????         |                     
            //   833d????????00       |                     

        $sequence_5 = { 486bd258 490394c1a04b0100 f6423880 742c }
            // n = 4, score = 100
            //   486bd258             | mov                 dword ptr [esp + 0x20], 0x40
            //   490394c1a04b0100     | add                 ecx, 0xfff
            //   f6423880             | inc                 esp
            //   742c                 | add                 esp, edx

        $sequence_6 = { c785080500004c647247 c7850c05000065745072 c785100500006f636564 c7851405000075726541 c7851805000064647265 }
            // n = 5, score = 100
            //   c785080500004c647247     | dec    eax
            //   c7850c05000065745072     | mov    ecx, ebx
            //   c785100500006f636564     | dec    eax
            //   c7851405000075726541     | lea    edx, [0xd0b1]
            //   c7851805000064647265     | dec    eax

        $sequence_7 = { 0f84da000000 488b9424b0000000 8bd8 410fb7f6 4803da 488d3c0a 488b0b }
            // n = 7, score = 100
            //   0f84da000000         | dec                 eax
            //   488b9424b0000000     | mov                 ecx, ebx
            //   8bd8                 | dec                 eax
            //   410fb7f6             | lea                 edx, [0xd666]
            //   4803da               | dec                 eax
            //   488d3c0a             | mov                 ecx, ebx
            //   488b0b               | dec                 eax

        $sequence_8 = { 488b0d???????? eb7c 4c8d256a830000 488b0d???????? eb6c e8???????? }
            // n = 6, score = 100
            //   488b0d????????       |                     
            //   eb7c                 | dec                 esp
            //   4c8d256a830000       | lea                 eax, [esp + 0xb8]
            //   488b0d????????       |                     
            //   eb6c                 | dec                 eax
            //   e8????????           |                     

        $sequence_9 = { 33c0 e9???????? 48895c2408 4c63c1 488d1d45770000 4d8bc8 }
            // n = 6, score = 100
            //   33c0                 | jb                  0x468
            //   e9????????           |                     
            //   48895c2408           | dec                 eax
            //   4c63c1               | lea                 eax, [0xb9d5]
            //   488d1d45770000       | dec                 eax
            //   4d8bc8               | cmp                 ecx, eax

    condition:
        7 of them and filesize < 198656
}