rule win_htbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.htbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.htbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6857000780 e8???????? 83c601 8d4e0a 3bcd 0f8db6000000 85f6 }
            // n = 7, score = 100
            //   6857000780           | push                0x80070057
            //   e8????????           |                     
            //   83c601               | add                 esi, 1
            //   8d4e0a               | lea                 ecx, [esi + 0xa]
            //   3bcd                 | cmp                 ecx, ebp
            //   0f8db6000000         | jge                 0xbc
            //   85f6                 | test                esi, esi

        $sequence_1 = { 83c002 6685c9 75f5 2bc2 d1f8 0f88ce020000 }
            // n = 6, score = 100
            //   83c002               | add                 eax, 2
            //   6685c9               | test                cx, cx
            //   75f5                 | jne                 0xfffffff7
            //   2bc2                 | sub                 eax, edx
            //   d1f8                 | sar                 eax, 1
            //   0f88ce020000         | js                  0x2d4

        $sequence_2 = { 8d7c241c 8d442420 c644246003 e8???????? 85c0 0f84e1000000 8d4900 }
            // n = 7, score = 100
            //   8d7c241c             | lea                 edi, [esp + 0x1c]
            //   8d442420             | lea                 eax, [esp + 0x20]
            //   c644246003           | mov                 byte ptr [esp + 0x60], 3
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f84e1000000         | je                  0xe7
            //   8d4900               | lea                 ecx, [ecx]

        $sequence_3 = { c68424b410000004 e8???????? 8b442430 8b00 8b8c24b8100000 8d542448 }
            // n = 6, score = 100
            //   c68424b410000004     | mov                 byte ptr [esp + 0x10b4], 4
            //   e8????????           |                     
            //   8b442430             | mov                 eax, dword ptr [esp + 0x30]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b8c24b8100000       | mov                 ecx, dword ptr [esp + 0x10b8]
            //   8d542448             | lea                 edx, [esp + 0x48]

        $sequence_4 = { 8b11 50 8b4204 ffd0 c64424340a 8b44241c }
            // n = 6, score = 100
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   50                   | push                eax
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   ffd0                 | call                eax
            //   c64424340a           | mov                 byte ptr [esp + 0x34], 0xa
            //   8b44241c             | mov                 eax, dword ptr [esp + 0x1c]

        $sequence_5 = { 51 8b4ef0 8b11 8b4210 83c6f0 89642428 8bdc }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8b4ef0               | mov                 ecx, dword ptr [esi - 0x10]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b4210               | mov                 eax, dword ptr [edx + 0x10]
            //   83c6f0               | add                 esi, -0x10
            //   89642428             | mov                 dword ptr [esp + 0x28], esp
            //   8bdc                 | mov                 ebx, esp

        $sequence_6 = { 8b4c2414 51 ff15???????? 8d54241c 52 }
            // n = 5, score = 100
            //   8b4c2414             | mov                 ecx, dword ptr [esp + 0x14]
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   8d54241c             | lea                 edx, [esp + 0x1c]
            //   52                   | push                edx

        $sequence_7 = { 8b11 8b4204 57 ffd0 83c510 896c2414 }
            // n = 6, score = 100
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b4204               | mov                 eax, dword ptr [edx + 4]
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   83c510               | add                 ebp, 0x10
            //   896c2414             | mov                 dword ptr [esp + 0x14], ebp

        $sequence_8 = { 384802 7550 384803 744b 83c004 3808 7418 }
            // n = 7, score = 100
            //   384802               | cmp                 byte ptr [eax + 2], cl
            //   7550                 | jne                 0x52
            //   384803               | cmp                 byte ptr [eax + 3], cl
            //   744b                 | je                  0x4d
            //   83c004               | add                 eax, 4
            //   3808                 | cmp                 byte ptr [eax], cl
            //   7418                 | je                  0x1a

        $sequence_9 = { 2bc1 d1f8 83f8ff 755c 3959f4 }
            // n = 5, score = 100
            //   2bc1                 | sub                 eax, ecx
            //   d1f8                 | sar                 eax, 1
            //   83f8ff               | cmp                 eax, -1
            //   755c                 | jne                 0x5e
            //   3959f4               | cmp                 dword ptr [ecx - 0xc], ebx

    condition:
        7 of them and filesize < 196608
}