rule win_htprat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.htprat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.htprat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 8db794010000 c645fc0c e8???????? 53 }
            // n = 5, score = 200
            //   53                   | push                ebx
            //   8db794010000         | lea                 esi, [edi + 0x194]
            //   c645fc0c             | mov                 byte ptr [ebp - 4], 0xc
            //   e8????????           |                     
            //   53                   | push                ebx

        $sequence_1 = { 743c 33c0 57 50 668985d8f9ffff }
            // n = 5, score = 200
            //   743c                 | je                  0x3e
            //   33c0                 | xor                 eax, eax
            //   57                   | push                edi
            //   50                   | push                eax
            //   668985d8f9ffff       | mov                 word ptr [ebp - 0x628], ax

        $sequence_2 = { 8bcb e8???????? 57 57 89b398000000 }
            // n = 5, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     
            //   57                   | push                edi
            //   57                   | push                edi
            //   89b398000000         | mov                 dword ptr [ebx + 0x98], esi

        $sequence_3 = { 57 57 57 ffb574efffff }
            // n = 4, score = 200
            //   57                   | push                edi
            //   57                   | push                edi
            //   57                   | push                edi
            //   ffb574efffff         | push                dword ptr [ebp - 0x108c]

        $sequence_4 = { 832700 8d7708 c6470400 e8???????? 8365fc00 bb???????? 53 }
            // n = 7, score = 200
            //   832700               | and                 dword ptr [edi], 0
            //   8d7708               | lea                 esi, [edi + 8]
            //   c6470400             | mov                 byte ptr [edi + 4], 0
            //   e8????????           |                     
            //   8365fc00             | and                 dword ptr [ebp - 4], 0
            //   bb????????           |                     
            //   53                   | push                ebx

        $sequence_5 = { e9???????? 6a22 e9???????? 6a0c e9???????? 83e96e 7479 }
            // n = 7, score = 200
            //   e9????????           |                     
            //   6a22                 | push                0x22
            //   e9????????           |                     
            //   6a0c                 | push                0xc
            //   e9????????           |                     
            //   83e96e               | sub                 ecx, 0x6e
            //   7479                 | je                  0x7b

        $sequence_6 = { 8d742430 e8???????? 8bd6 8d4c2418 c68424e800000009 }
            // n = 5, score = 200
            //   8d742430             | lea                 esi, [esp + 0x30]
            //   e8????????           |                     
            //   8bd6                 | mov                 edx, esi
            //   8d4c2418             | lea                 ecx, [esp + 0x18]
            //   c68424e800000009     | mov                 byte ptr [esp + 0xe8], 9

        $sequence_7 = { 83671000 c747140f000000 c60700 837de810 8b45d4 895d80 }
            // n = 6, score = 200
            //   83671000             | and                 dword ptr [edi + 0x10], 0
            //   c747140f000000       | mov                 dword ptr [edi + 0x14], 0xf
            //   c60700               | mov                 byte ptr [edi], 0
            //   837de810             | cmp                 dword ptr [ebp - 0x18], 0x10
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   895d80               | mov                 dword ptr [ebp - 0x80], ebx

        $sequence_8 = { 8d442468 ff742478 50 8d8424a8000000 50 e8???????? 83c40c }
            // n = 7, score = 200
            //   8d442468             | lea                 eax, [esp + 0x68]
            //   ff742478             | push                dword ptr [esp + 0x78]
            //   50                   | push                eax
            //   8d8424a8000000       | lea                 eax, [esp + 0xa8]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_9 = { 8d741eff 8d5801 56 57 }
            // n = 4, score = 200
            //   8d741eff             | lea                 esi, [esi + ebx - 1]
            //   8d5801               | lea                 ebx, [eax + 1]
            //   56                   | push                esi
            //   57                   | push                edi

    condition:
        7 of them and filesize < 278528
}