rule win_http_troy_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.http_troy."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.http_troy"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 33c9 894c241d 8d443bfb 3be8 66894c2421 8bf5 c644241c00 }
            // n = 7, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   894c241d             | mov                 dword ptr [esp + 0x1d], ecx
            //   8d443bfb             | lea                 eax, [ebx + edi - 5]
            //   3be8                 | cmp                 ebp, eax
            //   66894c2421           | mov                 word ptr [esp + 0x21], cx
            //   8bf5                 | mov                 esi, ebp
            //   c644241c00           | mov                 byte ptr [esp + 0x1c], 0

        $sequence_1 = { 895e70 899e90000000 895e74 750a 5e b800000100 }
            // n = 6, score = 200
            //   895e70               | mov                 dword ptr [esi + 0x70], ebx
            //   899e90000000         | mov                 dword ptr [esi + 0x90], ebx
            //   895e74               | mov                 dword ptr [esi + 0x74], ebx
            //   750a                 | jne                 0xc
            //   5e                   | pop                 esi
            //   b800000100           | mov                 eax, 0x10000

        $sequence_2 = { 8d442414 50 8d4c241c 51 6a00 6a00 6a00 }
            // n = 7, score = 200
            //   8d442414             | lea                 eax, [esp + 0x14]
            //   50                   | push                eax
            //   8d4c241c             | lea                 ecx, [esp + 0x1c]
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0

        $sequence_3 = { 33f1 33f0 03f3 8dbc37a9cfde4b 8bf7 c1e70b 8b5c2430 }
            // n = 7, score = 200
            //   33f1                 | xor                 esi, ecx
            //   33f0                 | xor                 esi, eax
            //   03f3                 | add                 esi, ebx
            //   8dbc37a9cfde4b       | lea                 edi, [edi + esi + 0x4bdecfa9]
            //   8bf7                 | mov                 esi, edi
            //   c1e70b               | shl                 edi, 0xb
            //   8b5c2430             | mov                 ebx, dword ptr [esp + 0x30]

        $sequence_4 = { e8???????? 83c418 ff7508 e8???????? 83c404 833d????????00 752c }
            // n = 7, score = 200
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   833d????????00       |                     
            //   752c                 | jne                 0x2e

        $sequence_5 = { 0bd3 4f 8956fc 75da }
            // n = 4, score = 200
            //   0bd3                 | or                  edx, ebx
            //   4f                   | dec                 edi
            //   8956fc               | mov                 dword ptr [esi - 4], edx
            //   75da                 | jne                 0xffffffdc

        $sequence_6 = { e8???????? 59 83e6fb e9???????? 84c3 0f84d8000000 f6451008 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   83e6fb               | and                 esi, 0xfffffffb
            //   e9????????           |                     
            //   84c3                 | test                bl, al
            //   0f84d8000000         | je                  0xde
            //   f6451008             | test                byte ptr [ebp + 0x10], 8

        $sequence_7 = { 6802000080 c744242800000000 ff15???????? 8b542418 8d442408 }
            // n = 5, score = 200
            //   6802000080           | push                0x80000002
            //   c744242800000000     | mov                 dword ptr [esp + 0x28], 0
            //   ff15????????         |                     
            //   8b542418             | mov                 edx, dword ptr [esp + 0x18]
            //   8d442408             | lea                 eax, [esp + 8]

        $sequence_8 = { 8d8c2478010000 51 ffd6 b801000000 8b8c2414110000 e8???????? 5f }
            // n = 7, score = 200
            //   8d8c2478010000       | lea                 ecx, [esp + 0x178]
            //   51                   | push                ecx
            //   ffd6                 | call                esi
            //   b801000000           | mov                 eax, 1
            //   8b8c2414110000       | mov                 ecx, dword ptr [esp + 0x1114]
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_9 = { 6a00 68???????? e8???????? 8b54241c 83c404 50 52 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   68????????           |                     
            //   e8????????           |                     
            //   8b54241c             | mov                 edx, dword ptr [esp + 0x1c]
            //   83c404               | add                 esp, 4
            //   50                   | push                eax
            //   52                   | push                edx

    condition:
        7 of them and filesize < 475136
}