rule win_httpbrowser_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.httpbrowser."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.httpbrowser"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 751d 68???????? ffb5f0fdffff ff15???????? ffb5f0fdffff ff15???????? 56 }
            // n = 7, score = 200
            //   751d                 | jne                 0x1f
            //   68????????           |                     
            //   ffb5f0fdffff         | push                dword ptr [ebp - 0x210]
            //   ff15????????         |                     
            //   ffb5f0fdffff         | push                dword ptr [ebp - 0x210]
            //   ff15????????         |                     
            //   56                   | push                esi

        $sequence_1 = { 6800010000 8d85f8feffff 50 ff15???????? 8d85f8feffff }
            // n = 5, score = 200
            //   6800010000           | push                0x100
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8d85f8feffff         | lea                 eax, [ebp - 0x108]

        $sequence_2 = { 8bec 81ecac020000 a1???????? 33c5 8945fc 57 8d8558fdffff }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   81ecac020000         | sub                 esp, 0x2ac
            //   a1????????           |                     
            //   33c5                 | xor                 eax, ebp
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   57                   | push                edi
            //   8d8558fdffff         | lea                 eax, [ebp - 0x2a8]

        $sequence_3 = { eb3c 8b85e4fdffff 8985f4fdffff 3bc6 74ec 53 }
            // n = 6, score = 200
            //   eb3c                 | jmp                 0x3e
            //   8b85e4fdffff         | mov                 eax, dword ptr [ebp - 0x21c]
            //   8985f4fdffff         | mov                 dword ptr [ebp - 0x20c], eax
            //   3bc6                 | cmp                 eax, esi
            //   74ec                 | je                  0xffffffee
            //   53                   | push                ebx

        $sequence_4 = { 33db 56 8985e8eeffff 8d85fdeeffff 53 50 8bf9 }
            // n = 7, score = 200
            //   33db                 | xor                 ebx, ebx
            //   56                   | push                esi
            //   8985e8eeffff         | mov                 dword ptr [ebp - 0x1118], eax
            //   8d85fdeeffff         | lea                 eax, [ebp - 0x1103]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   8bf9                 | mov                 edi, ecx

        $sequence_5 = { 6a04 8d85a0feffff 50 6a13 }
            // n = 4, score = 200
            //   6a04                 | push                4
            //   8d85a0feffff         | lea                 eax, [ebp - 0x160]
            //   50                   | push                eax
            //   6a13                 | push                0x13

        $sequence_6 = { ffd6 83bd6453ffff14 7552 8d85c855ffff 50 }
            // n = 5, score = 200
            //   ffd6                 | call                esi
            //   83bd6453ffff14       | cmp                 dword ptr [ebp - 0xac9c], 0x14
            //   7552                 | jne                 0x54
            //   8d85c855ffff         | lea                 eax, [ebp - 0xaa38]
            //   50                   | push                eax

        $sequence_7 = { 8d85fefdffff 50 e8???????? ffb5f4edffff }
            // n = 4, score = 200
            //   8d85fefdffff         | lea                 eax, [ebp - 0x202]
            //   50                   | push                eax
            //   e8????????           |                     
            //   ffb5f4edffff         | push                dword ptr [ebp - 0x120c]

        $sequence_8 = { 8b7508 8d4dec 6a00 8d55fc 51 }
            // n = 5, score = 100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   8d4dec               | lea                 ecx, [ebp - 0x14]
            //   6a00                 | push                0
            //   8d55fc               | lea                 edx, [ebp - 4]
            //   51                   | push                ecx

        $sequence_9 = { 33c0 8dbdb2fcffff 668995b0fcffff f3ab }
            // n = 4, score = 100
            //   33c0                 | xor                 eax, eax
            //   8dbdb2fcffff         | lea                 edi, [ebp - 0x34e]
            //   668995b0fcffff       | mov                 word ptr [ebp - 0x350], dx
            //   f3ab                 | rep stosd           dword ptr es:[edi], eax

        $sequence_10 = { 56 e8???????? 8bf8 83c408 85ff 7422 66891f }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c408               | add                 esp, 8
            //   85ff                 | test                edi, edi
            //   7422                 | je                  0x24
            //   66891f               | mov                 word ptr [edi], bx

        $sequence_11 = { 5d 9d 5d 8b4dfc 51 }
            // n = 5, score = 100
            //   5d                   | pop                 ebp
            //   9d                   | popfd               
            //   5d                   | pop                 ebp
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   51                   | push                ecx

        $sequence_12 = { 50 8b4508 51 50 52 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   51                   | push                ecx
            //   50                   | push                eax
            //   52                   | push                edx

        $sequence_13 = { e8???????? 83c410 8b4d08 6a00 68???????? }
            // n = 5, score = 100
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_14 = { ff15???????? b940000000 33c0 8dbdfcfeffff }
            // n = 4, score = 100
            //   ff15????????         |                     
            //   b940000000           | mov                 ecx, 0x40
            //   33c0                 | xor                 eax, eax
            //   8dbdfcfeffff         | lea                 edi, [ebp - 0x104]

        $sequence_15 = { 8d741202 56 e8???????? 8bd0 83c404 85d2 8955f8 }
            // n = 7, score = 100
            //   8d741202             | lea                 esi, [edx + edx + 2]
            //   56                   | push                esi
            //   e8????????           |                     
            //   8bd0                 | mov                 edx, eax
            //   83c404               | add                 esp, 4
            //   85d2                 | test                edx, edx
            //   8955f8               | mov                 dword ptr [ebp - 8], edx

    condition:
        7 of them and filesize < 188416
}