rule win_hui_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hui_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hui_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bc8 83e01f c1f905 56 57 8b348d60e20010 }
            // n = 6, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   83e01f               | and                 eax, 0x1f
            //   c1f905               | sar                 ecx, 5
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b348d60e20010       | mov                 esi, dword ptr [ecx*4 + 0x1000e260]

        $sequence_1 = { 83c028 83c12c 4a 75eb b902000000 8d742454 83f901 }
            // n = 7, score = 100
            //   83c028               | add                 eax, 0x28
            //   83c12c               | add                 ecx, 0x2c
            //   4a                   | dec                 edx
            //   75eb                 | jne                 0xffffffed
            //   b902000000           | mov                 ecx, 2
            //   8d742454             | lea                 esi, [esp + 0x54]
            //   83f901               | cmp                 ecx, 1

        $sequence_2 = { 8db604b40010 6a00 50 ff36 e8???????? }
            // n = 5, score = 100
            //   8db604b40010         | lea                 esi, [esi + 0x1000b404]
            //   6a00                 | push                0
            //   50                   | push                eax
            //   ff36                 | push                dword ptr [esi]
            //   e8????????           |                     

        $sequence_3 = { 75f8 42 83c628 83fa0a 7ce6 b931000000 33c0 }
            // n = 7, score = 100
            //   75f8                 | jne                 0xfffffffa
            //   42                   | inc                 edx
            //   83c628               | add                 esi, 0x28
            //   83fa0a               | cmp                 edx, 0xa
            //   7ce6                 | jl                  0xffffffe8
            //   b931000000           | mov                 ecx, 0x31
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 68???????? ff15???????? 6a00 6a00 6a00 8bf0 6a04 }
            // n = 7, score = 100
            //   68????????           |                     
            //   ff15????????         |                     
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   8bf0                 | mov                 esi, eax
            //   6a04                 | push                4

        $sequence_5 = { 80f95c 7408 8a48ff 48 3acb 75f3 }
            // n = 6, score = 100
            //   80f95c               | cmp                 cl, 0x5c
            //   7408                 | je                  0xa
            //   8a48ff               | mov                 cl, byte ptr [eax - 1]
            //   48                   | dec                 eax
            //   3acb                 | cmp                 cl, bl
            //   75f3                 | jne                 0xfffffff5

        $sequence_6 = { 56 ff15???????? 8bf8 85ff 7506 50 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7506                 | jne                 8
            //   50                   | push                eax

        $sequence_7 = { 6880000000 6a03 53 6a02 6800000080 68???????? }
            // n = 6, score = 100
            //   6880000000           | push                0x80
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   6a02                 | push                2
            //   6800000080           | push                0x80000000
            //   68????????           |                     

        $sequence_8 = { ffd0 68e8030000 ffd6 8b0d???????? }
            // n = 4, score = 100
            //   ffd0                 | call                eax
            //   68e8030000           | push                0x3e8
            //   ffd6                 | call                esi
            //   8b0d????????         |                     

        $sequence_9 = { 6a03 53 6a02 6800000080 68???????? ff15???????? }
            // n = 6, score = 100
            //   6a03                 | push                3
            //   53                   | push                ebx
            //   6a02                 | push                2
            //   6800000080           | push                0x80000000
            //   68????????           |                     
            //   ff15????????         |                     

    condition:
        7 of them and filesize < 131072
}