rule win_huskloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.huskloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.huskloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d7f08 8b048d04330010 ffe0 f7c703000000 7413 8a06 }
            // n = 6, score = 100
            //   8d7f08               | lea                 edi, [edi + 8]
            //   8b048d04330010       | mov                 eax, dword ptr [ecx*4 + 0x10003304]
            //   ffe0                 | jmp                 eax
            //   f7c703000000         | test                edi, 3
            //   7413                 | je                  0x15
            //   8a06                 | mov                 al, byte ptr [esi]

        $sequence_1 = { 894db0 8b048de88d0110 8975b4 8b440618 8b7514 }
            // n = 5, score = 100
            //   894db0               | mov                 dword ptr [ebp - 0x50], ecx
            //   8b048de88d0110       | mov                 eax, dword ptr [ecx*4 + 0x10018de8]
            //   8975b4               | mov                 dword ptr [ebp - 0x4c], esi
            //   8b440618             | mov                 eax, dword ptr [esi + eax + 0x18]
            //   8b7514               | mov                 esi, dword ptr [ebp + 0x14]

        $sequence_2 = { 6a00 6aff 66c7861a0600000111 ff15???????? 85c0 7430 682d060000 }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   6aff                 | push                -1
            //   66c7861a0600000111     | mov    word ptr [esi + 0x61a], 0x1101
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7430                 | je                  0x32
            //   682d060000           | push                0x62d

        $sequence_3 = { 7712 0fb7c1 0faee8 0fb688181c0110 83e10f eb02 }
            // n = 6, score = 100
            //   7712                 | ja                  0x14
            //   0fb7c1               | movzx               eax, cx
            //   0faee8               | lfence              
            //   0fb688181c0110       | movzx               ecx, byte ptr [eax + 0x10011c18]
            //   83e10f               | and                 ecx, 0xf
            //   eb02                 | jmp                 4

        $sequence_4 = { e8???????? c70016000000 e8???????? 5d c20400 53 56 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   c70016000000         | mov                 dword ptr [eax], 0x16
            //   e8????????           |                     
            //   5d                   | pop                 ebp
            //   c20400               | ret                 4
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_5 = { 8904bde88d0110 85c0 7514 6a0c 5e 8975e4 c745fcfeffffff }
            // n = 7, score = 100
            //   8904bde88d0110       | mov                 dword ptr [edi*4 + 0x10018de8], eax
            //   85c0                 | test                eax, eax
            //   7514                 | jne                 0x16
            //   6a0c                 | push                0xc
            //   5e                   | pop                 esi
            //   8975e4               | mov                 dword ptr [ebp - 0x1c], esi
            //   c745fcfeffffff       | mov                 dword ptr [ebp - 4], 0xfffffffe

        $sequence_6 = { 8db708020000 56 ff15???????? 56 ff15???????? 68???????? }
            // n = 6, score = 100
            //   8db708020000         | lea                 esi, [edi + 0x208]
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   68????????           |                     

        $sequence_7 = { 682d060000 6a00 6a04 6a00 6aff ff15???????? 85c0 }
            // n = 7, score = 100
            //   682d060000           | push                0x62d
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   6a00                 | push                0
            //   6aff                 | push                -1
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_8 = { 5e 5d c3 e8???????? 85c0 0f8442310000 c3 }
            // n = 7, score = 100
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f8442310000         | je                  0x3148
            //   c3                   | ret                 

        $sequence_9 = { 7551 e8???????? c70021000000 eb44 c745e002000000 c745e4c45e0110 }
            // n = 6, score = 100
            //   7551                 | jne                 0x53
            //   e8????????           |                     
            //   c70021000000         | mov                 dword ptr [eax], 0x21
            //   eb44                 | jmp                 0x46
            //   c745e002000000       | mov                 dword ptr [ebp - 0x20], 2
            //   c745e4c45e0110       | mov                 dword ptr [ebp - 0x1c], 0x10015ec4

    condition:
        7 of them and filesize < 229376
}