rule win_hyperbro_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hyperbro."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hyperbro"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 e8???????? 8b5620 52 e8???????? 8b4614 50 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8b5620               | mov                 edx, dword ptr [esi + 0x20]
            //   52                   | push                edx
            //   e8????????           |                     
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   50                   | push                eax

        $sequence_1 = { 83fe40 7e33 8b0f 51 e8???????? }
            // n = 5, score = 400
            //   83fe40               | cmp                 esi, 0x40
            //   7e33                 | jle                 0x35
            //   8b0f                 | mov                 ecx, dword ptr [edi]
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_2 = { 8a4b05 884f01 8b4308 83c410 50 8bc6 c7460840000000 }
            // n = 7, score = 400
            //   8a4b05               | mov                 cl, byte ptr [ebx + 5]
            //   884f01               | mov                 byte ptr [edi + 1], cl
            //   8b4308               | mov                 eax, dword ptr [ebx + 8]
            //   83c410               | add                 esp, 0x10
            //   50                   | push                eax
            //   8bc6                 | mov                 eax, esi
            //   c7460840000000       | mov                 dword ptr [esi + 8], 0x40

        $sequence_3 = { c70600000000 c7460400000000 8d5e0c e8???????? 83c404 }
            // n = 5, score = 400
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c7460400000000       | mov                 dword ptr [esi + 4], 0
            //   8d5e0c               | lea                 ebx, [esi + 0xc]
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_4 = { 0f8617feffff 8a17 8816 46 }
            // n = 4, score = 400
            //   0f8617feffff         | jbe                 0xfffffe1d
            //   8a17                 | mov                 dl, byte ptr [edi]
            //   8816                 | mov                 byte ptr [esi], dl
            //   46                   | inc                 esi

        $sequence_5 = { 33ff 3bc7 7412 50 e8???????? 83c404 897e20 }
            // n = 7, score = 400
            //   33ff                 | xor                 edi, edi
            //   3bc7                 | cmp                 eax, edi
            //   7412                 | je                  0x14
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   897e20               | mov                 dword ptr [esi + 0x20], edi

        $sequence_6 = { 8b4614 8b1d???????? 83c404 3bc7 7406 50 ffd3 }
            // n = 7, score = 400
            //   8b4614               | mov                 eax, dword ptr [esi + 0x14]
            //   8b1d????????         |                     
            //   83c404               | add                 esp, 4
            //   3bc7                 | cmp                 eax, edi
            //   7406                 | je                  8
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_7 = { 41 e9???????? 8b442410 8b6c2418 e9???????? 2b4c2428 8b44242c }
            // n = 7, score = 400
            //   41                   | inc                 ecx
            //   e9????????           |                     
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   e9????????           |                     
            //   2b4c2428             | sub                 ecx, dword ptr [esp + 0x28]
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]

        $sequence_8 = { 83c410 85ed 750e 8b7c2410 }
            // n = 4, score = 400
            //   83c410               | add                 esp, 0x10
            //   85ed                 | test                ebp, ebp
            //   750e                 | jne                 0x10
            //   8b7c2410             | mov                 edi, dword ptr [esp + 0x10]

        $sequence_9 = { 895c2430 895c2434 3bfb 7409 57 e8???????? 83c404 }
            // n = 7, score = 400
            //   895c2430             | mov                 dword ptr [esp + 0x30], ebx
            //   895c2434             | mov                 dword ptr [esp + 0x34], ebx
            //   3bfb                 | cmp                 edi, ebx
            //   7409                 | je                  0xb
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

    condition:
        7 of them and filesize < 352256
}