rule win_hyperssl_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hyperssl."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hyperssl"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 742a 8b4028 03c1 7423 56 57 b9???????? }
            // n = 7, score = 200
            //   742a                 | je                  0x2c
            //   8b4028               | mov                 eax, dword ptr [eax + 0x28]
            //   03c1                 | add                 eax, ecx
            //   7423                 | je                  0x25
            //   56                   | push                esi
            //   57                   | push                edi
            //   b9????????           |                     

        $sequence_1 = { 40 4f 75f2 5f 5e e9???????? }
            // n = 6, score = 200
            //   40                   | inc                 eax
            //   4f                   | dec                 edi
            //   75f2                 | jne                 0xfffffff4
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   e9????????           |                     

        $sequence_2 = { 0108 8b4830 3308 56 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   8b4830               | mov                 ecx, dword ptr [eax + 0x30]
            //   3308                 | xor                 ecx, dword ptr [eax]
            //   56                   | push                esi

        $sequence_3 = { 0101 014514 2bf3 8b5d0c c7472400000000 }
            // n = 5, score = 200
            //   0101                 | add                 dword ptr [ecx], eax
            //   014514               | add                 dword ptr [ebp + 0x14], eax
            //   2bf3                 | sub                 esi, ebx
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   c7472400000000       | mov                 dword ptr [edi + 0x24], 0

        $sequence_4 = { 0108 3908 1bc9 f7d9 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   3908                 | cmp                 dword ptr [eax], ecx
            //   1bc9                 | sbb                 ecx, ecx
            //   f7d9                 | neg                 ecx

        $sequence_5 = { e8???????? 33c0 40 5d c20c00 6a08 }
            // n = 6, score = 200
            //   e8????????           |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   6a08                 | push                8

        $sequence_6 = { 5d c20c00 6a08 68???????? e8???????? 8b450c }
            // n = 6, score = 200
            //   5d                   | pop                 ebp
            //   c20c00               | ret                 0xc
            //   6a08                 | push                8
            //   68????????           |                     
            //   e8????????           |                     
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_7 = { 8bc8 85c9 7436 8b413c 03c1 }
            // n = 5, score = 200
            //   8bc8                 | mov                 ecx, eax
            //   85c9                 | test                ecx, ecx
            //   7436                 | je                  0x38
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   03c1                 | add                 eax, ecx

        $sequence_8 = { 0105???????? 8d8d5cffffff 89855cffffff 898560ffffff }
            // n = 4, score = 200
            //   0105????????         |                     
            //   8d8d5cffffff         | lea                 ecx, [ebp - 0xa4]
            //   89855cffffff         | mov                 dword ptr [ebp - 0xa4], eax
            //   898560ffffff         | mov                 dword ptr [ebp - 0xa0], eax

        $sequence_9 = { 5e e9???????? c3 55 8bec }
            // n = 5, score = 200
            //   5e                   | pop                 esi
            //   e9????????           |                     
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp

        $sequence_10 = { 0108 894810 8b4830 3308 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   894810               | mov                 dword ptr [eax + 0x10], ecx
            //   8b4830               | mov                 ecx, dword ptr [eax + 0x30]
            //   3308                 | xor                 ecx, dword ptr [eax]

        $sequence_11 = { 8a10 301401 8a10 301406 40 4f }
            // n = 6, score = 200
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   301401               | xor                 byte ptr [ecx + eax], dl
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   301406               | xor                 byte ptr [esi + eax], dl
            //   40                   | inc                 eax
            //   4f                   | dec                 edi

        $sequence_12 = { 2bc8 2bf0 5f 8a10 }
            // n = 4, score = 200
            //   2bc8                 | sub                 ecx, eax
            //   2bf0                 | sub                 esi, eax
            //   5f                   | pop                 edi
            //   8a10                 | mov                 dl, byte ptr [eax]

        $sequence_13 = { 0108 3310 c1c607 c1c210 }
            // n = 4, score = 200
            //   0108                 | add                 dword ptr [eax], ecx
            //   3310                 | xor                 edx, dword ptr [eax]
            //   c1c607               | rol                 esi, 7
            //   c1c210               | rol                 edx, 0x10

        $sequence_14 = { 0105???????? 8d558c 89458c 894590 }
            // n = 4, score = 200
            //   0105????????         |                     
            //   8d558c               | lea                 edx, [ebp - 0x74]
            //   89458c               | mov                 dword ptr [ebp - 0x74], eax
            //   894590               | mov                 dword ptr [ebp - 0x70], eax

        $sequence_15 = { 33c9 46 2bc3 8944240c 8b5c241c 8d440c2c 0fb61c03 }
            // n = 7, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   46                   | inc                 esi
            //   2bc3                 | sub                 eax, ebx
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax
            //   8b5c241c             | mov                 ebx, dword ptr [esp + 0x1c]
            //   8d440c2c             | lea                 eax, [esp + ecx + 0x2c]
            //   0fb61c03             | movzx               ebx, byte ptr [ebx + eax]

        $sequence_16 = { 017e0c 8d4d08 e8???????? 5f }
            // n = 4, score = 100
            //   017e0c               | add                 dword ptr [esi + 0xc], edi
            //   8d4d08               | lea                 ecx, [ebp + 8]
            //   e8????????           |                     
            //   5f                   | pop                 edi

        $sequence_17 = { 01442428 8b442428 884500 45 }
            // n = 4, score = 100
            //   01442428             | add                 dword ptr [esp + 0x28], eax
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   884500               | mov                 byte ptr [ebp], al
            //   45                   | inc                 ebp

        $sequence_18 = { 016b08 897b04 5f 5e }
            // n = 4, score = 100
            //   016b08               | add                 dword ptr [ebx + 8], ebp
            //   897b04               | mov                 dword ptr [ebx + 4], edi
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi

        $sequence_19 = { 017e0c 395e10 740f ff7610 }
            // n = 4, score = 100
            //   017e0c               | add                 dword ptr [esi + 0xc], edi
            //   395e10               | cmp                 dword ptr [esi + 0x10], ebx
            //   740f                 | je                  0x11
            //   ff7610               | push                dword ptr [esi + 0x10]

        $sequence_20 = { 011d???????? 5f 8935???????? 5e }
            // n = 4, score = 100
            //   011d????????         |                     
            //   5f                   | pop                 edi
            //   8935????????         |                     
            //   5e                   | pop                 esi

        $sequence_21 = { 017e0c 5f 8bc6 5e c20800 }
            // n = 5, score = 100
            //   017e0c               | add                 dword ptr [esi + 0xc], edi
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi
            //   5e                   | pop                 esi
            //   c20800               | ret                 8

        $sequence_22 = { 017e08 50 e8???????? ff0d???????? }
            // n = 4, score = 100
            //   017e08               | add                 dword ptr [esi + 8], edi
            //   50                   | push                eax
            //   e8????????           |                     
            //   ff0d????????         |                     

        $sequence_23 = { 017e08 8bc3 e8???????? c20400 }
            // n = 4, score = 100
            //   017e08               | add                 dword ptr [esi + 8], edi
            //   8bc3                 | mov                 eax, ebx
            //   e8????????           |                     
            //   c20400               | ret                 4

    condition:
        7 of them and filesize < 835584
}