rule win_hzrat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.hzrat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.hzrat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83fa10 7202 8b3e a1???????? 89040f c6440f0400 eb20 }
            // n = 7, score = 100
            //   83fa10               | cmp                 edx, 0x10
            //   7202                 | jb                  4
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   a1????????           |                     
            //   89040f               | mov                 dword ptr [edi + ecx], eax
            //   c6440f0400           | mov                 byte ptr [edi + ecx + 4], 0
            //   eb20                 | jmp                 0x22

        $sequence_1 = { 8b46e6 3b42e6 7462 0faee8 0fb67ee6 0fb642e6 2bf8 }
            // n = 7, score = 100
            //   8b46e6               | mov                 eax, dword ptr [esi - 0x1a]
            //   3b42e6               | cmp                 eax, dword ptr [edx - 0x1a]
            //   7462                 | je                  0x64
            //   0faee8               | lfence              
            //   0fb67ee6             | movzx               edi, byte ptr [esi - 0x1a]
            //   0fb642e6             | movzx               eax, byte ptr [edx - 0x1a]
            //   2bf8                 | sub                 edi, eax

        $sequence_2 = { 33c0 85c9 0f9fc0 8d0c45ffffffff 85c9 0f8559030000 8b461c }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   85c9                 | test                ecx, ecx
            //   0f9fc0               | setg                al
            //   8d0c45ffffffff       | lea                 ecx, [eax*2 - 1]
            //   85c9                 | test                ecx, ecx
            //   0f8559030000         | jne                 0x35f
            //   8b461c               | mov                 eax, dword ptr [esi + 0x1c]

        $sequence_3 = { 8b450c 85c0 7416 8b5508 0fb64c02ff 80b91002420000 }
            // n = 6, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   0fb64c02ff           | movzx               ecx, byte ptr [edx + eax - 1]
            //   80b91002420000       | cmp                 byte ptr [ecx + 0x420210], 0

        $sequence_4 = { 57 6a00 ff15???????? 57 85c0 0f859b000000 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   57                   | push                edi
            //   85c0                 | test                eax, eax
            //   0f859b000000         | jne                 0xa1

        $sequence_5 = { 0f1106 ff15???????? 85c0 0f8484010000 0fb74704 50 ff15???????? }
            // n = 7, score = 100
            //   0f1106               | movups              xmmword ptr [esi], xmm0
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f8484010000         | je                  0x18a
            //   0fb74704             | movzx               eax, word ptr [edi + 4]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_6 = { 8b45ec 8d4e14 83c40c 8b7d08 8b55f0 83c72c c645fc01 }
            // n = 7, score = 100
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   8d4e14               | lea                 ecx, [esi + 0x14]
            //   83c40c               | add                 esp, 0xc
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b55f0               | mov                 edx, dword ptr [ebp - 0x10]
            //   83c72c               | add                 edi, 0x2c
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1

        $sequence_7 = { 8b4dec 8d0411 8b4de8 33d2 }
            // n = 4, score = 100
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   8d0411               | lea                 eax, [ecx + edx]
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   33d2                 | xor                 edx, edx

        $sequence_8 = { 8d4123 3bc1 0f86e6000000 50 0faee8 e8???????? 83c404 }
            // n = 7, score = 100
            //   8d4123               | lea                 eax, [ecx + 0x23]
            //   3bc1                 | cmp                 eax, ecx
            //   0f86e6000000         | jbe                 0xec
            //   50                   | push                eax
            //   0faee8               | lfence              
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_9 = { 8b450c 50 e8???????? 8bc8 83c40c 894df8 }
            // n = 6, score = 100
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8bc8                 | mov                 ecx, eax
            //   83c40c               | add                 esp, 0xc
            //   894df8               | mov                 dword ptr [ebp - 8], ecx

    condition:
        7 of them and filesize < 409600
}