rule win_ice_cache_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ice_cache."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ice_cache"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4156 4157 4883ec30 488b19 498be8 4c8bf2 }
            // n = 6, score = 100
            //   4156                 | je                  0x822
            //   4157                 | dec                 ebp
            //   4883ec30             | test                eax, eax
            //   488b19               | dec                 eax
            //   498be8               | mov                 esi, dword ptr [esp + 0x10]
            //   4c8bf2               | xor                 eax, eax

        $sequence_1 = { 488bd9 4885c0 7479 488d0d0a520200 483bc1 746d 488b83e0000000 }
            // n = 7, score = 100
            //   488bd9               | pop                 ebx
            //   4885c0               | mov                 byte ptr [esi], al
            //   7479                 | dec                 eax
            //   488d0d0a520200       | inc                 ebp
            //   483bc1               | dec                 eax
            //   746d                 | inc                 esi
            //   488b83e0000000       | dec                 eax

        $sequence_2 = { 33d2 498bce e8???????? 90 488d8c24080f0000 e8???????? e9???????? }
            // n = 7, score = 100
            //   33d2                 | mov                 ebx, dword ptr [eax]
            //   498bce               | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [esp + 0x1568]
            //   488d8c24080f0000     | dec                 eax
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_3 = { 0f114a10 4c894110 48c741180f000000 448801 44894220 4883c420 }
            // n = 6, score = 100
            //   0f114a10             | test                eax, eax
            //   4c894110             | setne               bl
            //   48c741180f000000     | dec                 ecx
            //   448801               | cmp                 eax, 8
            //   44894220             | jb                  0x167e
            //   4883c420             | dec                 esp

        $sequence_4 = { 48f7d0 493bc6 0f8694000000 48897c2430 4a8d3c01 4d85f6 746d }
            // n = 7, score = 100
            //   48f7d0               | lea                 edx, [0x476ee]
            //   493bc6               | dec                 eax
            //   0f8694000000         | lea                 ecx, [esp + 0x1608]
            //   48897c2430           | nop                 
            //   4a8d3c01             | nop                 
            //   4d85f6               | dec                 eax
            //   746d                 | lea                 edx, [0x477fe]

        $sequence_5 = { 488b542448 488d4c2448 e8???????? e8???????? e8???????? 0fb6c3 488b4c2468 }
            // n = 7, score = 100
            //   488b542448           | cmp                 dword ptr [eax], edi
            //   488d4c2448           | jne                 0xc93
            //   e8????????           |                     
            //   e8????????           |                     
            //   e8????????           |                     
            //   0fb6c3               | dec                 esp
            //   488b4c2468           | mov                 dword ptr [edx], eax

        $sequence_6 = { 744c 0fb618 48ffc0 48894710 83fbff 7440 }
            // n = 6, score = 100
            //   744c                 | dec                 esp
            //   0fb618               | mov                 esi, edx
            //   48ffc0               | dec                 eax
            //   48894710             | mov                 ebx, ecx
            //   83fbff               | inc                 ebp
            //   7440                 | xor                 ebp, ebp

        $sequence_7 = { 74e8 488bd8 4889442470 493bdf 7410 488d5320 498bce }
            // n = 7, score = 100
            //   74e8                 | dec                 eax
            //   488bd8               | lea                 ecx, [ebp + 7]
            //   4889442470           | inc                 esp
            //   493bdf               | movzx               ecx, word ptr [esp + 0x1158]
            //   7410                 | dec                 eax
            //   488d5320             | lea                 edx, [0x48016]
            //   498bce               | dec                 ecx

        $sequence_8 = { 7536 4c8bc7 488d1502700300 660f1f440000 0fb702 663901 }
            // n = 6, score = 100
            //   7536                 | mov                 eax, dword ptr [ebx]
            //   4c8bc7               | dec                 eax
            //   488d1502700300       | arpl                word ptr [eax], cx
            //   660f1f440000         | dec                 eax
            //   0fb702               | mov                 edx, ecx
            //   663901               | dec                 eax

        $sequence_9 = { 418bf0 4c8d0d0f870100 8bda 4c8d05fe860100 }
            // n = 4, score = 100
            //   418bf0               | lea                 edx, [0xfffdce67]
            //   4c8d0d0f870100       | dec                 eax
            //   8bda                 | mov                 ebx, edx
            //   4c8d05fe860100       | dec                 ebp

    condition:
        7 of them and filesize < 801792
}