rule win_icedid_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.icedid."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.icedid"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 7511 56 57 ff15???????? }
            // n = 6, score = 1300
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7511                 | jne                 0x13
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_1 = { 7411 40 50 6a08 ff15???????? }
            // n = 5, score = 1300
            //   7411                 | je                  0x13
            //   40                   | inc                 eax
            //   50                   | push                eax
            //   6a08                 | push                8
            //   ff15????????         |                     

        $sequence_2 = { 50 ff15???????? 8bf7 8bc6 }
            // n = 4, score = 1300
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf7                 | mov                 esi, edi
            //   8bc6                 | mov                 eax, esi

        $sequence_3 = { 7413 ff36 6a08 ff15???????? }
            // n = 4, score = 1300
            //   7413                 | je                  0x15
            //   ff36                 | push                dword ptr [esi]
            //   6a08                 | push                8
            //   ff15????????         |                     

        $sequence_4 = { 85f6 742c 803e00 7427 6a3b 56 ff15???????? }
            // n = 7, score = 1300
            //   85f6                 | test                esi, esi
            //   742c                 | je                  0x2e
            //   803e00               | cmp                 byte ptr [esi], 0
            //   7427                 | je                  0x29
            //   6a3b                 | push                0x3b
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { 85ff 7418 c60700 47 57 ff15???????? }
            // n = 6, score = 1300
            //   85ff                 | test                edi, edi
            //   7418                 | je                  0x1a
            //   c60700               | mov                 byte ptr [edi], 0
            //   47                   | inc                 edi
            //   57                   | push                edi
            //   ff15????????         |                     

        $sequence_6 = { 68???????? 6a00 ff15???????? 33c0 40 }
            // n = 5, score = 1300
            //   68????????           |                     
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   33c0                 | xor                 eax, eax
            //   40                   | inc                 eax

        $sequence_7 = { 6a3b 56 ff15???????? 8bf8 85ff 7418 }
            // n = 6, score = 1300
            //   6a3b                 | push                0x3b
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   7418                 | je                  0x1a

        $sequence_8 = { e8???????? 8bf0 8d45fc 50 ff75fc 6a05 }
            // n = 6, score = 1000
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   6a05                 | push                5

        $sequence_9 = { 5f 743f 8d5808 0fb713 }
            // n = 4, score = 800
            //   5f                   | pop                 edi
            //   743f                 | je                  0x41
            //   8d5808               | lea                 ebx, [eax + 8]
            //   0fb713               | movzx               edx, word ptr [ebx]

        $sequence_10 = { 03c2 eb5c 8d5004 89542414 8b12 85d2 7454 }
            // n = 7, score = 800
            //   03c2                 | add                 eax, edx
            //   eb5c                 | jmp                 0x5e
            //   8d5004               | lea                 edx, [eax + 4]
            //   89542414             | mov                 dword ptr [esp + 0x14], edx
            //   8b12                 | mov                 edx, dword ptr [edx]
            //   85d2                 | test                edx, edx
            //   7454                 | je                  0x56

        $sequence_11 = { 0132 47 83c302 3bfd 72c4 8b542414 }
            // n = 6, score = 800
            //   0132                 | add                 dword ptr [edx], esi
            //   47                   | inc                 edi
            //   83c302               | add                 ebx, 2
            //   3bfd                 | cmp                 edi, ebp
            //   72c4                 | jb                  0xffffffc6
            //   8b542414             | mov                 edx, dword ptr [esp + 0x14]

        $sequence_12 = { 85d2 7454 8d6af8 d1ed }
            // n = 4, score = 800
            //   85d2                 | test                edx, edx
            //   7454                 | je                  0x56
            //   8d6af8               | lea                 ebp, [edx - 8]
            //   d1ed                 | shr                 ebp, 1

        $sequence_13 = { 8d5808 0fb713 8954241c 66c16c241c0c }
            // n = 4, score = 800
            //   8d5808               | lea                 ebx, [eax + 8]
            //   0fb713               | movzx               edx, word ptr [ebx]
            //   8954241c             | mov                 dword ptr [esp + 0x1c], edx
            //   66c16c241c0c         | shr                 word ptr [esp + 0x1c], 0xc

        $sequence_14 = { 8d4508 50 0fb6440b34 50 ff740b28 }
            // n = 5, score = 800
            //   8d4508               | lea                 eax, [ebp + 8]
            //   50                   | push                eax
            //   0fb6440b34           | movzx               eax, byte ptr [ebx + ecx + 0x34]
            //   50                   | push                eax
            //   ff740b28             | push                dword ptr [ebx + ecx + 0x28]

        $sequence_15 = { 2345fc 8be5 5d c3 55 8bec ff7518 }
            // n = 7, score = 800
            //   2345fc               | and                 eax, dword ptr [ebp - 4]
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   ff7518               | push                dword ptr [ebp + 0x18]

        $sequence_16 = { ff15???????? 85c0 750a b8010000c0 e9???????? }
            // n = 5, score = 400
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc
            //   b8010000c0           | mov                 eax, 0xc0000001
            //   e9????????           |                     

        $sequence_17 = { 8a4173 a808 75f5 a804 }
            // n = 4, score = 400
            //   8a4173               | mov                 al, byte ptr [ecx + 0x73]
            //   a808                 | test                al, 8
            //   75f5                 | jne                 0xfffffff7
            //   a804                 | test                al, 4

        $sequence_18 = { ff5010 85c0 7407 33c0 e9???????? }
            // n = 5, score = 400
            //   ff5010               | call                dword ptr [eax + 0x10]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   33c0                 | xor                 eax, eax
            //   e9????????           |                     

        $sequence_19 = { 89442408 0fb70424 8b4c2408 03c8 }
            // n = 4, score = 200
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   0fb70424             | movzx               eax, word ptr [esp]
            //   8b4c2408             | mov                 ecx, dword ptr [esp + 8]
            //   03c8                 | add                 ecx, eax

        $sequence_20 = { 48 8b523c e8???????? 48 89433c 48 85c0 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   8b523c               | mov                 edx, dword ptr [edx + 0x3c]
            //   e8????????           |                     
            //   48                   | dec                 eax
            //   89433c               | mov                 dword ptr [ebx + 0x3c], eax
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax

        $sequence_21 = { 48 8945b8 48 85c0 0f84db000000 8b4324 48 }
            // n = 7, score = 200
            //   48                   | dec                 eax
            //   8945b8               | mov                 dword ptr [ebp - 0x48], eax
            //   48                   | dec                 eax
            //   85c0                 | test                eax, eax
            //   0f84db000000         | je                  0xe1
            //   8b4324               | mov                 eax, dword ptr [ebx + 0x24]
            //   48                   | dec                 eax

        $sequence_22 = { 4c 8b15???????? 48 8d442450 44 }
            // n = 5, score = 200
            //   4c                   | dec                 esp
            //   8b15????????         |                     
            //   48                   | dec                 eax
            //   8d442450             | lea                 eax, [esp + 0x50]
            //   44                   | inc                 esp

        $sequence_23 = { 49 8943d8 ff15???????? 85c0 }
            // n = 4, score = 200
            //   49                   | dec                 ecx
            //   8943d8               | mov                 dword ptr [ebx - 0x28], eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_24 = { 4c8bc3 33d2 488bc8 ff15???????? 488bb590020000 }
            // n = 5, score = 100
            //   4c8bc3               | dec                 eax
            //   33d2                 | mov                 esi, dword ptr [ebp + 0x290]
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488bb590020000       | mov                 edi, dword ptr [esp + 0x38]

        $sequence_25 = { 3b7b1c 72d7 8b430c 4803c6 0f845affffff 488bcd }
            // n = 6, score = 100
            //   3b7b1c               | dec                 eax
            //   72d7                 | mov                 ecx, eax
            //   8b430c               | dec                 eax
            //   4803c6               | mov                 esi, dword ptr [ebp + 0x290]
            //   0f845affffff         | dec                 eax
            //   488bcd               | lea                 edx, [edi + 2]

        $sequence_26 = { 488d5702 488bce ff15???????? ba22000000 488bce ff15???????? 4885c0 }
            // n = 7, score = 100
            //   488d5702             | xor                 ecx, ecx
            //   488bce               | xor                 edx, edx
            //   ff15????????         |                     
            //   ba22000000           | dec                 esp
            //   488bce               | mov                 eax, ebx
            //   ff15????????         |                     
            //   4885c0               | xor                 edx, edx

        $sequence_27 = { 4289448440 488b5c2428 4c3b5c2430 7307 4c8b742420 }
            // n = 5, score = 100
            //   4289448440           | dec                 eax
            //   488b5c2428           | test                eax, eax
            //   4c3b5c2430           | cmp                 edi, dword ptr [ebx + 0x1c]
            //   7307                 | jb                  0xffffffdc
            //   4c8b742420           | mov                 eax, dword ptr [ebx + 0xc]

        $sequence_28 = { 488bd8 4885c0 0f84cb000000 488bb590020000 41ba01000000 }
            // n = 5, score = 100
            //   488bd8               | dec                 eax
            //   4885c0               | mov                 ecx, esi
            //   0f84cb000000         | mov                 edx, 0x22
            //   488bb590020000       | dec                 eax
            //   41ba01000000         | mov                 ecx, esi

        $sequence_29 = { 488bb590020000 488b7c2438 33c9 33d2 }
            // n = 4, score = 100
            //   488bb590020000       | cmp                 dword ptr [edi], 0
            //   488b7c2438           | jne                 0xffffffbf
            //   33c9                 | dec                 eax
            //   33d2                 | add                 ebx, 0x14

        $sequence_30 = { 80bb8000000040 0f8577ffffff 488d8b81000000 488d542450 e8???????? 85c0 }
            // n = 6, score = 100
            //   80bb8000000040       | inc                 ecx
            //   0f8577ffffff         | mov                 edx, 1
            //   488d8b81000000       | inc                 edx
            //   488d542450           | mov                 dword ptr [esp + eax*4 + 0x40], eax
            //   e8????????           |                     
            //   85c0                 | dec                 eax

        $sequence_31 = { 75b9 4883c314 e9???????? ff15???????? 33c0 }
            // n = 5, score = 100
            //   75b9                 | jne                 0xffffffbb
            //   4883c314             | dec                 eax
            //   e9????????           |                     
            //   ff15????????         |                     
            //   33c0                 | add                 ebx, 0x14

    condition:
        7 of them and filesize < 303104
}