rule win_icefog_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.icefog."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.icefog"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 895de0 c745e400ff0000 e9???????? 8b5e04 c1e310 895de0 c745e40000ff00 }
            // n = 7, score = 200
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   c745e400ff0000       | mov                 dword ptr [ebp - 0x1c], 0xff00
            //   e9????????           |                     
            //   8b5e04               | mov                 ebx, dword ptr [esi + 4]
            //   c1e310               | shl                 ebx, 0x10
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   c745e40000ff00       | mov                 dword ptr [ebp - 0x1c], 0xff0000

        $sequence_1 = { e8???????? 8b759c 53 c60300 e8???????? 8b45b4 83c404 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   8b759c               | mov                 esi, dword ptr [ebp - 0x64]
            //   53                   | push                ebx
            //   c60300               | mov                 byte ptr [ebx], 0
            //   e8????????           |                     
            //   8b45b4               | mov                 eax, dword ptr [ebp - 0x4c]
            //   83c404               | add                 esp, 4

        $sequence_2 = { 8b4d0c 50 51 e8???????? 83c408 8bf0 5e }
            // n = 7, score = 200
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8bf0                 | mov                 esi, eax
            //   5e                   | pop                 esi

        $sequence_3 = { c6470300 8b7d08 75a0 8b5d0c 8b45f4 015f0c 5f }
            // n = 7, score = 200
            //   c6470300             | mov                 byte ptr [edi + 3], 0
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   75a0                 | jne                 0xffffffa2
            //   8b5d0c               | mov                 ebx, dword ptr [ebp + 0xc]
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   015f0c               | add                 dword ptr [edi + 0xc], ebx
            //   5f                   | pop                 edi

        $sequence_4 = { b807000000 5b 8be5 5d c3 8945fc 394604 }
            // n = 7, score = 200
            //   b807000000           | mov                 eax, 7
            //   5b                   | pop                 ebx
            //   8be5                 | mov                 esp, ebp
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   394604               | cmp                 dword ptr [esi + 4], eax

        $sequence_5 = { 8b4dfc 50 51 e8???????? 56 8947f6 e8???????? }
            // n = 7, score = 200
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   50                   | push                eax
            //   51                   | push                ecx
            //   e8????????           |                     
            //   56                   | push                esi
            //   8947f6               | mov                 dword ptr [edi - 0xa], eax
            //   e8????????           |                     

        $sequence_6 = { c3 56 57 e8???????? 83c408 894590 85c0 }
            // n = 7, score = 200
            //   c3                   | ret                 
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   894590               | mov                 dword ptr [ebp - 0x70], eax
            //   85c0                 | test                eax, eax

        $sequence_7 = { dd8570feffff dec3 d9ca dd9560feffff d8d1 dfe0 ddd9 }
            // n = 7, score = 200
            //   dd8570feffff         | fld                 qword ptr [ebp - 0x190]
            //   dec3                 | faddp               st(3)
            //   d9ca                 | fxch                st(2)
            //   dd9560feffff         | fst                 qword ptr [ebp - 0x1a0]
            //   d8d1                 | fcom                st(1)
            //   dfe0                 | fnstsw              ax
            //   ddd9                 | fstp                st(1)

        $sequence_8 = { a1???????? 891490 8b0d???????? 42 3bd1 7ced a1???????? }
            // n = 7, score = 200
            //   a1????????           |                     
            //   891490               | mov                 dword ptr [eax + edx*4], edx
            //   8b0d????????         |                     
            //   42                   | inc                 edx
            //   3bd1                 | cmp                 edx, ecx
            //   7ced                 | jl                  0xffffffef
            //   a1????????           |                     

        $sequence_9 = { 8b4508 85c0 7416 56 8b7010 50 e8???????? }
            // n = 7, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   85c0                 | test                eax, eax
            //   7416                 | je                  0x18
            //   56                   | push                esi
            //   8b7010               | mov                 esi, dword ptr [eax + 0x10]
            //   50                   | push                eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 1187840
}