rule win_icexloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.icexloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.icexloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd7 890424 ffd6 c744240400800000 890424 ffd3 83c41c }
            // n = 7, score = 200
            //   ffd7                 | call                edi
            //   890424               | mov                 dword ptr [esp], eax
            //   ffd6                 | call                esi
            //   c744240400800000     | mov                 dword ptr [esp + 4], 0x8000
            //   890424               | mov                 dword ptr [esp], eax
            //   ffd3                 | call                ebx
            //   83c41c               | add                 esp, 0x1c

        $sequence_1 = { 807de47e 0fb6d8 0f85d9000000 eb53 8b1e 83eb05 39da }
            // n = 7, score = 200
            //   807de47e             | cmp                 byte ptr [ebp - 0x1c], 0x7e
            //   0fb6d8               | movzx               ebx, al
            //   0f85d9000000         | jne                 0xdf
            //   eb53                 | jmp                 0x55
            //   8b1e                 | mov                 ebx, dword ptr [esi]
            //   83eb05               | sub                 ebx, 5
            //   39da                 | cmp                 edx, ebx

        $sequence_2 = { c705????????04000000 c705????????04000000 66c705????????1503 c705????????00c64300 c705????????04000000 c705????????04000000 }
            // n = 6, score = 200
            //   c705????????04000000     |     
            //   c705????????04000000     |     
            //   66c705????????1503     |     
            //   c705????????00c64300     |     
            //   c705????????04000000     |     
            //   c705????????04000000     |     

        $sequence_3 = { e8???????? 85c0 7405 833800 7515 c70424???????? }
            // n = 6, score = 200
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   833800               | cmp                 dword ptr [eax], 0
            //   7515                 | jne                 0x17
            //   c70424????????       |                     

        $sequence_4 = { 89d3 e8???????? 85c0 740f 837cd87800 7406 8d44d878 }
            // n = 7, score = 200
            //   89d3                 | mov                 ebx, edx
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   740f                 | je                  0x11
            //   837cd87800           | cmp                 dword ptr [eax + ebx*8 + 0x78], 0
            //   7406                 | je                  8
            //   8d44d878             | lea                 eax, [eax + ebx*8 + 0x78]

        $sequence_5 = { 46 e8???????? 89da e8???????? ebc8 83c41c 5b }
            // n = 7, score = 200
            //   46                   | inc                 esi
            //   e8????????           |                     
            //   89da                 | mov                 edx, ebx
            //   e8????????           |                     
            //   ebc8                 | jmp                 0xffffffca
            //   83c41c               | add                 esp, 0x1c
            //   5b                   | pop                 ebx

        $sequence_6 = { 8b00 85c0 7405 8b00 8945d4 c645db00 31ff }
            // n = 7, score = 200
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax
            //   7405                 | je                  7
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8945d4               | mov                 dword ptr [ebp - 0x2c], eax
            //   c645db00             | mov                 byte ptr [ebp - 0x25], 0
            //   31ff                 | xor                 edi, edi

        $sequence_7 = { 89c6 e8???????? 8b55e4 895c2408 89f3 c744241c00000000 c744241800000000 }
            // n = 7, score = 200
            //   89c6                 | mov                 esi, eax
            //   e8????????           |                     
            //   8b55e4               | mov                 edx, dword ptr [ebp - 0x1c]
            //   895c2408             | mov                 dword ptr [esp + 8], ebx
            //   89f3                 | mov                 ebx, esi
            //   c744241c00000000     | mov                 dword ptr [esp + 0x1c], 0
            //   c744241800000000     | mov                 dword ptr [esp + 0x18], 0

        $sequence_8 = { 8d4314 e8???????? 8d4310 e8???????? 58 89d9 5b }
            // n = 7, score = 200
            //   8d4314               | lea                 eax, [ebx + 0x14]
            //   e8????????           |                     
            //   8d4310               | lea                 eax, [ebx + 0x10]
            //   e8????????           |                     
            //   58                   | pop                 eax
            //   89d9                 | mov                 ecx, ebx
            //   5b                   | pop                 ebx

        $sequence_9 = { 89e5 83ec10 8b4508 83c014 8945fc 8b4508 8b4010 }
            // n = 7, score = 200
            //   89e5                 | mov                 ebp, esp
            //   83ec10               | sub                 esp, 0x10
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c014               | add                 eax, 0x14
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4010               | mov                 eax, dword ptr [eax + 0x10]

    condition:
        7 of them and filesize < 656384
}