rule win_iconic_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.iconic_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.iconic_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ebc9 4885f6 740f ba68000000 488bce e8???????? eb0a }
            // n = 7, score = 100
            //   ebc9                 | mov                 ecx, 1
            //   4885f6               | dec                 eax
            //   740f                 | lea                 ecx, [eax + eax*2]
            //   ba68000000           | inc                 ecx
            //   488bce               | mov                 ecx, 1
            //   e8????????           |                     
            //   eb0a                 | dec                 ecx

        $sequence_1 = { 498b4a18 8b4148 034144 7912 458bc6 498bd2 e8???????? }
            // n = 7, score = 100
            //   498b4a18             | dec                 esp
            //   8b4148               | mov                 edx, dword ptr [esp + 0xe8]
            //   034144               | test                eax, eax
            //   7912                 | js                  0x1784
            //   458bc6               | jne                 0x16dd
            //   498bd2               | dec                 eax
            //   e8????????           |                     

        $sequence_2 = { ff8bdc000000 c687c500000003 40387367 7407 c7473407000000 b805000000 394734 }
            // n = 7, score = 100
            //   ff8bdc000000         | dec                 ecx
            //   c687c500000003       | mov                 ecx, ebp
            //   40387367             | inc                 ecx
            //   7407                 | inc                 esp
            //   c7473407000000       | dec                 eax
            //   b805000000           | add                 ebx, 0x38
            //   394734               | inc                 esp

        $sequence_3 = { e9???????? f7430400000001 488b0e 4489642454 48894c2468 4c896598 0fb64164 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   f7430400000001       | mov                 byte ptr [edx + 0x1f], al
            //   488b0e               | inc                 ecx
            //   4489642454           | mov                 edx, dword ptr [edx + eax*4 + 0xe0]
            //   48894c2468           | dec                 eax
            //   4c896598             | arpl                word ptr [ebx + 0x90], cx
            //   0fb64164             | inc                 ecx

        $sequence_4 = { e9???????? 41f7450400000100 0f8480020000 4889bc2458010000 498b3e 4c396648 7414 }
            // n = 7, score = 100
            //   e9????????           |                     
            //   41f7450400000100     | mov                 ecx, dword ptr [edx + eax + 0x18]
            //   0f8480020000         | dec                 eax
            //   4889bc2458010000     | lea                 eax, [0x95889]
            //   498b3e               | dec                 eax
            //   4c396648             | mov                 dword ptr [ebp - 0x30], eax
            //   7414                 | inc                 ecx

        $sequence_5 = { e8???????? 488be8 4885c0 0f849d020000 80783f02 0f8493020000 488b542438 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488be8               | inc                 ecx
            //   4885c0               | cmp                 al, byte ptr [edi + 0x2a]
            //   0f849d020000         | inc                 ecx
            //   80783f02             | cmp                 ebp, dword ptr [esp + 0x14]
            //   0f8493020000         | jge                 0xe92
            //   488b542438           | nop                 dword ptr [eax + eax]

        $sequence_6 = { ff15???????? 85c0 0f8494000000 39bc2480000000 0f8487000000 498bd6 4c8d1d8d6c0300 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | inc                 ebp
            //   0f8494000000         | mov                 esp, dword ptr [esi + eax*4 + 0xe0]
            //   39bc2480000000       | inc                 ecx
            //   0f8487000000         | inc                 dword ptr [esi + 0x38]
            //   498bd6               | inc                 ebp
            //   4c8d1d8d6c0300       | mov                 ebp, dword ptr [esi + 0x38]

        $sequence_7 = { b8e08004e0 48094330 44896374 4c89a378020000 4c89a370020000 4c89a380020000 4c89a330020000 }
            // n = 7, score = 100
            //   b8e08004e0           | mov                 ecx, eax
            //   48094330             | inc                 ebp
            //   44896374             | mov                 eax, edi
            //   4c89a378020000       | mov                 edx, 0x5e
            //   4c89a370020000       | dec                 eax
            //   4c89a380020000       | mov                 ecx, ebx
            //   4c89a330020000       | cmp                 dword ptr [ebx + 0x94], ecx

        $sequence_8 = { 744d 4c8bc1 eb48 4c8d442440 4889742440 488d150c780300 4489742448 }
            // n = 7, score = 100
            //   744d                 | mov                 eax, esi
            //   4c8bc1               | inc                 ecx
            //   eb48                 | mov                 edx, ebp
            //   4c8d442440           | dec                 eax
            //   4889742440           | mov                 ecx, esi
            //   488d150c780300       | inc                 ebp
            //   4489742448           | xor                 ecx, ecx

        $sequence_9 = { 4d85c0 741a 410fb74010 6685c0 7f05 6603c8 eb0b }
            // n = 7, score = 100
            //   4d85c0               | dec                 eax
            //   741a                 | arpl                ax, cx
            //   410fb74010           | dec                 ecx
            //   6685c0               | mov                 eax, dword ptr [ebp + 0x3b8]
            //   7f05                 | dec                 eax
            //   6603c8               | lea                 edx, [ecx + ecx*4]
            //   eb0b                 | dec                 eax

    condition:
        7 of them and filesize < 2401280
}