rule win_industroyer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.industroyer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.industroyer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 53 ff75fc e8???????? 57 e8???????? 83c414 56 }
            // n = 7, score = 600
            //   53                   | push                ebx
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c414               | add                 esp, 0x14
            //   56                   | push                esi

        $sequence_1 = { 8d85f8fdffff 56 be04010000 56 50 68???????? }
            // n = 6, score = 600
            //   8d85f8fdffff         | lea                 eax, [ebp - 0x208]
            //   56                   | push                esi
            //   be04010000           | mov                 esi, 0x104
            //   56                   | push                esi
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_2 = { 8d45f4 50 56 57 53 ff15???????? 037df4 }
            // n = 7, score = 600
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   037df4               | add                 edi, dword ptr [ebp - 0xc]

        $sequence_3 = { 53 ffd6 53 e8???????? 59 85c0 }
            // n = 6, score = 600
            //   53                   | push                ebx
            //   ffd6                 | call                esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_4 = { 68???????? 56 56 ff15???????? 57 8bf0 e8???????? }
            // n = 7, score = 600
            //   68????????           |                     
            //   56                   | push                esi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   57                   | push                edi
            //   8bf0                 | mov                 esi, eax
            //   e8????????           |                     

        $sequence_5 = { 50 6a02 56 e8???????? ff7710 6a03 56 }
            // n = 7, score = 600
            //   50                   | push                eax
            //   6a02                 | push                2
            //   56                   | push                esi
            //   e8????????           |                     
            //   ff7710               | push                dword ptr [edi + 0x10]
            //   6a03                 | push                3
            //   56                   | push                esi

        $sequence_6 = { 8d45a8 33f6 57 50 e8???????? }
            // n = 5, score = 600
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   33f6                 | xor                 esi, esi
            //   57                   | push                edi
            //   50                   | push                eax
            //   e8????????           |                     

        $sequence_7 = { 51 50 56 57 ff15???????? 56 e8???????? }
            // n = 7, score = 600
            //   51                   | push                ecx
            //   50                   | push                eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_8 = { 6a02 ff15???????? 8bd8 85db 0f849d000000 8d85d0fdffff c785d0fdffff2c020000 }
            // n = 7, score = 400
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   8bd8                 | mov                 ebx, eax
            //   85db                 | test                ebx, ebx
            //   0f849d000000         | je                  0xa3
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   c785d0fdffff2c020000     | mov    dword ptr [ebp - 0x230], 0x22c

        $sequence_9 = { ff15???????? 89849da0efffff 83c604 43 81fe88000000 7291 }
            // n = 6, score = 400
            //   ff15????????         |                     
            //   89849da0efffff       | mov                 dword ptr [ebp + ebx*4 - 0x1060], eax
            //   83c604               | add                 esi, 4
            //   43                   | inc                 ebx
            //   81fe88000000         | cmp                 esi, 0x88
            //   7291                 | jb                  0xffffff93

        $sequence_10 = { 8b35???????? 0f1f00 f644241810 7451 }
            // n = 4, score = 400
            //   8b35????????         |                     
            //   0f1f00               | nop                 dword ptr [eax]
            //   f644241810           | test                byte ptr [esp + 0x18], 0x10
            //   7451                 | je                  0x53

        $sequence_11 = { e8???????? 83c404 33c0 eb19 8d8d90efffff 51 }
            // n = 6, score = 400
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax
            //   eb19                 | jmp                 0x1b
            //   8d8d90efffff         | lea                 ecx, [ebp - 0x1070]
            //   51                   | push                ecx

        $sequence_12 = { 81ec6c040000 a1???????? 33c4 89842468040000 53 8b1d???????? }
            // n = 6, score = 400
            //   81ec6c040000         | sub                 esp, 0x46c
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842468040000       | mov                 dword ptr [esp + 0x468], eax
            //   53                   | push                ebx
            //   8b1d????????         |                     

        $sequence_13 = { 8b35???????? 39bdd8fdffff 741f 8d85d0fdffff 50 53 }
            // n = 6, score = 400
            //   8b35????????         |                     
            //   39bdd8fdffff         | cmp                 dword ptr [ebp - 0x228], edi
            //   741f                 | je                  0x21
            //   8d85d0fdffff         | lea                 eax, [ebp - 0x230]
            //   50                   | push                eax
            //   53                   | push                ebx

        $sequence_14 = { 6800020000 8d85a0fbffff 50 56 ffb59cf3ffff ff15???????? 8b3d???????? }
            // n = 7, score = 400
            //   6800020000           | push                0x200
            //   8d85a0fbffff         | lea                 eax, [ebp - 0x460]
            //   50                   | push                eax
            //   56                   | push                esi
            //   ffb59cf3ffff         | push                dword ptr [ebp - 0xc64]
            //   ff15????????         |                     
            //   8b3d????????         |                     

        $sequence_15 = { 0f847bffffff ffb59cf3ffff ffd7 8b4dfc 5f 33cd }
            // n = 6, score = 400
            //   0f847bffffff         | je                  0xffffff81
            //   ffb59cf3ffff         | push                dword ptr [ebp - 0xc64]
            //   ffd7                 | call                edi
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   5f                   | pop                 edi
            //   33cd                 | xor                 ecx, ebp

        $sequence_16 = { 89442444 8b442418 89442440 8d44243c 50 }
            // n = 5, score = 200
            //   89442444             | mov                 dword ptr [esp + 0x44], eax
            //   8b442418             | mov                 eax, dword ptr [esp + 0x18]
            //   89442440             | mov                 dword ptr [esp + 0x40], eax
            //   8d44243c             | lea                 eax, [esp + 0x3c]
            //   50                   | push                eax

        $sequence_17 = { 8bcb 50 e8???????? 83c408 8d95d8fffeff 8bf0 }
            // n = 6, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d95d8fffeff         | lea                 edx, [ebp - 0x10028]
            //   8bf0                 | mov                 esi, eax

        $sequence_18 = { c745e0d4ff4000 e9???????? c745dc03000000 c745e0e0ff4000 e9???????? 83e80f 7451 }
            // n = 7, score = 200
            //   c745e0d4ff4000       | mov                 dword ptr [ebp - 0x20], 0x40ffd4
            //   e9????????           |                     
            //   c745dc03000000       | mov                 dword ptr [ebp - 0x24], 3
            //   c745e0e0ff4000       | mov                 dword ptr [ebp - 0x20], 0x40ffe0
            //   e9????????           |                     
            //   83e80f               | sub                 eax, 0xf
            //   7451                 | je                  0x53

        $sequence_19 = { eb07 8b0cc5dc084100 894de4 85c9 }
            // n = 4, score = 200
            //   eb07                 | jmp                 9
            //   8b0cc5dc084100       | mov                 ecx, dword ptr [eax*8 + 0x4108dc]
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   85c9                 | test                ecx, ecx

        $sequence_20 = { 7417 68???????? 50 ff15???????? 85c0 7407 6a00 }
            // n = 7, score = 200
            //   7417                 | je                  0x19
            //   68????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   6a00                 | push                0

        $sequence_21 = { 7464 68???????? ff35???????? c705????????01000000 c705????????04000000 c705????????00000000 c705????????00000000 }
            // n = 7, score = 200
            //   7464                 | je                  0x66
            //   68????????           |                     
            //   ff35????????         |                     
            //   c705????????01000000     |     
            //   c705????????04000000     |     
            //   c705????????00000000     |     
            //   c705????????00000000     |     

        $sequence_22 = { 80480c01 eb04 80600cfe 807d1000 8b4604 }
            // n = 5, score = 200
            //   80480c01             | or                  byte ptr [eax + 0xc], 1
            //   eb04                 | jmp                 6
            //   80600cfe             | and                 byte ptr [eax + 0xc], 0xfe
            //   807d1000             | cmp                 byte ptr [ebp + 0x10], 0
            //   8b4604               | mov                 eax, dword ptr [esi + 4]

        $sequence_23 = { 8b4508 dd00 ebc6 c745e0e8ff4000 e9???????? c745e0f0ff4000 e9???????? }
            // n = 7, score = 200
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   dd00                 | fld                 qword ptr [eax]
            //   ebc6                 | jmp                 0xffffffc8
            //   c745e0e8ff4000       | mov                 dword ptr [ebp - 0x20], 0x40ffe8
            //   e9????????           |                     
            //   c745e0f0ff4000       | mov                 dword ptr [ebp - 0x20], 0x40fff0
            //   e9????????           |                     

        $sequence_24 = { 8b34cd18c20110 8b4d08 6a5a 2bce 5b 0fb70431 663bc7 }
            // n = 7, score = 200
            //   8b34cd18c20110       | mov                 esi, dword ptr [ecx*8 + 0x1001c218]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   6a5a                 | push                0x5a
            //   2bce                 | sub                 ecx, esi
            //   5b                   | pop                 ebx
            //   0fb70431             | movzx               eax, word ptr [ecx + esi]
            //   663bc7               | cmp                 ax, di

        $sequence_25 = { 75f9 8d7c2430 2bd6 4f 8a4701 47 84c0 }
            // n = 7, score = 200
            //   75f9                 | jne                 0xfffffffb
            //   8d7c2430             | lea                 edi, [esp + 0x30]
            //   2bd6                 | sub                 edx, esi
            //   4f                   | dec                 edi
            //   8a4701               | mov                 al, byte ptr [edi + 1]
            //   47                   | inc                 edi
            //   84c0                 | test                al, al

        $sequence_26 = { 8945dc 8b1c9dd01f0210 895de0 f6441a2848 8b5d08 0f84ce000000 }
            // n = 6, score = 200
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8b1c9dd01f0210       | mov                 ebx, dword ptr [ebx*4 + 0x10021fd0]
            //   895de0               | mov                 dword ptr [ebp - 0x20], ebx
            //   f6441a2848           | test                byte ptr [edx + ebx + 0x28], 0x48
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   0f84ce000000         | je                  0xd4

        $sequence_27 = { c7825402000000000000 c7825802000000000000 8b8350020000 898250020000 8b8354020000 }
            // n = 5, score = 200
            //   c7825402000000000000     | mov    dword ptr [edx + 0x254], 0
            //   c7825802000000000000     | mov    dword ptr [edx + 0x258], 0
            //   8b8350020000         | mov                 eax, dword ptr [ebx + 0x250]
            //   898250020000         | mov                 dword ptr [edx + 0x250], eax
            //   8b8354020000         | mov                 eax, dword ptr [ebx + 0x254]

        $sequence_28 = { f6470280 760d 68???????? e8???????? 83c404 }
            // n = 5, score = 200
            //   f6470280             | test                byte ptr [edi + 2], 0x80
            //   760d                 | jbe                 0xf
            //   68????????           |                     
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_29 = { 0f1f440000 8a02 42 84c0 75f9 8d7c2430 2bd6 }
            // n = 7, score = 200
            //   0f1f440000           | nop                 dword ptr [eax + eax]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   42                   | inc                 edx
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   8d7c2430             | lea                 edi, [esp + 0x30]
            //   2bd6                 | sub                 edx, esi

        $sequence_30 = { 660f59f5 660f28aa40fe4000 660f54e5 660f58fe }
            // n = 4, score = 200
            //   660f59f5             | mulpd               xmm6, xmm5
            //   660f28aa40fe4000     | movapd              xmm5, xmmword ptr [edx + 0x40fe40]
            //   660f54e5             | andpd               xmm4, xmm5
            //   660f58fe             | addpd               xmm7, xmm6

        $sequence_31 = { e9???????? 894ddc c745e0d8ff4000 e9???????? }
            // n = 4, score = 200
            //   e9????????           |                     
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   c745e0d8ff4000       | mov                 dword ptr [ebp - 0x20], 0x40ffd8
            //   e9????????           |                     

        $sequence_32 = { 33c2 2500800000 83f800 0f8547ffffff e9???????? 8b542408 }
            // n = 6, score = 100
            //   33c2                 | xor                 eax, edx
            //   2500800000           | and                 eax, 0x8000
            //   83f800               | cmp                 eax, 0
            //   0f8547ffffff         | jne                 0xffffff4d
            //   e9????????           |                     
            //   8b542408             | mov                 edx, dword ptr [esp + 8]

        $sequence_33 = { 59 8bf0 6a01 8bce e8???????? 8d45f8 c706???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   8bf0                 | mov                 esi, eax
            //   6a01                 | push                1
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   c706????????         |                     

        $sequence_34 = { 88d8 e2d9 8dbe00000600 8b07 09c0 }
            // n = 5, score = 100
            //   88d8                 | mov                 al, bl
            //   e2d9                 | loop                0xffffffdb
            //   8dbe00000600         | lea                 edi, [esi + 0x60000]
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   09c0                 | or                  eax, eax

        $sequence_35 = { 83eb01 741e 83eb01 7549 399ffc000000 7441 }
            // n = 6, score = 100
            //   83eb01               | sub                 ebx, 1
            //   741e                 | je                  0x20
            //   83eb01               | sub                 ebx, 1
            //   7549                 | jne                 0x4b
            //   399ffc000000         | cmp                 dword ptr [edi + 0xfc], ebx
            //   7441                 | je                  0x43

        $sequence_36 = { 894e10 e8???????? 59 59 85c0 }
            // n = 5, score = 100
            //   894e10               | mov                 dword ptr [esi + 0x10], ecx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

        $sequence_37 = { ba05000000 8d0d905b4400 e9???????? a90000f07f 752c a9ffff0f00 }
            // n = 6, score = 100
            //   ba05000000           | mov                 edx, 5
            //   8d0d905b4400         | lea                 ecx, [0x445b90]
            //   e9????????           |                     
            //   a90000f07f           | test                eax, 0x7ff00000
            //   752c                 | jne                 0x2e
            //   a9ffff0f00           | test                eax, 0xfffff

        $sequence_38 = { 773c 2b4334 99 f77d8c 894598 3b4b3c }
            // n = 6, score = 100
            //   773c                 | ja                  0x3e
            //   2b4334               | sub                 eax, dword ptr [ebx + 0x34]
            //   99                   | cdq                 
            //   f77d8c               | idiv                dword ptr [ebp - 0x74]
            //   894598               | mov                 dword ptr [ebp - 0x68], eax
            //   3b4b3c               | cmp                 ecx, dword ptr [ebx + 0x3c]

        $sequence_39 = { 7451 8b7d08 8b4514 8b4d10 }
            // n = 4, score = 100
            //   7451                 | je                  0x53
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b4514               | mov                 eax, dword ptr [ebp + 0x14]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]

    condition:
        7 of them and filesize < 983040
}