rule win_ironhalo_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ironhalo."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ironhalo"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8a800c914000 83e00f eb02 33c0 }
            // n = 4, score = 200
            //   8a800c914000         | mov                 al, byte ptr [eax + 0x40910c]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_1 = { 8bcb c1f805 83e11f 8b048560e04000 f644c80401 0f84f9000000 6a01 }
            // n = 7, score = 200
            //   8bcb                 | mov                 ecx, ebx
            //   c1f805               | sar                 eax, 5
            //   83e11f               | and                 ecx, 0x1f
            //   8b048560e04000       | mov                 eax, dword ptr [eax*4 + 0x40e060]
            //   f644c80401           | test                byte ptr [eax + ecx*8 + 4], 1
            //   0f84f9000000         | je                  0xff
            //   6a01                 | push                1

        $sequence_2 = { 6a00 56 e8???????? 56 e8???????? 8be8 83c410 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   56                   | push                esi
            //   e8????????           |                     
            //   56                   | push                esi
            //   e8????????           |                     
            //   8be8                 | mov                 ebp, eax
            //   83c410               | add                 esp, 0x10

        $sequence_3 = { ffd6 8d542410 8d442424 52 50 ffd6 8d4c2424 }
            // n = 7, score = 200
            //   ffd6                 | call                esi
            //   8d542410             | lea                 edx, [esp + 0x10]
            //   8d442424             | lea                 eax, [esp + 0x24]
            //   52                   | push                edx
            //   50                   | push                eax
            //   ffd6                 | call                esi
            //   8d4c2424             | lea                 ecx, [esp + 0x24]

        $sequence_4 = { ffd7 8d742428 bb03000000 8d442438 }
            // n = 4, score = 200
            //   ffd7                 | call                edi
            //   8d742428             | lea                 esi, [esp + 0x28]
            //   bb03000000           | mov                 ebx, 3
            //   8d442438             | lea                 eax, [esp + 0x38]

        $sequence_5 = { 243f c0e206 0ac2 83c104 88042f 45 803c3100 }
            // n = 7, score = 200
            //   243f                 | and                 al, 0x3f
            //   c0e206               | shl                 dl, 6
            //   0ac2                 | or                  al, dl
            //   83c104               | add                 ecx, 4
            //   88042f               | mov                 byte ptr [edi + ebp], al
            //   45                   | inc                 ebp
            //   803c3100             | cmp                 byte ptr [ecx + esi], 0

        $sequence_6 = { 743a 0fb6d0 f68221cf400004 741a }
            // n = 4, score = 200
            //   743a                 | je                  0x3c
            //   0fb6d0               | movzx               edx, al
            //   f68221cf400004       | test                byte ptr [edx + 0x40cf21], 4
            //   741a                 | je                  0x1c

        $sequence_7 = { 50 ffd7 8d742428 bb03000000 8d4c2438 8d542410 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   8d742428             | lea                 esi, [esp + 0x28]
            //   bb03000000           | mov                 ebx, 3
            //   8d4c2438             | lea                 ecx, [esp + 0x38]
            //   8d542410             | lea                 edx, [esp + 0x10]

        $sequence_8 = { 52 668954241c e8???????? 50 e8???????? 83c408 8d442410 }
            // n = 7, score = 200
            //   52                   | push                edx
            //   668954241c           | mov                 word ptr [esp + 0x1c], dx
            //   e8????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d442410             | lea                 eax, [esp + 0x10]

        $sequence_9 = { 6a00 6a50 50 56 ff15???????? 8be8 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6a50                 | push                0x50
            //   50                   | push                eax
            //   56                   | push                esi
            //   ff15????????         |                     
            //   8be8                 | mov                 ebp, eax

    condition:
        7 of them and filesize < 131072
}