rule win_ironwind_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ironwind."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ironwind"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bd3 488bc8 ff15???????? 83f801 0f850b010000 4c3bfb 751e }
            // n = 7, score = 100
            //   488bd3               | dec                 eax
            //   488bc8               | mov                 eax, dword ptr [esi + 0x2e8]
            //   ff15????????         |                     
            //   83f801               | test                byte ptr [eax + 0x8c], 1
            //   0f850b010000         | je                  0x1683
            //   4c3bfb               | movzx               eax, byte ptr [esi + 0x6ff]
            //   751e                 | cmp                 al, 0x1e

        $sequence_1 = { 0f848b000000 488b4dc8 ff15???????? 488b55e8 488d0d988e0400 e8???????? 488945c8 }
            // n = 7, score = 100
            //   0f848b000000         | mov                 ecx, dword ptr [esp + 0x40]
            //   488b4dc8             | dec                 eax
            //   ff15????????         |                     
            //   488b55e8             | add                 esi, 4
            //   488d0d988e0400       | inc                 ecx
            //   e8????????           |                     
            //   488945c8             | cmp                 ecx, 0x226

        $sequence_2 = { e9???????? f60603 0f95c0 88878a050000 488b4f18 }
            // n = 5, score = 100
            //   e9????????           |                     
            //   f60603               | jmp                 0x912
            //   0f95c0               | dec                 ebp
            //   88878a050000         | mov                 ecx, esp
            //   488b4f18             | dec                 eax

        $sequence_3 = { 7425 418bc8 488d15f9db0200 90 410fb60409 48ffc1 3a440aff }
            // n = 7, score = 100
            //   7425                 | dec                 esp
            //   418bc8               | lea                 ecx, [0x39890]
            //   488d15f9db0200       | dec                 esp
            //   90                   | lea                 ecx, [0x398ac]
            //   410fb60409           | dec                 esp
            //   48ffc1               | lea                 ecx, [0x398c0]
            //   3a440aff             | dec                 esp

        $sequence_4 = { 83fa01 752d 488d0d109c0600 e8???????? 488bc8 ff15???????? }
            // n = 6, score = 100
            //   83fa01               | jne                 0xe5
            //   752d                 | dec                 eax
            //   488d0d109c0600       | lea                 edx, [0x14ce9]
            //   e8????????           |                     
            //   488bc8               | dec                 eax
            //   ff15????????         |                     

        $sequence_5 = { 0f84aa030000 b001 88476c 48c70700000000 41807c246c00 743d 488bce }
            // n = 7, score = 100
            //   0f84aa030000         | arpl                word ptr [ebx + 4], ax
            //   b001                 | cmp                 eax, 9
            //   88476c               | ja                  0xf9f
            //   48c70700000000       | dec                 eax
            //   41807c246c00         | lea                 edx, [0xfffa918d]
            //   743d                 | mov                 ecx, dword ptr [edx + eax*4 + 0x57620]
            //   488bce               | dec                 eax

        $sequence_6 = { 4c896b18 33ff 0fb6ac2490000000 418b87b4060000 488b4b10 448bc0 483bc8 }
            // n = 7, score = 100
            //   4c896b18             | lea                 edx, [0x4110e]
            //   33ff                 | dec                 eax
            //   0fb6ac2490000000     | lea                 edx, [0x41def]
            //   418b87b4060000       | dec                 eax
            //   488b4b10             | mov                 ecx, ebx
            //   448bc0               | lea                 eax, [esi + 0x33]
            //   483bc8               | test                byte ptr [edi + 0x64], 1

        $sequence_7 = { 4c8d4e38 8bca 4533c0 e8???????? 85c0 0f89c9000000 48c74638ffffffff }
            // n = 7, score = 100
            //   4c8d4e38             | inc                 edx
            //   8bca                 | dec                 eax
            //   4533c0               | mov                 dword ptr [ecx + 0x28], eax
            //   e8????????           |                     
            //   85c0                 | dec                 eax
            //   0f89c9000000         | cmp                 edx, edi
            //   48c74638ffffffff     | jl                  0x255

        $sequence_8 = { 4c896c2438 4c897c2430 e8???????? 4c8be8 4885c0 0f84e0020000 488bd0 }
            // n = 7, score = 100
            //   4c896c2438           | neg                 ecx
            //   4c897c2430           | dec                 eax
            //   e8????????           |                     
            //   4c8be8               | lea                 edx, [0x2d2f0]
            //   4885c0               | dec                 eax
            //   0f84e0020000         | mov                 ecx, edi
            //   488bd0               | mov                 edx, 1

        $sequence_9 = { 807f5100 740e 80bc248000000000 0f846a020000 488b4f28 4885c9 743d }
            // n = 7, score = 100
            //   807f5100             | dec                 eax
            //   740e                 | mov                 ebp, dword ptr [esp + 0x38]
            //   80bc248000000000     | dec                 esp
            //   0f846a020000         | mov                 edi, dword ptr [esp + 0x48]
            //   488b4f28             | dec                 eax
            //   4885c9               | lea                 eax, [0x1d4bb]
            //   743d                 | inc                 ecx

    condition:
        7 of them and filesize < 995328
}