rule win_isaacwiper_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.isaacwiper."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.isaacwiper"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3bc8 737f 2bf9 8b4c2430 3bcf 0f8245020000 }
            // n = 6, score = 100
            //   3bc8                 | cmp                 ecx, eax
            //   737f                 | jae                 0x81
            //   2bf9                 | sub                 edi, ecx
            //   8b4c2430             | mov                 ecx, dword ptr [esp + 0x30]
            //   3bcf                 | cmp                 ecx, edi
            //   0f8245020000         | jb                  0x24b

        $sequence_1 = { 03c2 3bc3 8b5df4 72d5 eb37 83f802 }
            // n = 6, score = 100
            //   03c2                 | add                 eax, edx
            //   3bc3                 | cmp                 eax, ebx
            //   8b5df4               | mov                 ebx, dword ptr [ebp - 0xc]
            //   72d5                 | jb                  0xffffffd7
            //   eb37                 | jmp                 0x39
            //   83f802               | cmp                 eax, 2

        $sequence_2 = { 83e03f c1f906 6bf038 03348de8670310 837e18ff 740c 837e18fe }
            // n = 7, score = 100
            //   83e03f               | and                 eax, 0x3f
            //   c1f906               | sar                 ecx, 6
            //   6bf038               | imul                esi, eax, 0x38
            //   03348de8670310       | add                 esi, dword ptr [ecx*4 + 0x100367e8]
            //   837e18ff             | cmp                 dword ptr [esi + 0x18], -1
            //   740c                 | je                  0xe
            //   837e18fe             | cmp                 dword ptr [esi + 0x18], -2

        $sequence_3 = { 83c408 3bc3 8d48ff 0f46c1 014658 837e5815 7368 }
            // n = 7, score = 100
            //   83c408               | add                 esp, 8
            //   3bc3                 | cmp                 eax, ebx
            //   8d48ff               | lea                 ecx, [eax - 1]
            //   0f46c1               | cmovbe              eax, ecx
            //   014658               | add                 dword ptr [esi + 0x58], eax
            //   837e5815             | cmp                 dword ptr [esi + 0x58], 0x15
            //   7368                 | jae                 0x6a

        $sequence_4 = { 8b03 51 c744243007000000 8bcb 7445 ff501c 8d442430 }
            // n = 7, score = 100
            //   8b03                 | mov                 eax, dword ptr [ebx]
            //   51                   | push                ecx
            //   c744243007000000     | mov                 dword ptr [esp + 0x30], 7
            //   8bcb                 | mov                 ecx, ebx
            //   7445                 | je                  0x47
            //   ff501c               | call                dword ptr [eax + 0x1c]
            //   8d442430             | lea                 eax, [esp + 0x30]

        $sequence_5 = { 50 c7460800000000 c7461000000000 c7461400000000 e8???????? 83c404 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   c7460800000000       | mov                 dword ptr [esi + 8], 0
            //   c7461000000000       | mov                 dword ptr [esi + 0x10], 0
            //   c7461400000000       | mov                 dword ptr [esi + 0x14], 0
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { 3914c598c00210 7408 40 83f81d }
            // n = 4, score = 100
            //   3914c598c00210       | cmp                 dword ptr [eax*8 + 0x1002c098], edx
            //   7408                 | je                  0xa
            //   40                   | inc                 eax
            //   83f81d               | cmp                 eax, 0x1d

        $sequence_7 = { e8???????? 8ac8 83c404 46 83c768 84c9 75e4 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8ac8                 | mov                 cl, al
            //   83c404               | add                 esp, 4
            //   46                   | inc                 esi
            //   83c768               | add                 edi, 0x68
            //   84c9                 | test                cl, cl
            //   75e4                 | jne                 0xffffffe6

        $sequence_8 = { 8b4d0c 83d900 8945e0 894ddc c745f800000000 897dd8 895df4 }
            // n = 7, score = 100
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   83d900               | sbb                 ecx, 0
            //   8945e0               | mov                 dword ptr [ebp - 0x20], eax
            //   894ddc               | mov                 dword ptr [ebp - 0x24], ecx
            //   c745f800000000       | mov                 dword ptr [ebp - 8], 0
            //   897dd8               | mov                 dword ptr [ebp - 0x28], edi
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx

        $sequence_9 = { 69c9dfb00899 33ca 338c8634060000 890c86 40 3de3000000 72cf }
            // n = 7, score = 100
            //   69c9dfb00899         | imul                ecx, ecx, 0x9908b0df
            //   33ca                 | xor                 ecx, edx
            //   338c8634060000       | xor                 ecx, dword ptr [esi + eax*4 + 0x634]
            //   890c86               | mov                 dword ptr [esi + eax*4], ecx
            //   40                   | inc                 eax
            //   3de3000000           | cmp                 eax, 0xe3
            //   72cf                 | jb                  0xffffffd1

    condition:
        7 of them and filesize < 467968
}