rule win_isfb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.isfb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.isfb"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { eb02 33c0 3bc7 741b 50 33c0 }
            // n = 6, score = 2500
            //   eb02                 | xor                 eax, eax
            //   33c0                 | dec                 ecx
            //   3bc7                 | mov                 ecx, ebx
            //   741b                 | mov                 al, byte ptr [esi + 4]
            //   50                   | and                 al, 4
            //   33c0                 | neg                 al

        $sequence_1 = { 50 33c0 e8???????? 3bc7 740f }
            // n = 5, score = 2500
            //   50                   | je                  0xa
            //   33c0                 | dec                 eax
            //   e8????????           |                     
            //   3bc7                 | mov                 ecx, edi
            //   740f                 | dec                 eax

        $sequence_2 = { e8???????? eb02 33c0 3bc7 7413 50 }
            // n = 6, score = 2400
            //   e8????????           |                     
            //   eb02                 | push                edi
            //   33c0                 | push                dword ptr [ebp + 8]
            //   3bc7                 | push                eax
            //   7413                 | push                edi
            //   50                   | push                dword ptr [ebp + 8]

        $sequence_3 = { 3bc7 7413 50 6a10 58 e8???????? }
            // n = 6, score = 2400
            //   3bc7                 | inc                 ecx
            //   7413                 | mov                 edi, ecx
            //   50                   | jae                 0x8c
            //   6a10                 | dec                 eax
            //   58                   | mov                 ebx, dword ptr [eax]
            //   e8????????           |                     

        $sequence_4 = { 6a10 58 e8???????? 3bc7 7406 50 e8???????? }
            // n = 7, score = 2400
            //   6a10                 | and                 dword ptr [esp + 0x58], 0
            //   58                   | xor                 eax, eax
            //   e8????????           |                     
            //   3bc7                 | and                 dword ptr [esp + 0x50], eax
            //   7406                 | inc                 ecx
            //   50                   | push                esp
            //   e8????????           |                     

        $sequence_5 = { ff75f0 ff75f4 6822010000 e9???????? ff7508 }
            // n = 5, score = 2400
            //   ff75f0               | je                  0xd2
            //   ff75f4               | cmp                 eax, ebx
            //   6822010000           | jne                 0x14
            //   e9????????           |                     
            //   ff7508               | cmp                 eax, ebx

        $sequence_6 = { 6a64 ff15???????? a1???????? 85c0 7407 83ee64 }
            // n = 6, score = 2200
            //   6a64                 | pop                 eax
            //   ff15????????         |                     
            //   a1????????           |                     
            //   85c0                 | pop                 eax
            //   7407                 | cmp                 eax, edi
            //   83ee64               | je                  0xa

        $sequence_7 = { ff35???????? e8???????? 8bf0 3bf3 7443 }
            // n = 5, score = 2200
            //   ff35????????         |                     
            //   e8????????           |                     
            //   8bf0                 | je                  0xa
            //   3bf3                 | push                dword ptr [ebp + 8]
            //   7443                 | mov                 eax, edi

        $sequence_8 = { 5e 8bc5 5d 5b 59 c20400 8325????????00 }
            // n = 7, score = 2100
            //   5e                   | push                eax
            //   8bc5                 | push                esi
            //   5d                   | push                ebx
            //   5b                   | mov                 eax, 0x800
            //   59                   | push                eax
            //   c20400               | push                esi
            //   8325????????00       |                     

        $sequence_9 = { 59 c20400 8325????????00 6a00 68???????? 6a01 ff742410 }
            // n = 7, score = 2100
            //   59                   | cmp                 edi, esi
            //   c20400               | je                  0x12
            //   8325????????00       |                     
            //   6a00                 | push                edi
            //   68????????           |                     
            //   6a01                 | xor                 esi, esi
            //   ff742410             | cmp                 dword ptr [ebp - 4], esi

        $sequence_10 = { ff15???????? 85c0 a3???????? 7402 ffe0 c20400 }
            // n = 6, score = 2100
            //   ff15????????         |                     
            //   85c0                 | pop                 ebx
            //   a3????????           |                     
            //   7402                 | ret                 
            //   ffe0                 | add                 eax, 0x40
            //   c20400               | push                eax

        $sequence_11 = { 50 e8???????? 3bdf 7414 }
            // n = 4, score = 2100
            //   50                   | push                eax
            //   e8????????           |                     
            //   3bdf                 | push                0x10
            //   7414                 | pop                 eax

        $sequence_12 = { c20400 55 8bec 83ec0c a1???????? 8365f800 57 }
            // n = 7, score = 1800
            //   c20400               | je                  0x1d
            //   55                   | push                eax
            //   8bec                 | xor                 eax, eax
            //   83ec0c               | cmp                 eax, edi
            //   a1????????           |                     
            //   8365f800             | je                  0x15
            //   57                   | jmp                 4

        $sequence_13 = { ff15???????? 3c05 7506 84e4 7704 }
            // n = 5, score = 1800
            //   ff15????????         |                     
            //   3c05                 | push                ebx
            //   7506                 | push                esi
            //   84e4                 | mov                 esi, eax
            //   7704                 | mov                 al, byte ptr [esi]

        $sequence_14 = { 8b4e10 83e103 740d 51 50 ff7510 e8???????? }
            // n = 7, score = 1700
            //   8b4e10               | xor                 eax, eax
            //   83e103               | cmp                 eax, edi
            //   740d                 | je                  0x16
            //   51                   | cmp                 eax, edi
            //   50                   | je                  0x11
            //   ff7510               | push                eax
            //   e8????????           |                     

        $sequence_15 = { 7417 8b10 2b55fc 8b7d10 0155fc }
            // n = 5, score = 1700
            //   7417                 | je                  0x1d
            //   8b10                 | push                eax
            //   2b55fc               | xor                 eax, eax
            //   8b7d10               | cmp                 eax, edi
            //   0155fc               | je                  0x15

        $sequence_16 = { ff7510 e8???????? 83c40c c745fc01000000 8b4610 }
            // n = 5, score = 1700
            //   ff7510               | push                eax
            //   e8????????           |                     
            //   83c40c               | jmp                 4
            //   c745fc01000000       | xor                 eax, eax
            //   8b4610               | cmp                 eax, edi

        $sequence_17 = { 8bd8 85db 895df4 0f84c7000000 56 53 }
            // n = 6, score = 1700
            //   8bd8                 | je                  0xed
            //   85db                 | mov                 esi, dword ptr [ebx + 0x34]
            //   895df4               | lea                 eax, [esp + 0x18]
            //   0f84c7000000         | push                eax
            //   56                   | lea                 eax, [esp + 0x10]
            //   53                   | mov                 eax, dword ptr [ebx + 0x30]

        $sequence_18 = { b8???????? 53 bb60ea0000 53 ff750c }
            // n = 5, score = 1700
            //   b8????????           |                     
            //   53                   | xor                 edi, edi
            //   bb60ea0000           | jmp                 9
            //   53                   | jne                 0x31
            //   ff750c               | mov                 eax, dword ptr [ebp + 0xc]

        $sequence_19 = { 8b7d10 0155fc 83451004 83c004 49 8917 75e9 }
            // n = 7, score = 1700
            //   8b7d10               | push                eax
            //   0155fc               | xor                 eax, eax
            //   83451004             | cmp                 eax, edi
            //   83c004               | je                  0x13
            //   49                   | push                eax
            //   8917                 | je                  0x1d
            //   75e9                 | push                eax

        $sequence_20 = { ff37 ff15???????? 2b442414 50 8b07 }
            // n = 5, score = 1600
            //   ff37                 | je                  0x16
            //   ff15????????         |                     
            //   2b442414             | xor                 eax, eax
            //   50                   | cmp                 eax, edi
            //   8b07                 | je                  0x28

        $sequence_21 = { 6a0d 58 e8???????? 85c0 740d 8906 83c604 }
            // n = 7, score = 1600
            //   6a0d                 | leave               
            //   58                   | ret                 4
            //   e8????????           |                     
            //   85c0                 | push                ebx
            //   740d                 | lea                 eax, [esp + 0x30]
            //   8906                 | push                eax
            //   83c604               | lea                 eax, [esp + 0x28]

        $sequence_22 = { 83c40c 8974240c c6401a00 8b44240c 85c0 }
            // n = 5, score = 1600
            //   83c40c               | push                dword ptr [ebp + 8]
            //   8974240c             | push                ebx
            //   c6401a00             | mov                 esi, eax
            //   8b44240c             | cmp                 esi, ebx
            //   85c0                 | je                  0x47

        $sequence_23 = { 8b07 03442418 50 56 ff5310 }
            // n = 5, score = 1600
            //   8b07                 | pop                 eax
            //   03442418             | cmp                 eax, edi
            //   50                   | je                  0xa
            //   56                   | push                eax
            //   ff5310               | je                  0x15

        $sequence_24 = { 5b c20800 55 8bec 83e4f8 83ec14 8364240400 }
            // n = 7, score = 1600
            //   5b                   | push                0x122
            //   c20800               | push                dword ptr [ebp + 8]
            //   55                   | push                dword ptr [ebp - 0x10]
            //   8bec                 | push                dword ptr [ebp - 0xc]
            //   83e4f8               | push                0x122
            //   83ec14               | push                dword ptr [ebp + 8]
            //   8364240400           | push                dword ptr [ebp + 8]

        $sequence_25 = { 8906 83c604 47 83ff03 }
            // n = 4, score = 1600
            //   8906                 | je                  0x7c
            //   83c604               | push                0
            //   47                   | call                ebx
            //   83ff03               | mov                 ebx, eax

        $sequence_26 = { ff35???????? ff15???????? 8b442414 8b4c240c 8907 8b442418 894110 }
            // n = 7, score = 1600
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   8b442414             | cmp                 eax, edi
            //   8b4c240c             | je                  0x1f
            //   8907                 | push                eax
            //   8b442418             | xor                 eax, eax
            //   894110               | cmp                 eax, edi

        $sequence_27 = { 8b4b24 2b4b28 894c2410 8b4b34 f6c140 }
            // n = 5, score = 1600
            //   8b4b24               | mov                 ebx, 0xea60
            //   2b4b28               | push                ebx
            //   894c2410             | mov                 eax, esi
            //   8b4b34               | pop                 esi
            //   f6c140               | leave               

        $sequence_28 = { 8b5d0c 837b240c 56 57 8b3b 897c241c 760a }
            // n = 7, score = 1600
            //   8b5d0c               | xor                 eax, eax
            //   837b240c             | jmp                 4
            //   56                   | xor                 eax, eax
            //   57                   | cmp                 eax, edi
            //   8b3b                 | je                  0x21
            //   897c241c             | push                eax
            //   760a                 | xor                 eax, eax

        $sequence_29 = { 8b3b 897c241c 760a 8b4b20 e8???????? eb02 }
            // n = 6, score = 1600
            //   8b3b                 | cmp                 eax, edi
            //   897c241c             | je                  0x1d
            //   760a                 | push                eax
            //   8b4b20               | xor                 eax, eax
            //   e8????????           |                     
            //   eb02                 | cmp                 eax, edi

        $sequence_30 = { 74a3 33ff eb0b 33ff eb03 }
            // n = 5, score = 1500
            //   74a3                 | cmp                 eax, -1
            //   33ff                 | je                  0x31
            //   eb0b                 | inc                 esp
            //   33ff                 | mov                 eax, dword ptr [esp + 0x40]
            //   eb03                 | dec                 ebp

        $sequence_31 = { 8b4a0c 3bc8 7415 8b5210 }
            // n = 4, score = 1500
            //   8b4a0c               | pop                 eax
            //   3bc8                 | pop                 eax
            //   7415                 | cmp                 eax, edi
            //   8b5210               | je                  0xa

        $sequence_32 = { 752f 8b450c 8930 eb33 6a00 }
            // n = 5, score = 1500
            //   752f                 | push                dword ptr [ebp + 8]
            //   8b450c               | mov                 eax, edi
            //   8930                 | pop                 edi
            //   eb33                 | je                  0xa
            //   6a00                 | push                dword ptr [ebp + 8]

        $sequence_33 = { 8b4a3c 03ca 0fb75114 56 }
            // n = 4, score = 1500
            //   8b4a3c               | push                eax
            //   03ca                 | xor                 eax, eax
            //   0fb75114             | cmp                 eax, edi
            //   56                   | je                  0x17

        $sequence_34 = { 50 8d4508 50 53 8bc6 e8???????? }
            // n = 6, score = 1500
            //   50                   | jbe                 0x1a
            //   8d4508               | dec                 eax
            //   50                   | lea                 esi, [ebx + 8]
            //   53                   | dec                 eax
            //   8bc6                 | mov                 ecx, dword ptr [esi]
            //   e8????????           |                     

        $sequence_35 = { 750e 837d0800 7408 ff7508 e8???????? }
            // n = 5, score = 1500
            //   750e                 | mov                 dword ptr [esp + 0x20], esi
            //   837d0800             | dec                 eax
            //   7408                 | mov                 esi, eax
            //   ff7508               | dec                 eax
            //   e8????????           |                     

        $sequence_36 = { 83ec48 53 8b5d08 56 57 33ff }
            // n = 6, score = 1500
            //   83ec48               | mov                 eax, dword ptr [esp + 0x40]
            //   53                   | dec                 eax
            //   8b5d08               | mov                 edx, dword ptr [esp + 0x48]
            //   56                   | mov                 dword ptr [esp + 0x30], ecx
            //   57                   | cmp                 byte ptr [edi], 0x2a
            //   33ff                 | jne                 0xd

        $sequence_37 = { 8b5210 3bd0 740e 8b742408 }
            // n = 4, score = 1500
            //   8b5210               | cmp                 eax, edi
            //   3bd0                 | je                  0x19
            //   740e                 | push                eax
            //   8b742408             | push                0x10

        $sequence_38 = { 837d1800 b8???????? 7505 b8???????? 53 }
            // n = 5, score = 1500
            //   837d1800             | cmp                 esi, ebx
            //   b8????????           |                     
            //   7505                 | je                  0x45
            //   b8????????           |                     
            //   53                   | push                -1

        $sequence_39 = { 8a4604 2404 f6d8 1bc0 83e006 }
            // n = 5, score = 1400
            //   8a4604               | push                ebx
            //   2404                 | cmp                 edi, esi
            //   f6d8                 | je                  0x10
            //   1bc0                 | push                edi
            //   83e006               | push                esi

        $sequence_40 = { 742d ff75fc 6a0d 58 }
            // n = 4, score = 1400
            //   742d                 | je                  0x18
            //   ff75fc               | add                 eax, 4
            //   6a0d                 | push                eax
            //   58                   | ret                 4

        $sequence_41 = { c21000 55 8bec 83ec14 a1???????? 53 }
            // n = 6, score = 1400
            //   c21000               | cmp                 eax, edi
            //   55                   | je                  0xe
            //   8bec                 | pop                 eax
            //   83ec14               | cmp                 eax, edi
            //   a1????????           |                     
            //   53                   | je                  0xa

        $sequence_42 = { 50 57 6a01 ff75e0 68???????? e8???????? }
            // n = 6, score = 1400
            //   50                   | push                dword ptr [ebp + 8]
            //   57                   | lea                 eax, [ebp - 8]
            //   6a01                 | push                4
            //   ff75e0               | push                eax
            //   68????????           |                     
            //   e8????????           |                     

        $sequence_43 = { 53 b800080000 50 56 ff35???????? }
            // n = 5, score = 1400
            //   53                   | xor                 ebx, ebx
            //   b800080000           | mov                 dword ptr [ebp + 8], ebx
            //   50                   | jmp                 0xc
            //   56                   | xor                 ebx, ebx
            //   ff35????????         |                     

        $sequence_44 = { 8b35???????? 50 83c604 e8???????? 3bfb }
            // n = 5, score = 1300
            //   8b35????????         |                     
            //   50                   | push                ebx
            //   83c604               | mov                 esi, eax
            //   e8????????           |                     
            //   3bfb                 | cmp                 esi, ebx

        $sequence_45 = { 50 8bd7 e8???????? eb02 33c0 3bc3 741b }
            // n = 7, score = 1300
            //   50                   | mov                 esi, eax
            //   8bd7                 | cmp                 esi, ebx
            //   e8????????           |                     
            //   eb02                 | je                  0x47
            //   33c0                 | push                -1
            //   3bc3                 | mov                 esi, eax
            //   741b                 | cmp                 esi, ebx

        $sequence_46 = { 50 e8???????? 3bfb 7414 }
            // n = 4, score = 1300
            //   50                   | je                  0x47
            //   e8????????           |                     
            //   3bfb                 | push                -1
            //   7414                 | push                0xff676980

        $sequence_47 = { e8???????? 85db 7423 8b0d???????? 0fb701 }
            // n = 5, score = 1300
            //   e8????????           |                     
            //   85db                 | cmp                 eax, edi
            //   7423                 | je                  0x1f
            //   8b0d????????         |                     
            //   0fb701               | push                eax

        $sequence_48 = { ff75fc 56 ff35???????? ff15???????? 53 56 }
            // n = 6, score = 1200
            //   ff75fc               | mov                 eax, dword ptr [ebp - 4]
            //   56                   | pop                 edi
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   53                   | pop                 ebx
            //   56                   | jbe                 0x29

        $sequence_49 = { 0f854affffff 894330 e9???????? 55 }
            // n = 4, score = 1200
            //   0f854affffff         | xor                 edx, edx
            //   894330               | dec                 ecx
            //   e9????????           |                     
            //   55                   | add                 eax, 1

        $sequence_50 = { 752e 53 e8???????? 6a01 6a01 ff7514 }
            // n = 6, score = 1200
            //   752e                 | push                esi
            //   53                   | push                ebx
            //   e8????????           |                     
            //   6a01                 | push                esi
            //   6a01                 | push                dword ptr [ebp + 0xc]
            //   ff7514               | push                ebx

        $sequence_51 = { 8bf8 85ff 0f845d010000 8b4730 a808 }
            // n = 5, score = 1200
            //   8bf8                 | cmp                 edi, ebx
            //   85ff                 | je                  0x18
            //   0f845d010000         | je                  8
            //   8b4730               | push                eax
            //   a808                 | cmp                 edi, ebx

        $sequence_52 = { 0f84e2000000 8b7334 8d442418 50 8d442410 50 e8???????? }
            // n = 7, score = 1200
            //   0f84e2000000         | mov                 dword ptr [esp + 0x10], ebp
            //   8b7334               | dec                 eax
            //   8d442418             | mov                 dword ptr [esp + 0x18], esi
            //   50                   | push                edi
            //   8d442410             | dec                 eax
            //   50                   | cmovne              ecx, edx
            //   e8????????           |                     

        $sequence_53 = { 8bf8 ff7510 57 ff750c 53 e8???????? 3bfe }
            // n = 7, score = 1200
            //   8bf8                 | jne                 9
            //   ff7510               | xor                 ebx, ebx
            //   57                   | mov                 dword ptr [ebp + 8], ebx
            //   ff750c               | jmp                 0xc
            //   53                   | mov                 ebx, dword ptr [ebp + 8]
            //   e8????????           |                     
            //   3bfe                 | jne                 9

        $sequence_54 = { ff15???????? 53 56 ff35???????? ff15???????? 5b }
            // n = 6, score = 1200
            //   ff15????????         |                     
            //   53                   | push                dword ptr [ebp - 4]
            //   56                   | push                esi
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   5b                   | push                ebx

        $sequence_55 = { 0f8544010000 8b472c a801 742d }
            // n = 4, score = 1200
            //   0f8544010000         | add                 esi, 4
            //   8b472c               | cmp                 edi, ebx
            //   a801                 | je                  0x18
            //   742d                 | push                eax

        $sequence_56 = { 50 56 ff5214 8bf7 8bfe e8???????? 5f }
            // n = 7, score = 1200
            //   50                   | push                edi
            //   56                   | push                dword ptr [ebp + 8]
            //   ff5214               | lea                 eax, [ebp - 8]
            //   8bf7                 | push                4
            //   8bfe                 | push                eax
            //   e8????????           |                     
            //   5f                   | push                edi

        $sequence_57 = { 56 ff35???????? 8945f8 ff15???????? 8bd8 }
            // n = 5, score = 1200
            //   56                   | lea                 ebx, [esi + 8]
            //   ff35????????         |                     
            //   8945f8               | push                dword ptr [ebp + 0x18]
            //   ff15????????         |                     
            //   8bd8                 | mov                 eax, dword ptr [ebx]

        $sequence_58 = { 8b4330 a804 0f8451ffffff 8b470c }
            // n = 4, score = 1200
            //   8b4330               | xor                 edi, edi
            //   a804                 | cmp                 ebx, edi
            //   0f8451ffffff         | je                  0x1b
            //   8b470c               | mov                 eax, ebp

        $sequence_59 = { 33f6 3975fc 7410 ff75fc 56 ff35???????? }
            // n = 6, score = 1200
            //   33f6                 | xor                 ebx, ebx
            //   3975fc               | mov                 dword ptr [ebp + 8], ebx
            //   7410                 | jmp                 0xa
            //   ff75fc               | test                eax, eax
            //   56                   | jne                 9
            //   ff35????????         |                     

        $sequence_60 = { a840 7509 83632800 e9???????? 8b4330 a840 0f84e2000000 }
            // n = 7, score = 1200
            //   a840                 | je                  0x19
            //   7509                 | push                4
            //   83632800             | push                eax
            //   e9????????           |                     
            //   8b4330               | push                edi
            //   a840                 | push                dword ptr [ebp + 8]
            //   0f84e2000000         | push                eax

        $sequence_61 = { 53 e8???????? 3bfe 740e 57 56 }
            // n = 6, score = 1200
            //   53                   | xor                 ebx, ebx
            //   e8????????           |                     
            //   3bfe                 | mov                 dword ptr [ebp + 8], ebx
            //   740e                 | jmp                 0xc
            //   57                   | mov                 ebx, dword ptr [ebp + 8]
            //   56                   | test                eax, eax

        $sequence_62 = { 7708 0fb7c0 83e820 eb03 0fb7c0 668901 5f }
            // n = 7, score = 1100
            //   7708                 | cmp                 eax, edi
            //   0fb7c0               | je                  0x19
            //   83e820               | push                eax
            //   eb03                 | push                eax
            //   0fb7c0               | push                0x10
            //   668901               | pop                 eax
            //   5f                   | cmp                 eax, edi

        $sequence_63 = { c9 c20400 51 56 ff74240c }
            // n = 5, score = 1100
            //   c9                   | mov                 ebx, dword ptr [ebp + 8]
            //   c20400               | test                eax, eax
            //   51                   | jne                 9
            //   56                   | xor                 ebx, ebx
            //   ff74240c             | mov                 dword ptr [ebp + 8], ebx

        $sequence_64 = { e8???????? 85c0 7507 33db 895d08 eb03 }
            // n = 6, score = 1100
            //   e8????????           |                     
            //   85c0                 | push                0
            //   7507                 | jne                 0x31
            //   33db                 | mov                 eax, dword ptr [ebp + 0xc]
            //   895d08               | mov                 dword ptr [eax], esi
            //   eb03                 | jmp                 0x3a

        $sequence_65 = { 50 57 e8???????? e9???????? 68???????? }
            // n = 5, score = 1100
            //   50                   | xor                 ebx, ebx
            //   57                   | mov                 dword ptr [ebp + 8], ebx
            //   e8????????           |                     
            //   e9????????           |                     
            //   68????????           |                     

        $sequence_66 = { ff35???????? ff15???????? 33db 6a01 e8???????? }
            // n = 5, score = 1100
            //   ff35????????         |                     
            //   ff15????????         |                     
            //   33db                 | je                  0xd
            //   6a01                 | push                eax
            //   e8????????           |                     

        $sequence_67 = { 8b45fc 5f 5b c9 c21400 55 }
            // n = 6, score = 1000
            //   8b45fc               | push                dword ptr [ebp + 8]
            //   5f                   | push                0
            //   5b                   | push                edi
            //   c9                   | push                dword ptr [ebp + 8]
            //   c21400               | push                0
            //   55                   | push                0

        $sequence_68 = { 8b3d???????? 56 ffd7 53 56 ffd7 }
            // n = 6, score = 1000
            //   8b3d????????         |                     
            //   56                   | cmp                 eax, edi
            //   ffd7                 | je                  0x19
            //   53                   | push                eax
            //   56                   | push                0x10
            //   ffd7                 | pop                 eax

        $sequence_69 = { 8ac3 5b c9 c20400 53 56 8bf0 }
            // n = 7, score = 1000
            //   8ac3                 | push                dword ptr [ebp - 0xc]
            //   5b                   | push                0x122
            //   c9                   | push                dword ptr [ebp + 8]
            //   c20400               | push                dword ptr [ebp - 0x10]
            //   53                   | push                dword ptr [ebp - 0xc]
            //   56                   | push                0x122
            //   8bf0                 | push                dword ptr [ebp + 8]

        $sequence_70 = { 8bf0 8932 83c204 ff4c240c 75e6 5e 5b }
            // n = 7, score = 1000
            //   8bf0                 | jmp                 0xa
            //   8932                 | xor                 ebx, ebx
            //   83c204               | mov                 dword ptr [ebp + 8], ebx
            //   ff4c240c             | jmp                 8
            //   75e6                 | mov                 ebx, dword ptr [ebp + 8]
            //   5e                   | test                eax, eax
            //   5b                   | jne                 9

        $sequence_71 = { 8bf1 05fefeffff 33db 33c9 }
            // n = 4, score = 1000
            //   8bf1                 | push                dword ptr [ebp + 8]
            //   05fefeffff           | mov                 eax, esi
            //   33db                 | mov                 eax, dword ptr [esi]
            //   33c9                 | mov                 ecx, dword ptr [eax]

        $sequence_72 = { 750d eb09 ff7618 ff15???????? }
            // n = 4, score = 1000
            //   750d                 | xor                 ebx, ebx
            //   eb09                 | mov                 dword ptr [ebp + 8], ebx
            //   ff7618               | jmp                 0x16
            //   ff15????????         |                     

        $sequence_73 = { 8b02 43 8acb d3c0 33c6 33442410 8bf0 }
            // n = 7, score = 1000
            //   8b02                 | cmp                 edi, -1
            //   43                   | jne                 0x14
            //   8acb                 | test                eax, eax
            //   d3c0                 | jne                 0x14
            //   33c6                 | mov                 edi, eax
            //   33442410             | cmp                 edi, 0x3e5
            //   8bf0                 | test                eax, eax

        $sequence_74 = { 5b c3 a1???????? 83c040 }
            // n = 4, score = 1000
            //   5b                   | pop                 eax
            //   c3                   | jmp                 4
            //   a1????????           |                     
            //   83c040               | xor                 eax, eax

        $sequence_75 = { 3bfb 753e ff7618 8b3d???????? ffd7 ff761c }
            // n = 6, score = 1000
            //   3bfb                 | pop                 edi
            //   753e                 | xor                 edi, edi
            //   ff7618               | jmp                 0x15
            //   8b3d????????         |                     
            //   ffd7                 | xor                 edi, edi
            //   ff761c               | jmp                 0x11

        $sequence_76 = { 47 83c304 3b3e 72dc 8b45fc }
            // n = 5, score = 1000
            //   47                   | push                dword ptr [ebp + 8]
            //   83c304               | push                0
            //   3b3e                 | push                4
            //   72dc                 | push                eax
            //   8b45fc               | push                edi

        $sequence_77 = { 53 ff7614 ff15???????? 85c0 7512 ff15???????? }
            // n = 6, score = 1000
            //   53                   | test                eax, eax
            //   ff7614               | jne                 0xb
            //   ff15????????         |                     
            //   85c0                 | xor                 ebx, ebx
            //   7512                 | mov                 dword ptr [ebp + 8], ebx
            //   ff15????????         |                     

        $sequence_78 = { 8d442430 50 8d442428 50 8d442428 50 }
            // n = 6, score = 900
            //   8d442430             | mov                 ecx, dword ptr [ebx + 0x34]
            //   50                   | test                cl, 0x40
            //   8d442428             | push                eax
            //   50                   | mov                 eax, dword ptr [esp + 0x14]
            //   8d442428             | mov                 ecx, dword ptr [esp + 0xc]
            //   50                   | mov                 dword ptr [edi], eax

        $sequence_79 = { 488bd8 0f8405010000 488bc8 ff15???????? }
            // n = 4, score = 900
            //   488bd8               | cmp                 eax, edi
            //   0f8405010000         | je                  0x1f
            //   488bc8               | push                eax
            //   ff15????????         |                     

        $sequence_80 = { 7416 a1???????? 83c004 50 be???????? }
            // n = 5, score = 900
            //   7416                 | je                  0x1d
            //   a1????????           |                     
            //   83c004               | push                eax
            //   50                   | xor                 eax, eax
            //   be????????           |                     

        $sequence_81 = { e8???????? e9???????? b909010000 e9???????? }
            // n = 4, score = 900
            //   e8????????           |                     
            //   e9????????           |                     
            //   b909010000           | push                eax
            //   e9????????           |                     

        $sequence_82 = { ff15???????? 488bcf 48870d???????? 483bcf 7405 }
            // n = 5, score = 900
            //   ff15????????         |                     
            //   488bcf               | push                ebx
            //   48870d????????       |                     
            //   483bcf               | cmp                 edi, esi
            //   7405                 | je                  0x13

        $sequence_83 = { c744242000010000 ff15???????? 4883f8ff 488bf8 7442 }
            // n = 5, score = 900
            //   c744242000010000     | xor                 eax, eax
            //   ff15????????         |                     
            //   4883f8ff             | xor                 eax, eax
            //   488bf8               | cmp                 eax, edi
            //   7442                 | je                  0x1d

        $sequence_84 = { b90e010000 41b800000100 4889442420 e8???????? e9???????? }
            // n = 5, score = 900
            //   b90e010000           | push                eax
            //   41b800000100         | xor                 eax, eax
            //   4889442420           | cmp                 eax, edi
            //   e8????????           |                     
            //   e9????????           |                     

        $sequence_85 = { 741d 3dd2100000 7416 a1???????? }
            // n = 4, score = 900
            //   741d                 | je                  0x1f
            //   3dd2100000           | push                eax
            //   7416                 | xor                 eax, eax
            //   a1????????           |                     

        $sequence_86 = { ff35???????? ffd3 8bd8 85db 7476 }
            // n = 5, score = 900
            //   ff35????????         |                     
            //   ffd3                 | mov                 ecx, dword ptr [esp + 0xc]
            //   8bd8                 | mov                 dword ptr [edi], eax
            //   85db                 | mov                 dword ptr [edi], eax
            //   7476                 | mov                 eax, dword ptr [esp + 0x18]

        $sequence_87 = { 898c24f0000000 4533c9 4533c0 498bcb ff5028 }
            // n = 5, score = 800
            //   898c24f0000000       | pop                 ecx
            //   4533c9               | ret                 4
            //   4533c0               | push                0
            //   498bcb               | pop                 ebx
            //   ff5028               | pop                 ecx

        $sequence_88 = { 0f8386000000 488b18 8364245800 33c0 21442450 21442454 }
            // n = 6, score = 800
            //   0f8386000000         | jmp                 4
            //   488b18               | xor                 eax, eax
            //   8364245800           | cmp                 eax, edi
            //   33c0                 | je                  0x1f
            //   21442450             | push                eax
            //   21442454             | cmp                 eax, edi

        $sequence_89 = { 6a03 8935???????? 8935???????? 8935???????? }
            // n = 4, score = 800
            //   6a03                 | pop                 esi
            //   8935????????         |                     
            //   8935????????         |                     
            //   8935????????         |                     

        $sequence_90 = { 488bcf c744242860ea0000 4c0f45c8 48895c2420 e8???????? 85c0 8bd8 }
            // n = 7, score = 800
            //   488bcf               | push                eax
            //   c744242860ea0000     | add                 esi, 4
            //   4c0f45c8             | cmp                 edi, ebx
            //   48895c2420           | add                 esi, 4
            //   e8????????           |                     
            //   85c0                 | cmp                 edi, ebx
            //   8bd8                 | je                  0x18

        $sequence_91 = { 53 56 8bf1 05fefeffff }
            // n = 4, score = 800
            //   53                   | mov                 eax, esi
            //   56                   | mov                 eax, dword ptr [esi]
            //   8bf1                 | mov                 ecx, dword ptr [eax]
            //   05fefeffff           | push                ebx

        $sequence_92 = { a1???????? 25efff0000 0bc2 e9???????? }
            // n = 4, score = 800
            //   a1????????           |                     
            //   25efff0000           | pop                 ebx
            //   0bc2                 | mov                 dword ptr [edx], esi
            //   e9????????           |                     

        $sequence_93 = { 898424f4000000 498b03 898c24f0000000 4533c9 }
            // n = 4, score = 800
            //   898424f4000000       | pop                 ebx
            //   498b03               | pop                 ecx
            //   898c24f0000000       | ret                 4
            //   4533c9               | pop                 ebx

        $sequence_94 = { 33db 66ba2000 498bcc ff15???????? 4885c0 488bf8 7417 }
            // n = 7, score = 800
            //   33db                 | mov                 esi, edi
            //   66ba2000             | mov                 edi, esi
            //   498bcc               | pop                 edi
            //   ff15????????         |                     
            //   4885c0               | pop                 esi
            //   488bf8               | pop                 ebx
            //   7417                 | je                  0xe8

        $sequence_95 = { 8b8c2490000000 83bc248800000000 4c8b442440 488b542448 }
            // n = 4, score = 800
            //   8b8c2490000000       | push                eax
            //   83bc248800000000     | cmp                 edi, ebx
            //   4c8b442440           | je                  8
            //   488b542448           | push                eax

        $sequence_96 = { e9???????? 4885f6 7417 4863461c 2b6e1c 4c03e8 488b4610 }
            // n = 7, score = 800
            //   e9????????           |                     
            //   4885f6               | je                  0x23
            //   7417                 | cmp                 eax, ebx
            //   4863461c             | je                  0x11
            //   2b6e1c               | push                eax
            //   4c03e8               | add                 esi, 4
            //   488b4610             | push                eax

        $sequence_97 = { 4883ec20 488bf1 488b0d???????? 4c8be2 }
            // n = 4, score = 800
            //   4883ec20             | cmp                 edi, ebx
            //   488bf1               | cmp                 eax, ebx
            //   488b0d????????       |                     
            //   4c8be2               | je                  0x11

        $sequence_98 = { 4154 4155 4883ec30 33db 33ed 418bf9 48215810 }
            // n = 7, score = 800
            //   4154                 | je                  0x1f
            //   4155                 | push                eax
            //   4883ec30             | jmp                 4
            //   33db                 | xor                 eax, eax
            //   33ed                 | cmp                 eax, edi
            //   418bf9               | je                  0x1f
            //   48215810             | push                eax

        $sequence_99 = { 488b0d???????? 448bc3 33d2 41c1e003 ff15???????? 4885c0 488be8 }
            // n = 7, score = 800
            //   488b0d????????       |                     
            //   448bc3               | cmp                 edi, ebx
            //   33d2                 | pop                 eax
            //   41c1e003             | cmp                 eax, ebx
            //   ff15????????         |                     
            //   4885c0               | je                  0xa
            //   488be8               | push                eax

        $sequence_100 = { 0f84eb000000 83780408 0f84d9000000 488bcb e8???????? }
            // n = 5, score = 800
            //   0f84eb000000         | je                  0x15
            //   83780408             | push                0x5c
            //   0f84d9000000         | push                ebx
            //   488bcb               | push                dword ptr [ebp + 0x10]
            //   e8????????           |                     

        $sequence_101 = { 488b0d???????? 33d2 ff15???????? bb01000000 498bcc eb07 83c301 }
            // n = 7, score = 800
            //   488b0d????????       |                     
            //   33d2                 | je                  0x1b
            //   ff15????????         |                     
            //   bb01000000           | mov                 eax, dword ptr [ebx + 0x30]
            //   498bcc               | test                al, 0x40
            //   eb07                 | je                  0xea
            //   83c301               | call                dword ptr [edx + 0x14]

        $sequence_102 = { 895df4 895df0 c745f857000000 bf19010000 }
            // n = 4, score = 800
            //   895df4               | lea                 eax, [esi + 0x18]
            //   895df0               | mov                 ecx, dword ptr [eax]
            //   c745f857000000       | push                dword ptr [ebp + 8]
            //   bf19010000           | mov                 eax, esi

        $sequence_103 = { eb08 488bce e8???????? 488b5c2440 488b742448 488bc7 }
            // n = 6, score = 800
            //   eb08                 | push                ebx
            //   488bce               | cmp                 edi, esi
            //   e8????????           |                     
            //   488b5c2440           | je                  0x12
            //   488b742448           | push                edi
            //   488bc7               | xor                 esi, esi

        $sequence_104 = { 488b5610 4d8bc6 488bc8 e8???????? 4863561c 8bc5 2b461c }
            // n = 7, score = 800
            //   488b5610             | cmp                 edi, ebx
            //   4d8bc6               | je                  0x18
            //   488bc8               | add                 esi, 4
            //   e8????????           |                     
            //   4863561c             | cmp                 edi, ebx
            //   8bc5                 | je                  0x18
            //   2b461c               | cmp                 eax, ebx

        $sequence_105 = { 488bcf ff15???????? 4c8964dd00 83c301 }
            // n = 4, score = 800
            //   488bcf               | push                dword ptr [ebp - 0xc]
            //   ff15????????         |                     
            //   4c8964dd00           | push                0x122
            //   83c301               | push                dword ptr [ebp + 8]

        $sequence_106 = { 5f c20400 55 8bec 83e4f8 81ec9c000000 53 }
            // n = 7, score = 700
            //   5f                   | push                eax
            //   c20400               | xor                 eax, eax
            //   55                   | xor                 eax, eax
            //   8bec                 | cmp                 eax, edi
            //   83e4f8               | je                  0x1d
            //   81ec9c000000         | push                eax
            //   53                   | xor                 eax, eax

        $sequence_107 = { 8bc7 e8???????? 8d4618 8b08 50 51 ff7614 }
            // n = 7, score = 700
            //   8bc7                 | dec                 dword ptr [esp + 0xc]
            //   e8????????           |                     
            //   8d4618               | jne                 0xfffffffa
            //   8b08                 | pop                 esi
            //   50                   | pop                 ebx
            //   51                   | mov                 esi, eax
            //   ff7614               | mov                 dword ptr [edx], esi

        $sequence_108 = { 8bc6 e8???????? 8b06 8b08 57 }
            // n = 5, score = 700
            //   8bc6                 | dec                 dword ptr [esp + 0xc]
            //   e8????????           |                     
            //   8b06                 | jne                 0xffffffe8
            //   8b08                 | pop                 esi
            //   57                   | pop                 ebx

        $sequence_109 = { 6a20 40 50 ffd6 }
            // n = 4, score = 700
            //   6a20                 | xor                 eax, eax
            //   40                   | cmp                 eax, edi
            //   50                   | je                  0x11
            //   ffd6                 | je                  0x1d

        $sequence_110 = { 5e 33c0 c9 c20400 55 8bec 51 }
            // n = 7, score = 700
            //   5e                   | push                eax
            //   33c0                 | xor                 eax, eax
            //   c9                   | cmp                 eax, edi
            //   c20400               | jmp                 4
            //   55                   | xor                 eax, eax
            //   8bec                 | cmp                 eax, edi
            //   51                   | je                  0x1f

        $sequence_111 = { 4c8bcf 4889442428 8364242000 33d2 33c9 ff15???????? }
            // n = 6, score = 600
            //   4c8bcf               | add                 eax, 0xc
            //   4889442428           | dec                 esp
            //   8364242000           | arpl                ax, ax
            //   33d2                 | xor                 edx, edx
            //   33c9                 | dec                 ecx
            //   ff15????????         |                     

        $sequence_112 = { 7557 813d????????04df2209 743c 8d4604 50 }
            // n = 5, score = 600
            //   7557                 | jmp                 4
            //   813d????????04df2209     |     
            //   743c                 | xor                 eax, eax
            //   8d4604               | cmp                 eax, edi
            //   50                   | je                  0x1f

        $sequence_113 = { 488b0d???????? 4c63c0 33d2 4983c00c ff15???????? }
            // n = 5, score = 600
            //   488b0d????????       |                     
            //   4c63c0               | dec                 esp
            //   33d2                 | arpl                ax, ax
            //   4983c00c             | xor                 edx, edx
            //   ff15????????         |                     

        $sequence_114 = { ff15???????? 83cfff 3bc7 8bd8 }
            // n = 4, score = 600
            //   ff15????????         |                     
            //   83cfff               | push                eax
            //   3bc7                 | add                 esi, 4
            //   8bd8                 | cmp                 edi, ebx

        $sequence_115 = { 480f45ca 488bc1 4883c438 c3 48895c2408 48896c2410 4889742418 }
            // n = 7, score = 600
            //   480f45ca             | xor                 eax, eax
            //   488bc1               | cmp                 eax, ebx
            //   4883c438             | je                  0x1b
            //   c3                   | push                eax
            //   48895c2408           | cmp                 eax, ebx
            //   48896c2410           | je                  0x11
            //   4889742418           | push                eax

        $sequence_116 = { 448bc0 8bd8 33d2 4983c001 }
            // n = 4, score = 600
            //   448bc0               | add                 esi, 4
            //   8bd8                 | cmp                 edi, ebx
            //   33d2                 | je                  0x11
            //   4983c001             | push                eax

        $sequence_117 = { e9???????? 488bcb ff15???????? a810 }
            // n = 4, score = 600
            //   e9????????           |                     
            //   488bcb               | dec                 esp
            //   ff15????????         |                     
            //   a810                 | arpl                ax, ax

        $sequence_118 = { ff15???????? 8945f8 85c0 7418 3bd8 7514 57 }
            // n = 7, score = 600
            //   ff15????????         |                     
            //   8945f8               | cmp                 eax, edi
            //   85c0                 | je                  0x15
            //   7418                 | cmp                 eax, edi
            //   3bd8                 | je                  0x1f
            //   7514                 | push                eax
            //   57                   | xor                 eax, eax

        $sequence_119 = { 803f2a 750b 4883c701 83c3ff }
            // n = 4, score = 600
            //   803f2a               | add                 esi, 4
            //   750b                 | xor                 eax, eax
            //   4883c701             | cmp                 eax, ebx
            //   83c3ff               | je                  0x13

        $sequence_120 = { 85ff 756f 8b0d???????? 8b05???????? }
            // n = 4, score = 500
            //   85ff                 | push                eax
            //   756f                 | add                 esi, 4
            //   8b0d????????         |                     
            //   8b05????????         |                     

        $sequence_121 = { 4d03c0 33d2 ff15???????? 488be8 }
            // n = 4, score = 500
            //   4d03c0               | dec                 eax
            //   33d2                 | mov                 ecx, eax
            //   ff15????????         |                     
            //   488be8               | dec                 eax

        $sequence_122 = { 75ee 488bd5 33c9 ff15???????? 488bf8 }
            // n = 5, score = 500
            //   75ee                 | dec                 esp
            //   488bd5               | mov                 ecx, edi
            //   33c9                 | dec                 eax
            //   ff15????????         |                     
            //   488bf8               | mov                 dword ptr [esp + 0x28], eax

        $sequence_123 = { 488bf8 4885c0 7420 488bd3 488bc8 ff15???????? 488b0d???????? }
            // n = 7, score = 500
            //   488bf8               | dec                 eax
            //   4885c0               | mov                 edx, ebx
            //   7420                 | mov                 dword ptr [esp + 0x28], 0x80
            //   488bd3               | mov                 dword ptr [esp + 0x20], esi
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488b0d????????       |                     

        $sequence_124 = { 741d 397b04 7618 488d7308 488b0e ff15???????? ffc7 }
            // n = 7, score = 500
            //   741d                 | je                  0x34
            //   397b04               | jne                 0xfffffff0
            //   7618                 | dec                 eax
            //   488d7308             | mov                 edx, ebp
            //   488b0e               | xor                 ecx, ecx
            //   ff15????????         |                     
            //   ffc7                 | dec                 eax

        $sequence_125 = { c744242880000000 89742420 ff15???????? 488bf0 4883f8ff 742b }
            // n = 6, score = 500
            //   c744242880000000     | dec                 eax
            //   89742420             | mov                 dword ptr [esp + 0x28], eax
            //   ff15????????         |                     
            //   488bf0               | and                 dword ptr [esp + 0x20], 0
            //   4883f8ff             | xor                 edx, edx
            //   742b                 | xor                 ecx, ecx

        $sequence_126 = { 7510 488b0b e8???????? 85c0 0f859b000000 }
            // n = 5, score = 400
            //   7510                 | mov                 eax, dword ptr [ebx + 0x30]
            //   488b0b               | test                al, 0x40
            //   e8????????           |                     
            //   85c0                 | je                  0xe8
            //   0f859b000000         | mov                 esi, dword ptr [ebx + 0x34]

        $sequence_127 = { 85c0 0f8561010000 8b4348 a801 742c 488b0b e8???????? }
            // n = 7, score = 400
            //   85c0                 | mov                 esi, edi
            //   0f8561010000         | mov                 edi, esi
            //   8b4348               | pop                 edi
            //   a801                 | pop                 esi
            //   742c                 | push                esi
            //   488b0b               | call                dword ptr [edx + 0x14]
            //   e8????????           |                     

        $sequence_128 = { 85c0 0f859b000000 4863533c 488b4608 }
            // n = 4, score = 400
            //   85c0                 | test                al, 4
            //   0f859b000000         | je                  0xffffff5c
            //   4863533c             | test                al, 0x40
            //   488b4608             | je                  0xe8

        $sequence_129 = { 8b434c 84c0 0f89a3000000 8b434c a804 7415 }
            // n = 6, score = 400
            //   8b434c               | mov                 eax, dword ptr [ebx + 0x30]
            //   84c0                 | test                al, 0x40
            //   0f89a3000000         | je                  0xed
            //   8b434c               | mov                 esi, dword ptr [ebx + 0x34]
            //   a804                 | mov                 eax, dword ptr [ebx + 0x30]
            //   7415                 | test                al, 0x40

        $sequence_130 = { 85c0 0f85e8000000 488b4608 488b0e 4533c9 }
            // n = 5, score = 400
            //   85c0                 | test                al, 0x40
            //   0f85e8000000         | je                  0xe8
            //   488b4608             | je                  0xe8
            //   488b0e               | mov                 esi, dword ptr [ebx + 0x34]
            //   4533c9               | lea                 eax, [esp + 0x18]

        $sequence_131 = { e8???????? 85c0 0f8561010000 8b4348 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   85c0                 | lea                 eax, [esp + 0x18]
            //   0f8561010000         | jne                 0xb
            //   8b4348               | and                 dword ptr [ebx + 0x28], 0

        $sequence_132 = { 7505 217b3c eb0b 8b434c 84c0 0f89a3000000 }
            // n = 6, score = 400
            //   7505                 | test                al, 8
            //   217b3c               | test                eax, eax
            //   eb0b                 | jne                 0x14a
            //   8b434c               | mov                 eax, dword ptr [edi + 0x2c]
            //   84c0                 | test                al, 1
            //   0f89a3000000         | je                  0x3a

        $sequence_133 = { 7508 8b5304 83c304 01f2 8b4c241c 01d1 }
            // n = 6, score = 300
            //   7508                 | mov                 dword ptr [esp + 0xf4], eax
            //   8b5304               | dec                 ecx
            //   83c304               | mov                 eax, dword ptr [ebx]
            //   01f2                 | mov                 dword ptr [esp + 0xf0], ecx
            //   8b4c241c             | inc                 ebp
            //   01d1                 | xor                 ecx, ecx

        $sequence_134 = { 8b4c2424 01c1 83c304 894c2410 56 90 }
            // n = 6, score = 300
            //   8b4c2424             | mov                 dword ptr [esp + 0xf4], eax
            //   01c1                 | dec                 ecx
            //   83c304               | mov                 eax, dword ptr [ebx]
            //   894c2410             | mov                 dword ptr [esp + 0xf0], ecx
            //   56                   | inc                 ebp
            //   90                   | xor                 ecx, ecx

        $sequence_135 = { 40 c1ca08 e2e4 c9 }
            // n = 4, score = 300
            //   40                   | xor                 ecx, ecx
            //   c1ca08               | inc                 ebp
            //   e2e4                 | xor                 eax, eax
            //   c9                   | dec                 ecx

        $sequence_136 = { 56 57 51 64ff3530000000 58 8b400c }
            // n = 6, score = 300
            //   56                   | mov                 ecx, ebx
            //   57                   | dec                 ecx
            //   51                   | mov                 eax, dword ptr [ebx]
            //   64ff3530000000       | mov                 dword ptr [esp + 0xf0], ecx
            //   58                   | inc                 ebp
            //   8b400c               | xor                 ecx, ecx

        $sequence_137 = { 30c9 eb67 8044241301 0fb6ca 01cb }
            // n = 5, score = 300
            //   30c9                 | inc                 ebp
            //   eb67                 | xor                 eax, eax
            //   8044241301           | dec                 ecx
            //   0fb6ca               | mov                 ecx, ebx
            //   01cb                 | call                dword ptr [eax + 0x28]

        $sequence_138 = { 89ec 5d c20c00 60 }
            // n = 4, score = 300
            //   89ec                 | call                dword ptr [eax + 0x28]
            //   5d                   | mov                 dword ptr [esp + 0xf0], ecx
            //   c20c00               | inc                 ebp
            //   60                   | xor                 ecx, ecx

        $sequence_139 = { 90 89ce 83e603 750c 8b5d10 }
            // n = 5, score = 300
            //   90                   | inc                 ebp
            //   89ce                 | xor                 eax, eax
            //   83e603               | dec                 ecx
            //   750c                 | mov                 ecx, ebx
            //   8b5d10               | call                dword ptr [eax + 0x28]

        $sequence_140 = { 8b3a 83c204 8b0a 83e908 }
            // n = 4, score = 300
            //   8b3a                 | inc                 ebp
            //   83c204               | xor                 eax, eax
            //   8b0a                 | dec                 ecx
            //   83e908               | mov                 ecx, ebx

    condition:
        7 of them and filesize < 2940928
}