rule win_ismagent_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ismagent."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ismagent"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 68000000a0 ff7510 51 57 ffd0 68???????? }
            // n = 6, score = 200
            //   68000000a0           | push                0xa0000000
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ffd0                 | call                eax
            //   68????????           |                     

        $sequence_1 = { 50 56 57 8d942418170000 }
            // n = 4, score = 200
            //   50                   | push                eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   8d942418170000       | lea                 edx, [esp + 0x1718]

        $sequence_2 = { 68e8030000 50 8d8424580b0000 50 e8???????? 83c40c 8d842418030000 }
            // n = 7, score = 200
            //   68e8030000           | push                0x3e8
            //   50                   | push                eax
            //   8d8424580b0000       | lea                 eax, [esp + 0xb58]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   8d842418030000       | lea                 eax, [esp + 0x318]

        $sequence_3 = { f3a4 8dbc24183e0000 4f 90 }
            // n = 4, score = 200
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8dbc24183e0000       | lea                 edi, [esp + 0x3e18]
            //   4f                   | dec                 edi
            //   90                   | nop                 

        $sequence_4 = { 33c9 660f1f840000000000 8a81a00a4200 8d4901 88840c370f0000 84c0 }
            // n = 6, score = 200
            //   33c9                 | xor                 ecx, ecx
            //   660f1f840000000000     | nop    word ptr [eax + eax]
            //   8a81a00a4200         | mov                 al, byte ptr [ecx + 0x420aa0]
            //   8d4901               | lea                 ecx, [ecx + 1]
            //   88840c370f0000       | mov                 byte ptr [esp + ecx + 0xf37], al
            //   84c0                 | test                al, al

        $sequence_5 = { 66a5 8b7c2418 837c241400 742d 8bc8 8d5101 }
            // n = 6, score = 200
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]
            //   8b7c2418             | mov                 edi, dword ptr [esp + 0x18]
            //   837c241400           | cmp                 dword ptr [esp + 0x14], 0
            //   742d                 | je                  0x2f
            //   8bc8                 | mov                 ecx, eax
            //   8d5101               | lea                 edx, [ecx + 1]

        $sequence_6 = { c744243400000000 e8???????? 8b4c2428 8d442444 }
            // n = 4, score = 200
            //   c744243400000000     | mov                 dword ptr [esp + 0x34], 0
            //   e8????????           |                     
            //   8b4c2428             | mov                 ecx, dword ptr [esp + 0x28]
            //   8d442444             | lea                 eax, [esp + 0x44]

        $sequence_7 = { 51 8b4c2434 8d942418070000 50 6a01 }
            // n = 5, score = 200
            //   51                   | push                ecx
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   8d942418070000       | lea                 edx, [esp + 0x718]
            //   50                   | push                eax
            //   6a01                 | push                1

    condition:
        7 of them and filesize < 327680
}