rule win_ismdoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.ismdoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.ismdoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 83f8ff 7504 32c0 eb05 c0e804 2401 84c0 }
            // n = 7, score = 400
            //   83f8ff               | cmp                 eax, -1
            //   7504                 | jne                 6
            //   32c0                 | xor                 al, al
            //   eb05                 | jmp                 7
            //   c0e804               | shr                 al, 4
            //   2401                 | and                 al, 1
            //   84c0                 | test                al, al

        $sequence_1 = { 488bd6 488bcb ff5048 4885c0 750e }
            // n = 5, score = 300
            //   488bd6               | dec                 eax
            //   488bcb               | mov                 dword ptr [ebp + 0x140], 7
            //   ff5048               | je                  0x1b
            //   4885c0               | dec                 eax
            //   750e                 | lea                 ecx, [ebp - 0x40]

        $sequence_2 = { 7419 488d4dc0 e8???????? 483bd8 7405 }
            // n = 5, score = 300
            //   7419                 | dec                 esp
            //   488d4dc0             | mov                 dword ptr [ebp + 0x138], edi
            //   e8????????           |                     
            //   483bd8               | dec                 esp
            //   7405                 | mov                 dword ptr [ebp + 0x140], edi

        $sequence_3 = { 448bc3 4963c0 4585c0 7514 }
            // n = 4, score = 300
            //   448bc3               | mov                 edx, esi
            //   4963c0               | dec                 eax
            //   4585c0               | mov                 ecx, ebx
            //   7514                 | call                dword ptr [eax + 0x48]

        $sequence_4 = { 90 c685200100006b 4c89bd38010000 4c89bd40010000 48c7854001000007000000 }
            // n = 5, score = 300
            //   90                   | lea                 eax, [ebp - 0x10]
            //   c685200100006b       | dec                 eax
            //   4c89bd38010000       | mov                 edx, eax
            //   4c89bd40010000       | nop                 
            //   48c7854001000007000000     | mov    byte ptr [ebp + 0x120], 0x6b

        $sequence_5 = { 488d4c2448 e8???????? 90 4c8d45f0 488bd0 }
            // n = 5, score = 300
            //   488d4c2448           | dec                 eax
            //   e8????????           |                     
            //   90                   | lea                 ecx, [esp + 0x48]
            //   4c8d45f0             | nop                 
            //   488bd0               | dec                 esp

        $sequence_6 = { 488b45b8 48898310020000 48898318020000 48898320020000 }
            // n = 4, score = 300
            //   488b45b8             | dec                 eax
            //   48898310020000       | cmp                 ebx, eax
            //   48898318020000       | je                  0xe
            //   48898320020000       | dec                 eax

        $sequence_7 = { e9???????? 4532ed 488d8db0010000 e8???????? }
            // n = 4, score = 300
            //   e9????????           |                     
            //   4532ed               | dec                 eax
            //   488d8db0010000       | test                eax, eax
            //   e8????????           |                     

        $sequence_8 = { eb02 33c0 8bbdccfbffff 6bc009 0fb6bc38107a4700 8bc7 }
            // n = 6, score = 100
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   8bbdccfbffff         | mov                 edi, dword ptr [ebp - 0x434]
            //   6bc009               | imul                eax, eax, 9
            //   0fb6bc38107a4700     | movzx               edi, byte ptr [eax + edi + 0x477a10]
            //   8bc7                 | mov                 eax, edi

        $sequence_9 = { e8???????? 83f8ff 7e3c ff75ec }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7e3c                 | jle                 0x3e
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_10 = { 52 50 e8???????? 68e8030000 ffd6 }
            // n = 5, score = 100
            //   52                   | push                edx
            //   50                   | push                eax
            //   e8????????           |                     
            //   68e8030000           | push                0x3e8
            //   ffd6                 | call                esi

        $sequence_11 = { c645fc3f e9???????? 6a00 68???????? }
            // n = 4, score = 100
            //   c645fc3f             | mov                 byte ptr [ebp - 4], 0x3f
            //   e9????????           |                     
            //   6a00                 | push                0
            //   68????????           |                     

        $sequence_12 = { c785f0fdffff00000000 50 6a00 6a00 6a1d 8bf1 }
            // n = 6, score = 100
            //   c785f0fdffff00000000     | mov    dword ptr [ebp - 0x210], 0
            //   50                   | push                eax
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a1d                 | push                0x1d
            //   8bf1                 | mov                 esi, ecx

        $sequence_13 = { 46 83fe10 7cdb ff75d0 8d55e8 }
            // n = 5, score = 100
            //   46                   | inc                 esi
            //   83fe10               | cmp                 esi, 0x10
            //   7cdb                 | jl                  0xffffffdd
            //   ff75d0               | push                dword ptr [ebp - 0x30]
            //   8d55e8               | lea                 edx, [ebp - 0x18]

        $sequence_14 = { 8bc8 eb0c 0fb6c0 0fbe8040714800 03c8 }
            // n = 5, score = 100
            //   8bc8                 | mov                 ecx, eax
            //   eb0c                 | jmp                 0xe
            //   0fb6c0               | movzx               eax, al
            //   0fbe8040714800       | movsx               eax, byte ptr [eax + 0x487140]
            //   03c8                 | add                 ecx, eax

    condition:
        7 of them and filesize < 1933312
}