rule win_isspace_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.isspace."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.isspace"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a23 eb04 6a00 6a2b 68???????? 6a00 }
            // n = 6, score = 200
            //   6a23                 | push                0x23
            //   eb04                 | jmp                 6
            //   6a00                 | push                0
            //   6a2b                 | push                0x2b
            //   68????????           |                     
            //   6a00                 | push                0

        $sequence_1 = { 6800200300 a3???????? e8???????? 6800200300 }
            // n = 4, score = 200
            //   6800200300           | push                0x32000
            //   a3????????           |                     
            //   e8????????           |                     
            //   6800200300           | push                0x32000

        $sequence_2 = { 33c5 50 8d45f0 64a300000000 8965e8 c745fc00000000 ff15???????? }
            // n = 7, score = 200
            //   33c5                 | xor                 eax, ebp
            //   50                   | push                eax
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   64a300000000         | mov                 dword ptr fs:[0], eax
            //   8965e8               | mov                 dword ptr [ebp - 0x18], esp
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   ff15????????         |                     

        $sequence_3 = { eb19 6a00 6a1c eb0a 6a00 6a23 }
            // n = 6, score = 200
            //   eb19                 | jmp                 0x1b
            //   6a00                 | push                0
            //   6a1c                 | push                0x1c
            //   eb0a                 | jmp                 0xc
            //   6a00                 | push                0
            //   6a23                 | push                0x23

        $sequence_4 = { 6a00 68???????? 68???????? 68???????? 53 ff15???????? 8bf0 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   68????????           |                     
            //   68????????           |                     
            //   68????????           |                     
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { 50 50 6a03 6a02 ff15???????? 894604 }
            // n = 6, score = 200
            //   50                   | push                eax
            //   50                   | push                eax
            //   6a03                 | push                3
            //   6a02                 | push                2
            //   ff15????????         |                     
            //   894604               | mov                 dword ptr [esi + 4], eax

        $sequence_6 = { e8???????? 6800010000 8d8600010000 6a00 }
            // n = 4, score = 200
            //   e8????????           |                     
            //   6800010000           | push                0x100
            //   8d8600010000         | lea                 eax, [esi + 0x100]
            //   6a00                 | push                0

        $sequence_7 = { 6a00 6a00 6800010000 53 6aff }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800010000           | push                0x100
            //   53                   | push                ebx
            //   6aff                 | push                -1

    condition:
        7 of them and filesize < 434176
}