rule win_jaff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jaff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jaff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 395604 760b 8b36 0fb73456 8975f4 }
            // n = 5, score = 600
            //   395604               | cmp                 dword ptr [esi + 4], edx
            //   760b                 | jbe                 0xd
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   0fb73456             | movzx               esi, word ptr [esi + edx*2]
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi

        $sequence_1 = { 8b55c8 33c0 8bca 85d2 7419 8b75c4 66833c4600 }
            // n = 7, score = 600
            //   8b55c8               | mov                 edx, dword ptr [ebp - 0x38]
            //   33c0                 | xor                 eax, eax
            //   8bca                 | mov                 ecx, edx
            //   85d2                 | test                edx, edx
            //   7419                 | je                  0x1b
            //   8b75c4               | mov                 esi, dword ptr [ebp - 0x3c]
            //   66833c4600           | cmp                 word ptr [esi + eax*2], 0

        $sequence_2 = { 8b4de0 8b3d???????? 51 6a00 ffd7 50 }
            // n = 6, score = 600
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]
            //   8b3d????????         |                     
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   50                   | push                eax

        $sequence_3 = { 668b144a 66891448 41 3b4e04 72f0 8b4e04 }
            // n = 6, score = 600
            //   668b144a             | mov                 dx, word ptr [edx + ecx*2]
            //   66891448             | mov                 word ptr [eax + ecx*2], dx
            //   41                   | inc                 ecx
            //   3b4e04               | cmp                 ecx, dword ptr [esi + 4]
            //   72f0                 | jb                  0xfffffff2
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]

        $sequence_4 = { ffd7 50 ffd3 8b7d0c 8b4f04 }
            // n = 5, score = 600
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]

        $sequence_5 = { 50 6a00 ffd7 50 ff15???????? 5f 8bc6 }
            // n = 7, score = 600
            //   50                   | push                eax
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ff15????????         |                     
            //   5f                   | pop                 edi
            //   8bc6                 | mov                 eax, esi

        $sequence_6 = { 56 8945f8 ffd3 8945fc 83f808 7705 }
            // n = 6, score = 600
            //   56                   | push                esi
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   ffd3                 | call                ebx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   83f808               | cmp                 eax, 8
            //   7705                 | ja                  7

        $sequence_7 = { 41 3b4df8 76a8 8b4d08 80790c00 740d 8b5510 }
            // n = 7, score = 600
            //   41                   | inc                 ecx
            //   3b4df8               | cmp                 ecx, dword ptr [ebp - 8]
            //   76a8                 | jbe                 0xffffffaa
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]
            //   80790c00             | cmp                 byte ptr [ecx + 0xc], 0
            //   740d                 | je                  0xf
            //   8b5510               | mov                 edx, dword ptr [ebp + 0x10]

        $sequence_8 = { 8b4ddc 8b3d???????? 51 6a00 ffd7 50 ffd3 }
            // n = 7, score = 600
            //   8b4ddc               | mov                 ecx, dword ptr [ebp - 0x24]
            //   8b3d????????         |                     
            //   51                   | push                ecx
            //   6a00                 | push                0
            //   ffd7                 | call                edi
            //   50                   | push                eax
            //   ffd3                 | call                ebx

        $sequence_9 = { 0fb70448 eb02 33c0 0fbff0 2b45f4 0fbffa 03f7 }
            // n = 7, score = 600
            //   0fb70448             | movzx               eax, word ptr [eax + ecx*2]
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax
            //   0fbff0               | movsx               esi, ax
            //   2b45f4               | sub                 eax, dword ptr [ebp - 0xc]
            //   0fbffa               | movsx               edi, dx
            //   03f7                 | add                 esi, edi

    condition:
        7 of them and filesize < 106496
}