rule win_jager_decryptor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2020-05-30"
        version = "1"
        description = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.4.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jager_decryptor"
        malpedia_rule_date = "20200529"
        malpedia_hash = "92c362319514e5a6da26204961446caa3a8b32a8"
        malpedia_version = "20200529"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using yara-signator.
     * The code and documentation / approach is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f613 34f1 43 b3f2 7faf }
            // n = 5, score = 100
            //   f613                 | not                 byte ptr [ebx]
            //   34f1                 | xor                 al, 0xf1
            //   43                   | inc                 ebx
            //   b3f2                 | mov                 bl, 0xf2
            //   7faf                 | jg                  0xffffffb1

        $sequence_1 = { e5b6 46 ed 682dfb6ab6 12e1 830001 }
            // n = 6, score = 100
            //   e5b6                 | in                  eax, 0xb6
            //   46                   | inc                 esi
            //   ed                   | in                  eax, dx
            //   682dfb6ab6           | push                0xb66afb2d
            //   12e1                 | adc                 ah, cl
            //   830001               | add                 dword ptr [eax], 1

        $sequence_2 = { 0c7a 2f 6862f5e1f3 9d 93 }
            // n = 5, score = 100
            //   0c7a                 | or                  al, 0x7a
            //   2f                   | das                 
            //   6862f5e1f3           | push                0xf3e1f562
            //   9d                   | popfd               
            //   93                   | xchg                eax, ebx

        $sequence_3 = { a4 a1???????? 00a9a6a200a2 aa a3???????? 00a8a8a500ad }
            // n = 6, score = 100
            //   a4                   | movsb               byte ptr es:[edi], byte ptr [esi]
            //   a1????????           |                     
            //   00a9a6a200a2         | add                 byte ptr [ecx - 0x5dff5d5a], ch
            //   aa                   | stosb               byte ptr es:[edi], al
            //   a3????????           |                     
            //   00a8a8a500ad         | add                 byte ptr [eax - 0x52ff5a58], ch

        $sequence_4 = { 3db2cffab9 90 9e 4d 2967ed 77b3 9c }
            // n = 7, score = 100
            //   3db2cffab9           | cmp                 eax, 0xb9facfb2
            //   90                   | nop                 
            //   9e                   | sahf                
            //   4d                   | dec                 ebp
            //   2967ed               | sub                 dword ptr [edi - 0x13], esp
            //   77b3                 | ja                  0xffffffb5
            //   9c                   | pushfd              

        $sequence_5 = { b579 12d7 a99b254bcd a1???????? }
            // n = 4, score = 100
            //   b579                 | mov                 ch, 0x79
            //   12d7                 | adc                 dl, bh
            //   a99b254bcd           | test                eax, 0xcd4b259b
            //   a1????????           |                     

        $sequence_6 = { 109e62002394 61 001a a0???????? 650013 a5 690017a76e00 }
            // n = 7, score = 100
            //   109e62002394         | adc                 byte ptr [esi - 0x6bdcff9e], bl
            //   61                   | popal               
            //   001a                 | add                 byte ptr [edx], bl
            //   a0????????           |                     
            //   650013               | add                 byte ptr gs:[ebx], dl
            //   a5                   | movsd               dword ptr es:[edi], dword ptr [esi]
            //   690017a76e00         | imul                eax, dword ptr [eax], 0x6ea717

        $sequence_7 = { 6c 7777 1dc5bd4323 813aba349719 }
            // n = 4, score = 100
            //   6c                   | insb                byte ptr es:[edi], dx
            //   7777                 | ja                  0x79
            //   1dc5bd4323           | sbb                 eax, 0x2343bdc5
            //   813aba349719         | cmp                 dword ptr [edx], 0x199734ba

        $sequence_8 = { 1d9eeb7ffb aa 4e 9e b0f2 26c2e6a0 368187b9a26a7de76f8a82 }
            // n = 7, score = 100
            //   1d9eeb7ffb           | sbb                 eax, 0xfb7feb9e
            //   aa                   | stosb               byte ptr es:[edi], al
            //   4e                   | dec                 esi
            //   9e                   | sahf                
            //   b0f2                 | mov                 al, 0xf2
            //   26c2e6a0             | ret                 0xa0e6
            //   368187b9a26a7de76f8a82     | add    dword ptr ss:[edi + 0x7d6aa2b9], 0x828a6fe7

        $sequence_9 = { c828cee1 3029 1ca1 f5 }
            // n = 4, score = 100
            //   c828cee1             | enter               -0x31d8, -0x1f
            //   3029                 | xor                 byte ptr [ecx], ch
            //   1ca1                 | sbb                 al, 0xa1
            //   f5                   | cmc                 

    condition:
        7 of them and filesize < 4136960
}