rule win_jaku_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jaku."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jaku"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 3945f8 0f94c0 eb02 32c0 }
            // n = 4, score = 1500
            //   3945f8               | cmp                 dword ptr [ebp - 8], eax
            //   0f94c0               | sete                al
            //   eb02                 | jmp                 4
            //   32c0                 | xor                 al, al

        $sequence_1 = { 8bcf 83e107 d3eb 2bf9 895df4 83ff20 }
            // n = 6, score = 1500
            //   8bcf                 | mov                 ecx, edi
            //   83e107               | and                 ecx, 7
            //   d3eb                 | shr                 ebx, cl
            //   2bf9                 | sub                 edi, ecx
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   83ff20               | cmp                 edi, 0x20

        $sequence_2 = { b83c800000 e8???????? 53 56 57 6a38 8d45c4 }
            // n = 7, score = 1500
            //   b83c800000           | mov                 eax, 0x803c
            //   e8????????           |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a38                 | push                0x38
            //   8d45c4               | lea                 eax, [ebp - 0x3c]

        $sequence_3 = { 33db 894618 895df4 c70601000000 e9???????? 8b4620 }
            // n = 6, score = 1500
            //   33db                 | xor                 ebx, ebx
            //   894618               | mov                 dword ptr [esi + 0x18], eax
            //   895df4               | mov                 dword ptr [ebp - 0xc], ebx
            //   c70601000000         | mov                 dword ptr [esi], 1
            //   e9????????           |                     
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]

        $sequence_4 = { 83c204 8bfa d3e7 8b4e14 6609beb8160000 }
            // n = 5, score = 1500
            //   83c204               | add                 edx, 4
            //   8bfa                 | mov                 edi, edx
            //   d3e7                 | shl                 edi, cl
            //   8b4e14               | mov                 ecx, dword ptr [esi + 0x14]
            //   6609beb8160000       | or                  word ptr [esi + 0x16b8], di

        $sequence_5 = { 7573 8bc3 83e00f 3c08 0f85a6000000 8b4624 83ef04 }
            // n = 7, score = 1500
            //   7573                 | jne                 0x75
            //   8bc3                 | mov                 eax, ebx
            //   83e00f               | and                 eax, 0xf
            //   3c08                 | cmp                 al, 8
            //   0f85a6000000         | jne                 0xac
            //   8b4624               | mov                 eax, dword ptr [esi + 0x24]
            //   83ef04               | sub                 edi, 4

        $sequence_6 = { 880c07 8b02 8a4df8 884c0701 8b0a 8bc6 2bc1 }
            // n = 7, score = 1500
            //   880c07               | mov                 byte ptr [edi + eax], cl
            //   8b02                 | mov                 eax, dword ptr [edx]
            //   8a4df8               | mov                 cl, byte ptr [ebp - 8]
            //   884c0701             | mov                 byte ptr [edi + eax + 1], cl
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   8bc6                 | mov                 eax, esi
            //   2bc1                 | sub                 eax, ecx

        $sequence_7 = { 2bf8 83c410 85ff 7fd7 5b 56 }
            // n = 6, score = 1500
            //   2bf8                 | sub                 edi, eax
            //   83c410               | add                 esp, 0x10
            //   85ff                 | test                edi, edi
            //   7fd7                 | jg                  0xffffffd9
            //   5b                   | pop                 ebx
            //   56                   | push                esi

        $sequence_8 = { 68???????? ff15???????? c3 b8???????? e8???????? 83ec2c }
            // n = 6, score = 800
            //   68????????           |                     
            //   ff15????????         |                     
            //   c3                   | ret                 
            //   b8????????           |                     
            //   e8????????           |                     
            //   83ec2c               | sub                 esp, 0x2c

        $sequence_9 = { ff742408 e8???????? c20800 8bc1 }
            // n = 4, score = 600
            //   ff742408             | push                dword ptr [esp + 8]
            //   e8????????           |                     
            //   c20800               | ret                 8
            //   8bc1                 | mov                 eax, ecx

        $sequence_10 = { 53 68000000a0 6a03 53 }
            // n = 4, score = 500
            //   53                   | push                ebx
            //   68000000a0           | push                0xa0000000
            //   6a03                 | push                3
            //   53                   | push                ebx

        $sequence_11 = { 7507 b800308000 eb02 33c0 }
            // n = 4, score = 500
            //   7507                 | jne                 9
            //   b800308000           | mov                 eax, 0x803000
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_12 = { 7508 83c8ff e9???????? 8b839f830000 }
            // n = 4, score = 500
            //   7508                 | jne                 0xa
            //   83c8ff               | or                  eax, 0xffffffff
            //   e9????????           |                     
            //   8b839f830000         | mov                 eax, dword ptr [ebx + 0x839f]

        $sequence_13 = { 6a01 03c3 68???????? 50 e8???????? 83c40c }
            // n = 6, score = 500
            //   6a01                 | push                1
            //   03c3                 | add                 eax, ebx
            //   68????????           |                     
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_14 = { 5b c3 55 8bec 833d????????00 53 56 }
            // n = 7, score = 500
            //   5b                   | pop                 ebx
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   833d????????00       |                     
            //   53                   | push                ebx
            //   56                   | push                esi

        $sequence_15 = { 55 56 57 6880020000 }
            // n = 4, score = 500
            //   55                   | push                ebp
            //   56                   | push                esi
            //   57                   | push                edi
            //   6880020000           | push                0x280

        $sequence_16 = { 75dd 57 e8???????? 59 }
            // n = 4, score = 500
            //   75dd                 | jne                 0xffffffdf
            //   57                   | push                edi
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_17 = { 0245fd 3245fe 8a4dff d2c8 }
            // n = 4, score = 400
            //   0245fd               | add                 al, byte ptr [ebp - 3]
            //   3245fe               | xor                 al, byte ptr [ebp - 2]
            //   8a4dff               | mov                 cl, byte ptr [ebp - 1]
            //   d2c8                 | ror                 al, cl

        $sequence_18 = { 50 e8???????? 59 8b4e2c }
            // n = 4, score = 400
            //   50                   | push                eax
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b4e2c               | mov                 ecx, dword ptr [esi + 0x2c]

        $sequence_19 = { 85ff 897c240c 750c 5f 5e b801000000 5b }
            // n = 7, score = 400
            //   85ff                 | test                edi, edi
            //   897c240c             | mov                 dword ptr [esp + 0xc], edi
            //   750c                 | jne                 0xe
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   b801000000           | mov                 eax, 1
            //   5b                   | pop                 ebx

        $sequence_20 = { 56 e8???????? 59 8b4620 }
            // n = 4, score = 400
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   8b4620               | mov                 eax, dword ptr [esi + 0x20]

        $sequence_21 = { e8???????? 59 eb57 53 }
            // n = 4, score = 400
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   eb57                 | jmp                 0x59
            //   53                   | push                ebx

        $sequence_22 = { 016c242c 8b44242c 5f 5e 5d }
            // n = 5, score = 400
            //   016c242c             | add                 dword ptr [esp + 0x2c], ebp
            //   8b44242c             | mov                 eax, dword ptr [esp + 0x2c]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp

        $sequence_23 = { 50 894528 e8???????? 83c410 8b3d???????? 53 }
            // n = 6, score = 300
            //   50                   | push                eax
            //   894528               | mov                 dword ptr [ebp + 0x28], eax
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   8b3d????????         |                     
            //   53                   | push                ebx

        $sequence_24 = { 53 53 53 6aff ff7528 bee9fd0000 }
            // n = 6, score = 300
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   6aff                 | push                -1
            //   ff7528               | push                dword ptr [ebp + 0x28]
            //   bee9fd0000           | mov                 esi, 0xfde9

        $sequence_25 = { 56 57 8965f0 33ff 897dfc c645fc01 837d1c10 }
            // n = 7, score = 300
            //   56                   | push                esi
            //   57                   | push                edi
            //   8965f0               | mov                 dword ptr [ebp - 0x10], esp
            //   33ff                 | xor                 edi, edi
            //   897dfc               | mov                 dword ptr [ebp - 4], edi
            //   c645fc01             | mov                 byte ptr [ebp - 4], 1
            //   837d1c10             | cmp                 dword ptr [ebp + 0x1c], 0x10

        $sequence_26 = { 8bbe9b830000 33db 8d4f01 43 }
            // n = 4, score = 300
            //   8bbe9b830000         | mov                 edi, dword ptr [esi + 0x839b]
            //   33db                 | xor                 ebx, ebx
            //   8d4f01               | lea                 ecx, [edi + 1]
            //   43                   | inc                 ebx

        $sequence_27 = { 6a00 8b9580faffff 837a3000 750b 8b8db4f9ffff 83c904 eb06 }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   8b9580faffff         | mov                 edx, dword ptr [ebp - 0x580]
            //   837a3000             | cmp                 dword ptr [edx + 0x30], 0
            //   750b                 | jne                 0xd
            //   8b8db4f9ffff         | mov                 ecx, dword ptr [ebp - 0x64c]
            //   83c904               | or                  ecx, 4
            //   eb06                 | jmp                 8

        $sequence_28 = { 6a00 53 56 e8???????? 83c41c 8b55f8 8345f8ff }
            // n = 7, score = 200
            //   6a00                 | push                0
            //   53                   | push                ebx
            //   56                   | push                esi
            //   e8????????           |                     
            //   83c41c               | add                 esp, 0x1c
            //   8b55f8               | mov                 edx, dword ptr [ebp - 8]
            //   8345f8ff             | add                 dword ptr [ebp - 8], -1

    condition:
        7 of them and filesize < 2220032
}