rule win_jessiecontea_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jessiecontea."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jessiecontea"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d85a8f9ffff 50 8d85f8fbffff 50 ff15???????? }
            // n = 5, score = 300
            //   8d85a8f9ffff         | lea                 eax, [ebp - 0x658]
            //   50                   | push                eax
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]
            //   50                   | push                eax
            //   ff15????????         |                     

        $sequence_1 = { 8b7d18 8945c0 8b4510 8945c4 8b451c }
            // n = 5, score = 300
            //   8b7d18               | mov                 edi, dword ptr [ebp + 0x18]
            //   8945c0               | mov                 dword ptr [ebp - 0x40], eax
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8945c4               | mov                 dword ptr [ebp - 0x3c], eax
            //   8b451c               | mov                 eax, dword ptr [ebp + 0x1c]

        $sequence_2 = { 660fdbe3 660fdfc8 660febe1 3bd6 0f826effffff 660ffee5 0f28c4 }
            // n = 7, score = 300
            //   660fdbe3             | pand                xmm4, xmm3
            //   660fdfc8             | pandn               xmm1, xmm0
            //   660febe1             | por                 xmm4, xmm1
            //   3bd6                 | cmp                 edx, esi
            //   0f826effffff         | jb                  0xffffff74
            //   660ffee5             | paddd               xmm4, xmm5
            //   0f28c4               | movaps              xmm0, xmm4

        $sequence_3 = { e8???????? 83c418 c7857cf0ffffffffff7f c78580f0ffffffffff7f b8ea650000 c7858cf0ffff00000000 }
            // n = 6, score = 300
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   c7857cf0ffffffffff7f     | mov    dword ptr [ebp - 0xf84], 0x7fffffff
            //   c78580f0ffffffffff7f     | mov    dword ptr [ebp - 0xf80], 0x7fffffff
            //   b8ea650000           | mov                 eax, 0x65ea
            //   c7858cf0ffff00000000     | mov    dword ptr [ebp - 0xf74], 0

        $sequence_4 = { 50 51 8d8df8f7ffff e8???????? 8d85f8f7ffff 6a5c 50 }
            // n = 7, score = 300
            //   50                   | push                eax
            //   51                   | push                ecx
            //   8d8df8f7ffff         | lea                 ecx, [ebp - 0x808]
            //   e8????????           |                     
            //   8d85f8f7ffff         | lea                 eax, [ebp - 0x808]
            //   6a5c                 | push                0x5c
            //   50                   | push                eax

        $sequence_5 = { 745b 8b35???????? 57 ffd6 3d04010000 7d4b }
            // n = 6, score = 300
            //   745b                 | je                  0x5d
            //   8b35????????         |                     
            //   57                   | push                edi
            //   ffd6                 | call                esi
            //   3d04010000           | cmp                 eax, 0x104
            //   7d4b                 | jge                 0x4d

        $sequence_6 = { 83c404 85f6 7425 8bbd7cf4ffff 68???????? }
            // n = 5, score = 300
            //   83c404               | add                 esp, 4
            //   85f6                 | test                esi, esi
            //   7425                 | je                  0x27
            //   8bbd7cf4ffff         | mov                 edi, dword ptr [ebp - 0xb84]
            //   68????????           |                     

        $sequence_7 = { 7f0a 8bb5f0b7ffff 3bfe 7293 }
            // n = 4, score = 300
            //   7f0a                 | jg                  0xc
            //   8bb5f0b7ffff         | mov                 esi, dword ptr [ebp - 0x4810]
            //   3bfe                 | cmp                 edi, esi
            //   7293                 | jb                  0xffffff95

        $sequence_8 = { 452be5 488d152b6bfeff 4489642440 0f8574fcffff }
            // n = 4, score = 100
            //   452be5               | inc                 ebp
            //   488d152b6bfeff       | sub                 esp, ebp
            //   4489642440           | dec                 eax
            //   0f8574fcffff         | lea                 edx, [0xfffe6b2b]

        $sequence_9 = { 6603c1 0fb70d???????? 0fb7c0 33c8 66898dde000000 }
            // n = 5, score = 100
            //   6603c1               | movzx               ecx, ax
            //   0fb70d????????       |                     
            //   0fb7c0               | xor                 eax, ecx
            //   33c8                 | mov                 word ptr [ebp - 0x64], ax
            //   66898dde000000       | mov                 eax, dword ptr [ebp - 0x80]

        $sequence_10 = { 83c008 668945d8 0fb705???????? 83c008 668945da }
            // n = 5, score = 100
            //   83c008               | dec                 eax
            //   668945d8             | mov                 dword ptr [esp + 0x40], edx
            //   0fb705????????       |                     
            //   83c008               | dec                 eax
            //   668945da             | mov                 edi, edx

        $sequence_11 = { 6683c00c 0fb7c8 8b05???????? 33c1 6689459c 8b4580 }
            // n = 6, score = 100
            //   6683c00c             | dec                 eax
            //   0fb7c8               | mov                 ecx, edi
            //   8b05????????         |                     
            //   33c1                 | dec                 eax
            //   6689459c             | lea                 edx, [ebp + 0x5e0]
            //   8b4580               | dec                 eax

        $sequence_12 = { 4889542440 488bfa be01000000 ff15???????? }
            // n = 4, score = 100
            //   4889542440           | mov                 dword ptr [esp + 0x30], eax
            //   488bfa               | dec                 eax
            //   be01000000           | lea                 ecx, [esi + 0x10]
            //   ff15????????         |                     

        $sequence_13 = { 4889442430 488d4e10 4889442428 4c8bcb }
            // n = 4, score = 100
            //   4889442430           | dec                 eax
            //   488d4e10             | mov                 dword ptr [esp + 0x20], esi
            //   4889442428           | dec                 esp
            //   4c8bcb               | lea                 eax, [ebp + 0x4d0]

        $sequence_14 = { 4533c9 4889742420 4c8d85d0040000 488bcf 488d95e0050000 }
            // n = 5, score = 100
            //   4533c9               | inc                 esp
            //   4889742420           | mov                 dword ptr [esp + 0x40], esp
            //   4c8d85d0040000       | jne                 0xfffffc7a
            //   488bcf               | inc                 ebp
            //   488d95e0050000       | xor                 ecx, ecx

        $sequence_15 = { 817c2440949dd460 7489 33c0 4c8ba424880b0000 488b9c24800b0000 }
            // n = 5, score = 100
            //   817c2440949dd460     | dec                 eax
            //   7489                 | mov                 dword ptr [esp + 0x28], eax
            //   33c0                 | dec                 esp
            //   4c8ba424880b0000     | mov                 ecx, ebx
            //   488b9c24800b0000     | add                 ax, 0xc

    condition:
        7 of them and filesize < 413696
}