rule win_jinxloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.jinxloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.jinxloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { c3 0f10442440 90 488b8c2488000000 0f1101 0f10442450 0f114110 }
            // n = 7, score = 100
            //   c3                   | mov                 dword ptr [edx + 0x60], ecx
            //   0f10442440           | mov                 edi, 1
            //   90                   | dec                 eax
            //   488b8c2488000000     | lea                 esi, [0x1e3363]
            //   0f1101               | nop                 dword ptr [eax]
            //   0f10442450           | dec                 eax
            //   0f114110             | mov                 edx, dword ptr [esp + 0x118]

        $sequence_1 = { e8???????? 488b942498000000 498913 488910 48c7401802000000 4c8d0521e42000 4c894010 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b942498000000     | mov                 eax, dword ptr [esp + 0x58]
            //   498913               | dec                 eax
            //   488910               | mov                 ebx, dword ptr [esp + 0x18]
            //   48c7401802000000     | dec                 eax
            //   4c8d0521e42000       | lea                 eax, [0x5f7ac2]
            //   4c894010             | mov                 ebx, 1

        $sequence_2 = { e8???????? 488b9424c8020000 498913 488d5818 488bb080000000 49897308 488bb424c0020000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488b9424c8020000     | dec                 eax
            //   498913               | mov                 ecx, dword ptr [esp + 0x10]
            //   488d5818             | dec                 eax
            //   488bb080000000       | mov                 dword ptr [eax + 8], ecx
            //   49897308             | nop                 
            //   488bb424c0020000     | jne                 0x1d01

        $sequence_3 = { eb21 488d7e58 90 eb1a 488d7e38 eb14 488d7e38 }
            // n = 7, score = 100
            //   eb21                 | mov                 ebx, eax
            //   488d7e58             | dec                 eax
            //   90                   | lea                 eax, [0x5074ba]
            //   eb1a                 | dec                 eax
            //   488d7e38             | mov                 eax, ecx
            //   eb14                 | dec                 esp
            //   488d7e38             | mov                 ecx, eax

        $sequence_4 = { c3 31c0 4889fb 4889f1 4881c408010000 5d c3 }
            // n = 7, score = 100
            //   c3                   | mov                 edi, 1
            //   31c0                 | dec                 eax
            //   4889fb               | lea                 esi, [0xfe39e]
            //   4889f1               | dec                 eax
            //   4881c408010000       | mov                 edx, dword ptr [esp + 0x58]
            //   5d                   | dec                 eax
            //   c3                   | mov                 dword ptr [edx + 0x10], ecx

        $sequence_5 = { b801000000 4881c430010000 5d c3 488b8424f0000000 4883c010 488b4c2450 }
            // n = 7, score = 100
            //   b801000000           | lea                 eax, [0x42116d]
            //   4881c430010000       | dec                 eax
            //   5d                   | mov                 edx, dword ptr [esp + 0x60]
            //   c3                   | dec                 eax
            //   488b8424f0000000     | mov                 dword ptr [eax + 0x18], edx
            //   4883c010             | jne                 0x929
            //   488b4c2450           | nop                 

        $sequence_6 = { e8???????? 833d????????00 750a 488b8c2448170000 eb10 e8???????? 488b8c2448170000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   833d????????00       |                     
            //   750a                 | inc                 dword ptr [ecx + 0x58]
            //   488b8c2448170000     | dec                 eax
            //   eb10                 | mov                 ecx, dword ptr [esp + 0x1a0]
            //   e8????????           |                     
            //   488b8c2448170000     | dec                 eax

        $sequence_7 = { eb0d e8???????? 488b542440 498913 48895018 488d1d78464b00 4889c1 }
            // n = 7, score = 100
            //   eb0d                 | dec                 ecx
            //   e8????????           |                     
            //   488b542440           | mov                 dword ptr [ebx], eax
            //   498913               | dec                 ecx
            //   48895018             | mov                 dword ptr [ebx + 8], edx
            //   488d1d78464b00       | dec                 eax
            //   4889c1               | mov                 edx, 0x644fc805

        $sequence_8 = { f20f11442428 f20f104808 f20f114c2420 e8???????? 488b442458 488b5c2418 e8???????? }
            // n = 7, score = 100
            //   f20f11442428         | nop                 
            //   f20f104808           | jmp                 0x96f
            //   f20f114c2420         | dec                 eax
            //   e8????????           |                     
            //   488b442458           | mov                 edx, esi
            //   488b5c2418           | xor                 edi, edi
            //   e8????????           |                     

        $sequence_9 = { e8???????? 488d8424d0000000 488b9c2408020000 488b4c2458 488bbc2418020000 e8???????? 488d8424d0000000 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d8424d0000000     | lea                 eax, [0x52b647]
            //   488b9c2408020000     | mov                 ebx, 7
            //   488b4c2458           | nop                 
            //   488bbc2418020000     | dec                 eax
            //   e8????????           |                     
            //   488d8424d0000000     | mov                 eax, dword ptr [esp + 0x88]

    condition:
        7 of them and filesize < 20364288
}